/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.cgm;

import com.bbn.openmap.dataAccess.cgm.CGMDisplay;
import com.bbn.openmap.dataAccess.cgm.Command;
import java.io.DataInputStream;
import java.io.IOException;

public class PolylineElement
extends Command {
    int[] X;
    int[] Y;
    int[] X0;
    int[] Y0;

    public PolylineElement(int ec, int eid, int l, DataInputStream in) throws IOException {
        super(ec, eid, l, in);
        int n = this.args.length / 4;
        this.X = new int[n];
        this.Y = new int[n];
        int i = 0;
        while (i < n) {
            this.X[i] = this.makeInt(2 * i);
            this.Y[i] = this.makeInt(2 * i + 1);
            ++i;
        }
    }

    public String toString() {
        String s = "Polyline";
        int i = 0;
        while (i < this.X.length) {
            s = s + " [" + this.X[i] + "," + this.Y[i] + "]";
            ++i;
        }
        return s;
    }

    public void scale(CGMDisplay d) {
        this.X0 = new int[this.X.length];
        this.Y0 = new int[this.X.length];
        int i = 0;
        while (i < this.X.length) {
            this.X0[i] = d.x(this.X[i]);
            this.Y0[i] = d.y(this.Y[i]);
            ++i;
        }
    }

    public void paint(CGMDisplay d) {
        d.graphics().setColor(d.getLineColor());
        d.graphics().drawPolyline(this.X0, this.Y0, this.X0.length);
    }
}

