/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.app;

import com.bbn.openmap.MapHandler;
import com.bbn.openmap.PropertyHandler;
import com.bbn.openmap.gui.BasicMapPanel;
import com.bbn.openmap.gui.MapPanel;
import com.bbn.openmap.gui.OpenMapFrame;
import com.bbn.openmap.util.ArgParser;
import com.bbn.openmap.util.Debug;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.SwingUtilities;

public class OpenMap {
    protected MapPanel mapPanel;

    public OpenMap() {
        this(null);
    }

    public OpenMap(PropertyHandler propertyHandler) {
        this.mapPanel = new BasicMapPanel(propertyHandler);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                OpenMap.this.showInFrame();
            }
        });
    }

    public void showInFrame() {
        OpenMapFrame omf = new OpenMapFrame();
        this.setWindowListenerOnFrame(omf);
        this.getMapHandler().add(omf);
        omf.show();
        this.mapPanel.getMapBean().showLayerPalettes();
        Debug.message("basic", "OpenMap: READY");
    }

    public void setWindowListenerOnFrame(OpenMapFrame omf) {
        omf.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public MapHandler getMapHandler() {
        return this.mapPanel.getMapHandler();
    }

    public MapPanel getMapPanel() {
        return this.mapPanel;
    }

    public static OpenMap create() {
        return new OpenMap(null);
    }

    public static OpenMap create(String propertiesFile) {
        Debug.init();
        PropertyHandler propertyHandler = null;
        if (propertiesFile != null) {
            try {
                propertyHandler = new PropertyHandler(propertiesFile);
            }
            catch (MalformedURLException murle) {
                Debug.error(murle.getMessage());
                murle.printStackTrace();
                propertyHandler = null;
            }
            catch (IOException ioe) {
                Debug.error(ioe.getMessage());
                ioe.printStackTrace();
                propertyHandler = null;
            }
        }
        return new OpenMap(propertyHandler);
    }

    public static void main(String[] args) {
        ArgParser ap = new ArgParser("OpenMap");
        String propArgs = null;
        ap.add("properties", "A resource, file path or URL to properties file\n Ex: http://myhost.com/xyz.props or file:/myhome/abc.pro\n See Java Documentation for java.net.URL class for more details", 1);
        ap.parse(args);
        String[] arg = ap.getArgValues("properties");
        if (arg != null) {
            propArgs = arg[0];
        }
        OpenMap.create(propArgs);
    }
}

