/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task.dataSetBrowser;

import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import javax.swing.tree.DefaultMutableTreeNode;

public class SeismogramTreeNode
extends DefaultMutableTreeNode {
    private String name;
    private DataSet dataset;
    private DataSetSeismogram seismogram = null;

    public SeismogramTreeNode(DataSetSeismogram seis) {
        super(seis, false);
        this.seismogram = seis;
        this.dataset = seis.getDataSet();
        this.name = seis.getName();
        if (this.name == null || this.name.length() == 0) {
            this.name = seis.toString();
        }
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public boolean isLeaf() {
        return true;
    }

    public String toString() {
        return this.name;
    }

    public DataSetSeismogram getSeismogram() {
        if (this.seismogram != null) {
            return this.seismogram;
        }
        return this.dataset.getDataSetSeismogram(this.name);
    }

    public String getName() {
        return this.name;
    }

    public DataSet getDataSet() {
        return this.dataset;
    }
}

