/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task.dataSetBrowser;

import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetTreeCellRenderer;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetTreeModel;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.SeismogramSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.SeismogramTreeNode;
import edu.sc.seis.gee.task.dataSetBrowser.TreeSelectionMediator;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.log4j.Category;

public class DataSetBrowser
extends JPanel
implements Task {
    protected static Category logger = Category.getInstance((String)(class$edu$sc$seis$gee$task$dataSetBrowser$DataSetBrowser == null ? (class$edu$sc$seis$gee$task$dataSetBrowser$DataSetBrowser = DataSetBrowser.class$("edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser")) : class$edu$sc$seis$gee$task$dataSetBrowser$DataSetBrowser).getName());
    protected Map params;
    protected DataSetTreeModel treeModel = null;
    private JTextArea textArea = new JTextArea();
    protected JTree tree = new JTree();
    protected boolean DEBUG = true;
    protected JSplitPane splitPane;
    protected TreeSelectionMediator mediator;
    protected JPanel controls = new JPanel();
    static /* synthetic */ Class class$edu$sc$seis$gee$task$dataSetBrowser$DataSetBrowser;

    public DataSetBrowser() {
        this.setLayout(new BorderLayout());
        this.tree.setCellRenderer(new DataSetTreeCellRenderer());
        this.mediator = new TreeSelectionMediator();
        this.tree.addTreeSelectionListener(this.mediator);
        this.tree.setMinimumSize(new Dimension(100, 100));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
    }

    public void configure(Map params) {
        this.params = params;
    }

    public void invoke() {
        if (this.treeModel == null) {
            this.refresh();
            JScrollPane treeScroller = new JScrollPane(this.tree);
            this.add(treeScroller);
            this.revalidate();
        }
    }

    public void destroy() {
        this.treeModel = null;
    }

    public void refresh() {
        this.treeModel = new DataSetTreeModel();
        this.tree.setModel(this.treeModel);
    }

    public void setSizeofMyPanel(int widthpassed, int heightpassed) {
        Dimension startSize = new Dimension(100, 100);
        this.setMinimumSize(startSize);
        if (widthpassed > 100 || heightpassed > 100) {
            startSize = new Dimension(widthpassed, heightpassed);
        }
        this.setPreferredSize(startSize);
    }

    public TreePath[] getSelectionPaths() {
        return this.tree.getSelectionPaths();
    }

    public void addSeismogramSelectedListener(SeismogramSelectedListener l) {
        this.mediator.addSeismogramSelectedListener(l);
    }

    public void removeSeismogramSelectedListener(SeismogramSelectedListener l) {
        this.mediator.removeSeismogramSelectedListener(l);
    }

    public void addParameterSelectedListener(ParameterSelectedListener l) {
        this.mediator.addParameterSelectedListener(l);
    }

    public void removeParameterSelectedListener(ParameterSelectedListener l) {
        this.mediator.removeParameterSelectedListener(l);
    }

    public void addDataSetSelectedListener(DataSetSelectedListener l) {
        this.mediator.addDataSetSelectedListener(l);
    }

    public void removeDataSetSelectedListener(DataSetSelectedListener l) {
        this.mediator.removeDataSetSelectedListener(l);
    }

    public DataSet[] getSelectedDataSets() {
        TreePath[] paths = this.tree.getSelectionPaths();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (paths == null) {
            return new DataSet[0];
        }
        for (int counter = 0; counter < paths.length; ++counter) {
            if (!(paths[counter].getLastPathComponent() instanceof DataSet)) continue;
            arrayList.add(paths[counter].getLastPathComponent());
        }
        return arrayList.toArray(new DataSet[arrayList.size()]);
    }

    public DataSet[] getOpenDataSets() {
        int rows = this.tree.getRowCount();
        HashSet<DataSet> dataSets = new HashSet<DataSet>();
        for (int i = 0; i < rows; ++i) {
            TreePath path = this.tree.getPathForRow(i);
            if (!(path.getLastPathComponent() instanceof SeismogramTreeNode)) continue;
            SeismogramTreeNode cur = (SeismogramTreeNode)path.getLastPathComponent();
            dataSets.add(cur.getDataSet());
        }
        DataSet[] dsArray = new DataSet[dataSets.size()];
        return dataSets.toArray(dsArray);
    }

    public DataSetSeismogram[] getSelectedSeismograms() {
        TreePath[] paths = this.tree.getSelectionPaths();
        ArrayList<DataSetSeismogram> arrayList = new ArrayList<DataSetSeismogram>();
        if (paths == null) {
            return new DataSetSeismogram[0];
        }
        for (int counter = 0; counter < paths.length; ++counter) {
            if (!(paths[counter].getLastPathComponent() instanceof SeismogramTreeNode)) continue;
            SeismogramTreeNode node = (SeismogramTreeNode)paths[counter].getLastPathComponent();
            arrayList.add(node.getSeismogram());
        }
        DataSetSeismogram[] seismograms = new DataSetSeismogram[arrayList.size()];
        seismograms = arrayList.toArray(seismograms);
        return seismograms;
    }

    protected void createControls() {
        this.controls.setLayout(new FlowLayout());
        JCheckBox selectDoesDisplay = new JCheckBox("Select Always Displays");
        this.controls.add(selectDoesDisplay);
        selectDoesDisplay.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DataSetBrowser.this.mediator.activate();
                } else {
                    DataSetBrowser.this.mediator.deactivate();
                }
            }
        });
        selectDoesDisplay.setSelected(true);
        JLabel toolsLabel = new JLabel("Selection Tool");
        this.controls.add(toolsLabel);
        String[] toolNames = new String[]{"Diff", "Int", "Display"};
        JComboBox<String> tools = new JComboBox<String>(toolNames);
        tools.setSelectedIndex(2);
        this.controls.add(tools);
        tools.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                block3: {
                    String toolName;
                    block2: {
                        JComboBox cb = (JComboBox)e.getSource();
                        toolName = (String)cb.getSelectedItem();
                        if (!toolName.equals("Diff")) break block2;
                        DataSetSeismogram[] seis = DataSetBrowser.this.getSelectedSeismograms();
                        for (int i = 0; i < seis.length; ++i) {
                        }
                        break block3;
                    }
                    if (!toolName.equals("Int")) break block3;
                    DataSetSeismogram[] seis = DataSetBrowser.this.getSelectedSeismograms();
                    for (int i = 0; i < seis.length; ++i) {
                    }
                }
            }
        });
        JButton apply = new JButton("Apply");
        this.controls.add(apply);
    }

    public JTree getTree() {
        return this.tree;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

