/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseAdapter;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.task.CursorUtil;
import edu.sc.seis.gee.task.GlobalToolBar;
import edu.sc.seis.gee.task.Task;
import java.awt.AWTException;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Robot;
import java.util.Map;
import org.apache.log4j.Logger;

public class ZoomInTask
extends SDMouseAdapter
implements Task {
    String zoomType = "zoomIn";
    Map params;
    private Robot mouseMover;
    Cursor cursor = null;
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$gee$task$ZoomInTask == null ? (class$edu$sc$seis$gee$task$ZoomInTask = ZoomInTask.class$("edu.sc.seis.gee.task.ZoomInTask")) : class$edu$sc$seis$gee$task$ZoomInTask));
    static /* synthetic */ Class class$edu$sc$seis$gee$task$ZoomInTask;

    public void configure(Map params) {
        try {
            this.mouseMover = new Robot();
        }
        catch (AWTException e) {
            GlobalExceptionHandler.handle((String)"Unable to create robot!", (Throwable)e);
        }
        this.params = params;
        if (params.containsKey("zoomType")) {
            this.zoomType = (String)params.get("zoomType");
        }
    }

    public void invoke() {
        GlobalToolBar.setActive(this);
    }

    public void destroy() {
    }

    public void mouseClicked(SDMouseEvent me) {
        double centerPercent = me.getXPercent();
        SeismogramDisplay disp = me.getDisplay();
        if (this.zoomType.equalsIgnoreCase("zoomIn")) {
            disp.getTimeConfig().shaleTime(centerPercent - 0.25, 0.5);
        } else {
            disp.getTimeConfig().shaleTime(centerPercent - 1.0, 2.0);
        }
        if (this.mouseMover != null) {
            Point loc = disp.getLocationOnScreen();
            loc.x += disp.getSize().width / 2;
            loc.y += disp.getSize().height / 2;
            this.mouseMover.mouseMove(loc.x, loc.y);
        }
    }

    public void mouseEntered(SDMouseEvent me) {
        if (this.cursor == null) {
            this.createCursor();
        }
        me.getComponent().setCursor(this.cursor);
    }

    public void mouseExited(SDMouseEvent me) {
        me.getComponent().setCursor(Cursor.getDefaultCursor());
    }

    private void createCursor() {
        String imageFilePath = this.zoomType.equalsIgnoreCase("zoomIn") ? "edu/sc/seis/gee/data/images/pointer-mag-plus.gif" : "edu/sc/seis/gee/data/images/pointer-mag-minus.gif";
        this.cursor = CursorUtil.getCursor(this.zoomType, imageFilePath, 0.375f, 0.375f);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

