/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.registrar.RTTimeRangeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.util.Map;

public abstract class TimeSetterTask
implements Task {
    private TaskAction colSeisTaskAction;

    public void configure(Map params) throws ConfigurationException {
        String colSeisId = (String)params.get("colSeisTarget");
        CommonAccess ca = CommonAccess.getCommonAccess();
        this.colSeisTaskAction = ca.getTaskAction(colSeisId);
    }

    public void invoke() throws ConfigurationException {
        ((ColumnSeismogramTask)this.colSeisTaskAction.getTask()).setTimeSetter(this);
    }

    public void destroy() {
    }

    public abstract boolean needsEventInformation();

    public void setTime(SeismogramDisplay disp) {
        TimeConfig curConfig = disp.getTimeConfig();
        if (curConfig instanceof RTTimeRangeConfig) {
            ((RTTimeRangeConfig)curConfig).setInternalConfig(this.makeConfig());
            disp.setTimeConfig(curConfig);
        } else {
            disp.setTimeConfig(this.makeConfig());
        }
        if (curConfig != null) {
            disp.getTimeConfig().shaleTime(curConfig.getShift(), curConfig.getScale());
        }
    }

    public abstract TimeConfig makeConfig();
}

