/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TimeAmpLabelTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TimeAmpPaletteTask
extends JPanel
implements Task {
    protected DecimalFormat decimal = new DecimalFormat("###.##");
    protected DecimalFormat decimalInt = new DecimalFormat("#.");
    protected DecimalFormat scientific = new DecimalFormat("0.###E0");
    protected SimpleDateFormat timeOutput = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS");
    protected static Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    protected JLabel ampLabel = new JLabel("   Amplitude: ");
    protected JLabel timeLabel = new JLabel("   Time: ");
    protected InternalTimeAmpLabel myTALabeler = new InternalTimeAmpLabel();
    protected Map params;

    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        this.setMinimumSize(new Dimension(345, 20));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.ampLabel, "South");
        panel.add((Component)this.timeLabel, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)panel, "Center");
        this.myTALabeler.configure(params);
    }

    public void invoke() throws ConfigurationException {
    }

    public void destroy() {
    }

    protected class InternalTimeAmpLabel
    extends TimeAmpLabelTask {
        protected InternalTimeAmpLabel() {
        }

        protected void updateDisplay(BasicSeismogramDisplay display, MicroSecondDate time, QuantityImpl amp) {
            calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
            calendar.setTime((Date)time);
            String unitString = "";
            DecimalFormat formatter = TimeAmpPaletteTask.this.decimal;
            if (!amp.getUnit().equals((Object)UnitImpl.COUNT)) {
                unitString = amp.getUnit().toString();
            } else {
                formatter = TimeAmpPaletteTask.this.decimalInt;
            }
            if (Math.abs(amp.getValue()) > 1000000.0 || Math.abs(amp.getValue()) < 1.0E-6) {
                TimeAmpPaletteTask.this.ampLabel.setText("   Amplitude: " + TimeAmpPaletteTask.this.scientific.format(amp.getValue()) + " " + unitString);
            } else {
                TimeAmpPaletteTask.this.ampLabel.setText("   Amplitude: " + formatter.format(amp.getValue()) + " " + unitString);
            }
            TimeAmpPaletteTask.this.timeLabel.setText("   Time: " + TimeAmpPaletteTask.this.timeOutput.format(calendar.getTime()));
        }
    }
}

