/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.TauP.PathPlot;
import edu.sc.seis.TauP.SphericalCoords;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauP_Path;
import edu.sc.seis.fissuresUtil.bag.TauPUtil;
import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JPanel;

public class TauPPathTask
extends JPanel
implements Task {
    private SeismogramDisplay colSeis;
    private TauP_Path tpath;
    private PathPlot p;

    public void destroy() {
    }

    public void invoke() throws Exception {
    }

    public void displayPath(SeismogramDisplay display) {
        this.colSeis = display;
        if (this.colSeis != null) {
            HashMap events = new HashMap();
            if (display instanceof VerticalSeismogramDisplay) {
                HashMap stations;
                LinkedList displays = ((VerticalSeismogramDisplay)display).getDisplays();
                Iterator<Object> it = displays.iterator();
                while (it.hasNext()) {
                    BasicSeismogramDisplay currDisp = (BasicSeismogramDisplay)it.next();
                    DataSetSeismogram[] seismos = currDisp.getSeismograms();
                    for (int i = 0; i < seismos.length; ++i) {
                        DataSet dataset = seismos[i].getDataSet();
                        EventAccessOperations currEvent = dataset.getEvent();
                        if (!events.containsKey(currEvent)) {
                            events.put(currEvent, new HashMap());
                        }
                        stations = (HashMap)events.get(currEvent);
                        try {
                            Channel chan = dataset.getChannel(seismos[i].getRequestFilter().channel_id);
                            if (chan == null) continue;
                            Station currStation = chan.my_site.my_station;
                            stations.put(StationIdUtil.toString((StationId)currStation.get_id()), currStation);
                            continue;
                        }
                        catch (Throwable e) {
                            GlobalExceptionHandler.handle((String)("Problem getting the station information for channel " + ChannelIdUtil.toString((ChannelId)seismos[i].getRequestFilter().channel_id)), (Throwable)e);
                        }
                    }
                }
                it = events.keySet().iterator();
                while (it.hasNext()) {
                    EventAccessOperations currEvent = (EventAccessOperations)it.next();
                    stations = (HashMap)events.get(currEvent);
                    Collection stationCollection = stations.values();
                    Station[] stationArray = stationCollection.toArray(new Station[0]);
                    if (currEvent == null || stationArray.length <= 0) continue;
                    try {
                        double distance = SphericalCoords.distance((double)currEvent.get_preferred_origin().my_location.latitude, (double)currEvent.get_preferred_origin().my_location.longitude, (double)stationArray[0].my_location.latitude, (double)stationArray[0].my_location.longitude);
                        this.tpath.setSourceDepth(currEvent.get_preferred_origin().my_location.depth.value);
                        this.tpath.calculate(distance);
                        this.p.removeAllElements();
                        for (int i = 0; i < this.tpath.getNumArrivals(); ++i) {
                            this.p.addElement(this.tpath.getArrival(i));
                        }
                        this.p.repaint();
                    }
                    catch (NoPreferredOrigin npo) {
                    }
                    catch (TauModelException tme) {
                        GlobalExceptionHandler.handle((Throwable)tme);
                    }
                }
            }
        }
    }

    public void configure(Map params) throws ConfigurationException {
        try {
            TauPUtil ttime = CommonAccess.getCommonAccess().getTravelTimeCalc();
            this.tpath = new TauP_Path(ttime.getTauModel());
            if (params.containsKey("phases")) {
                String phasesString = (String)params.get("phases");
                StringTokenizer phasesTok = new StringTokenizer(phasesString, ",");
                int tokens = phasesTok.countTokens();
                String[] phases = new String[tokens];
                for (int i = 0; i < tokens; ++i) {
                    phases[i] = phasesTok.nextToken();
                }
                this.tpath.setPhaseNames(phases);
            }
            this.p = new PathPlot();
            this.p.setTauModel(this.tpath.getTauModel());
            this.setLayout(new BorderLayout());
            this.add((Component)this.p, "Center");
        }
        catch (TauModelException e) {
            throw new ConfigurationException("Invalid Tau model", e);
        }
    }
}

