/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.TrackerListener;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.Timer;

public class StatusIndicator
extends JButton
implements TrackerListener,
ActionListener {
    private boolean up = true;
    private int activeJobs = 0;
    private int pos = 0;
    private static ImageIcon[] apples = null;
    private static Timer updateTimer = null;
    private static final int wait = 100;

    public StatusIndicator() {
        this((String)null);
    }

    public StatusIndicator(String label) {
        super(label);
        if (apples == null) {
            this.generateApples();
        }
        if (updateTimer == null) {
            updateTimer = new Timer(100, this);
            updateTimer.setCoalesce(true);
            updateTimer.start();
        } else {
            updateTimer.addActionListener(this);
        }
        this.setIcon(apples[0]);
        this.setMargin(new Insets(0, 0, 0, 0));
        JobTracker.getTracker().add((TrackerListener)this);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    CommonAccess.getCommonAccess().getTaskAction("JobDisplay").checkDisplayLocation(false);
                }
                catch (ConfigurationException ex) {
                    GlobalExceptionHandler.handle((String)"Unable to show Job display", (Throwable)ex);
                }
            }
        });
    }

    public synchronized void trackerUpdated(JobTracker tracker) {
        this.activeJobs = tracker.getActiveJobs().size();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.pos != 0 || this.activeJobs > 0) {
            if (this.up) {
                ++this.pos;
                this.setIcon(apples[this.pos]);
                if (this.pos == 4) {
                    this.up = false;
                }
            } else {
                --this.pos;
                this.setIcon(apples[this.pos]);
                if (this.pos == 0) {
                    this.up = true;
                }
            }
        }
    }

    public void destroy() {
        JobTracker.getTracker().remove((TrackerListener)this);
        updateTimer.removeActionListener(this);
    }

    private void generateApples() {
        ImageIcon[] genApples = new ImageIcon[]{this.get(1), this.get(2), this.get(3), this.get(4), this.get(5)};
        apples = genApples;
    }

    private ImageIcon get(int appleNum) {
        return new ImageIcon(this.getClass().getClassLoader().getResource("edu/sc/seis/gee/data/images/apples/apple" + appleNum + ".png"));
    }
}

