/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.chooser.FileNameFilter;
import edu.sc.seis.fissuresUtil.display.SeismogramContainer;
import edu.sc.seis.fissuresUtil.display.SeismogramContainerFactory;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.sound.FissuresToWAV;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SoundExport
implements Task {
    Map params;

    public void configure(Map params) throws ConfigurationException {
        this.params = params;
    }

    public void invoke() throws Exception {
        this.showGUI();
    }

    public void destroy() {
    }

    void showGUI() throws ConfigurationException {
        DataSetSeismogram seis;
        JFileChooser fc = new JFileChooser();
        String[] extensions = new String[]{"wav"};
        fc.setFileFilter((FileFilter)new FileNameFilter(extensions));
        fc.setDialogTitle("Save WAV file");
        fc.setSelectedFile(new File("unknown.wav"));
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String browserId = (String)this.params.get("datasetbrowser");
        TaskAction browserAction = CommonAccess.getCommonAccess().getTaskAction(browserId);
        DataSetBrowser browser = (DataSetBrowser)browserAction.getTask();
        int returnVal = fc.showSaveDialog(CommonAccess.getCommonAccess().getMainFrame());
        if (this.params.containsKey("datasetbrowser")) {
            DataSetSeismogram[] dsToSave = browser.getSelectedSeismograms();
            seis = dsToSave[0];
        } else {
            seis = null;
        }
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                file.createNewFile();
                DataOutputStream fos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                SeismogramContainer container = SeismogramContainerFactory.create((DataSetSeismogram)seis);
                FissuresToWAV toWav = new FissuresToWAV(container, 1200);
                toWav.writeWAV((DataOutput)fos, RangeTool.getFullTime((LocalSeismogramImpl[])container.getSeismograms()));
                fos.close();
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((String)"Problem saving WAV file.", (Throwable)e);
            }
        }
    }
}

