/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.NullCrosshairTask;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.TauPPathTask;
import java.awt.event.MouseEvent;
import java.util.Map;

public class SeismogramShuckerTask
extends NullCrosshairTask {
    ColumnSeismogramTask source;
    ColumnSeismogramTask destinationDisp;
    TauPPathTask destinationTauPPath;

    public void configure(Map params) throws ConfigurationException {
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String taskId = (String)params.get("sourceDisplay");
        if (taskId == null || taskId.length() == 0) {
            throw new ConfigurationException("No source Seismogram Display Task defined in config");
        }
        TaskAction taskAction = commonAccess.getTaskAction(taskId);
        this.source = (ColumnSeismogramTask)taskAction.getTask();
        if (params.containsKey("destinationDisplay")) {
            taskId = (String)params.get("destinationDisplay");
            if (taskId == null || taskId.length() == 0) {
                throw new ConfigurationException("No destination Seismogram Display Task defined in config");
            }
            taskAction = commonAccess.getTaskAction(taskId);
            this.destinationDisp = (ColumnSeismogramTask)taskAction.getTask();
        }
        if (params.containsKey("destinationTauPPath")) {
            taskId = (String)params.get("destinationTauPPath");
            if (taskId == null || taskId.length() == 0) {
                throw new ConfigurationException("No destination TauP Path Task defined in config");
            }
            taskAction = commonAccess.getTaskAction(taskId);
            this.destinationTauPPath = (TauPPathTask)taskAction.getTask();
        }
        super.configure(params);
    }

    public void mouseClicked(MouseEvent e) {
        DrawableIterator dIt;
        SeismogramDisplay sourceDisplay = this.source.getDisplay();
        if (e.getComponent() == sourceDisplay && sourceDisplay.getDrawables(e) != null && (dIt = sourceDisplay.getDrawables(e)).hasNext()) {
            DrawableSeismogram seis = (DrawableSeismogram)dIt.next();
            DataSetSeismogram dss = seis.getSeismogram();
            if (this.destinationDisp != null) {
                this.destinationDisp.removeAllDisplays();
                this.destinationDisp.addSeismogram(dss);
                try {
                    this.destinationTauPPath.displayPath(this.destinationDisp.getDisplay());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

