/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.FileNameFilter;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetToXML;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import java.io.File;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class SaveDataSetTask
implements Task {
    Map params;
    String seisFileType = "SAC";
    static final String SAC = "SAC";
    static final String MSEED = "MSEED";

    public void invoke() throws ConfigurationException {
        this.createGUI();
    }

    public void destroy() {
    }

    public void createGUI() throws ConfigurationException {
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        DataSet[] dsToSave = null;
        if (this.params.containsKey("datasetbrowser")) {
            String browserId = (String)this.params.get("datasetbrowser");
            TaskAction browserAction = CommonAccess.getCommonAccess().getTaskAction(browserId);
            DataSetBrowser browser = (DataSetBrowser)browserAction.getTask();
            dsToSave = browser.getSelectedDataSets();
        } else {
            dsToSave = new DataSet[]{commonAccess.getDataSetRoot()};
            if (dsToSave[0].getDataSetNames().length == 1 && dsToSave[0].getParameterNames().length == 0 && dsToSave[0].getDataSetSeismogramNames().length == 0) {
                dsToSave[0] = dsToSave[0].getDataSet(dsToSave[0].getDataSetNames()[0]);
            }
        }
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(1);
        String[] extensions = new String[]{"dsml"};
        fc.setFileFilter((FileFilter)new FileNameFilter(extensions));
        fc.setDialogTitle("Save Dataset");
        String defName = "Mydata";
        if (dsToSave.length == 1) {
            defName = dsToSave[0].getName();
            defName = defName.replaceAll(" ", "_");
            defName = defName.replaceAll(",", "_");
            fc.setDialogTitle(defName);
        }
        fc.setSelectedFile(new File(defName));
        int returnVal = fc.showSaveDialog(FrameManager.getManager().getCurrentFrame());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            DSSaver saver = new DSSaver(defName, dsToSave, file, SeismogramFileTypes.SAC);
            JobTracker.getTracker().add((Job)saver);
            WorkerThreadPool.getDefaultPool().invokeLater((Runnable)((Object)saver));
        }
    }

    public void configure(Map params) {
        this.params = params;
    }

    class DSSaver
    extends AbstractJob {
        File file;
        DataSet[] dsToSave;
        SeismogramFileTypes fileType;

        DSSaver(String dsname, DataSet[] dsToSave, File file, SeismogramFileTypes fileType) {
            super("Save Dataset " + dsname);
            this.dsToSave = dsToSave;
            this.file = file;
            this.fileType = fileType;
        }

        public void runJob() {
            try {
                DataSetToXML dataSetToXML = new DataSetToXML();
                for (int i = 0; i < this.dsToSave.length; ++i) {
                    this.setStatus("Saving " + this.dsToSave[i].getName());
                    File file = dataSetToXML.save(this.dsToSave[i], this.file, this.fileType);
                }
                this.setFinished();
            }
            catch (Exception e) {
                GlobalExceptionHandler.handle((String)"Problem saving dataset.", (Throwable)e);
            }
        }
    }
}

