/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.chooser.FileNameFilter;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramPDFBuilder;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;

public class PrintTask
implements Task {
    private static EmptyBorder EMPTY_BORDER = new EmptyBorder(5, 5, 5, 5);
    private File lastSaveLocation = null;
    private ColumnSeismogramTask colSeis;

    public void configure(Map params) throws ConfigurationException {
        if (!params.containsKey("printTarget")) {
            throw new ConfigurationException("A PrintTask requires a columnSeismogramTask in its config in the key printTarget!");
        }
        String printTargetId = (String)params.get("printTarget");
        CommonAccess ca = CommonAccess.getCommonAccess();
        TaskAction ta = ca.getTaskAction(printTargetId);
        this.colSeis = (ColumnSeismogramTask)ta.getTask();
    }

    public void invoke() {
        this.getImagesPerPage(this.getNumOfDisp());
    }

    private int getNumOfDisp() {
        SeismogramDisplay disp = this.colSeis.getDisplay();
        if (disp instanceof VerticalSeismogramDisplay) {
            return ((VerticalSeismogramDisplay)disp).getDisplays().size();
        }
        return 1;
    }

    private void print(int numPerPage) {
        block3: {
            String tmp = this.chooseOutputFile("pdf");
            if (tmp != null) {
                try {
                    SeismogramPDFBuilder.createPDF((SeismogramDisplay)this.colSeis.getDisplay(), (String)tmp, (int)numPerPage);
                }
                catch (FileNotFoundException e) {
                    int choice = JOptionPane.showConfirmDialog(null, "Unable to open file " + tmp + ".  Would you like to try another location?", "Unable to open file", 2);
                    if (choice != 0) break block3;
                    this.print(numPerPage);
                }
            }
        }
    }

    private void getImagesPerPage(int numSeis) {
        final JDialog dialog = new JDialog();
        dialog.getContentPane().setLayout(new GridBagLayout());
        dialog.setTitle("Printing Options");
        dialog.setModal(true);
        JLabel information = new JLabel("Seismograms per page:  ");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        dialog.getContentPane().add((Component)information, gbc);
        Integer[] numbers = new Integer[3];
        for (int i = 0; i < 3; ++i) {
            numbers[i] = new Integer(i + 1);
        }
        final JComboBox<Integer> options = new JComboBox<Integer>(numbers);
        ++gbc.gridx;
        gbc.ipadx = 10;
        dialog.getContentPane().add(options, gbc);
        JButton next = new JButton("Next");
        next.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int currentNumber = (Integer)options.getSelectedItem();
                PrintTask.this.print(currentNumber);
                dialog.dispose();
            }
        });
        ++gbc.gridy;
        gbc.ipadx = 0;
        dialog.getContentPane().add((Component)next, gbc);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        });
        --gbc.gridx;
        dialog.getContentPane().add((Component)cancel, gbc);
        dialog.pack();
        Toolkit tk = Toolkit.getDefaultToolkit();
        dialog.setLocation((tk.getScreenSize().width - dialog.getWidth()) / 2, (tk.getScreenSize().height - dialog.getHeight()) / 2);
        dialog.show();
    }

    private String chooseOutputFile(String extension) {
        JFileChooser fc = this.lastSaveLocation != null ? new JFileChooser(this.lastSaveLocation) : new JFileChooser();
        String[] extensions = new String[]{extension};
        fc.setFileFilter((FileFilter)new FileNameFilter(extensions));
        fc.setDialogTitle("Save to File");
        fc.setSelectedFile(new File("output." + extension));
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            this.lastSaveLocation = file.getParentFile();
            String newExtension = file.getName().substring(file.getName().lastIndexOf(".") + 1);
            if (!newExtension.equalsIgnoreCase(extension)) {
                file = new File(file.getAbsolutePath() + "." + extension);
            }
            if (file.exists()) {
                Object[] options = new String[]{"Yes", "No", "Choose again"};
                int n = JOptionPane.showOptionDialog(null, "File " + file.getName() + " exists, replace?", "File Exists", 1, 3, null, options, options[0]);
                if (n == 1) {
                    return null;
                }
                if (n == 2) {
                    return this.chooseOutputFile(extension);
                }
            }
            return file.getAbsolutePath();
        }
        return null;
    }

    public void destroy() {
    }
}

