/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.display.PlottableDisplay;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.organizer.Organizer;
import edu.sc.seis.gee.task.DataSetRealTimePlayerTask;
import edu.sc.seis.gee.task.LoadSeismogram;
import edu.sc.seis.gee.task.PlottableTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;

public class PlottableSelectionTask
extends MouseAdapter
implements Task,
MouseMotionListener {
    private PlottableDisplay display;
    private PlottableTask task;
    private LoadSeismogram loadSeismogram;
    private DataSetRealTimePlayerTask colSeisTask;
    private TaskAction colSeisTaskAction;
    private SeismogramExtractor extractor = new SeismogramExtractor();
    private static WorkerThreadPool extractorPool = new WorkerThreadPool("Day Viewer Extractor", 1);

    public void configure(Map params) throws ConfigurationException {
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String taskId = (String)params.get("plottableTask");
        TaskAction taskAction = commonAccess.getTaskAction(taskId);
        this.task = (PlottableTask)taskAction.getTask();
        if (this.task == null) {
            throw new ConfigurationException("Invalid configuration, plottableTask in plottableSelectionTask must be set");
        }
        taskId = (String)params.get("loadSeismogram");
        taskAction = commonAccess.getTaskAction(taskId);
        this.loadSeismogram = (LoadSeismogram)taskAction.getTask();
        taskId = (String)params.get("colSeisDisplay");
        this.colSeisTaskAction = commonAccess.getTaskAction(taskId);
        this.colSeisTask = (DataSetRealTimePlayerTask)this.colSeisTaskAction.getTask();
    }

    public void invoke() throws Exception {
        this.display = this.task.getDisplay();
        this.display.addMouseMotionListener((MouseMotionListener)this);
        this.display.addMouseListener((MouseListener)this);
        this.task.setPlottableTool(this);
    }

    public void destroy() {
        if (this.display != null) {
            this.display.removeMouseMotionListener((MouseMotionListener)this);
            this.display.removeSelection();
        }
    }

    public void mouseClicked(MouseEvent e) {
        RequestFilter filter;
        if (this.active() && (filter = this.display.getRequestFilter(e.getX(), e.getY())) != null) {
            this.extractor.extract(filter);
        }
    }

    private EventAccessOperations pickEvent(EventAccessOperations[] events) {
        Object[] eventNames = new String[events.length];
        for (int i = 0; i < events.length; ++i) {
            eventNames[i] = EventUtil.getEventInfo((EventAccessOperations)events[i]);
        }
        String selection = (String)JOptionPane.showInputDialog((Component)this.display, "More than one event is selected.  Please choose the one you want", "More than one event selected", 3, null, eventNames, eventNames[0]);
        for (int i = 0; i < eventNames.length; ++i) {
            if (!((String)eventNames[i]).equals(selection)) continue;
            return events[i];
        }
        return null;
    }

    public void mouseDragged(MouseEvent me) {
        if (this.active()) {
            this.display.addToSelection(me.getX(), me.getY());
            this.display.setCursor(Cursor.getPredefinedCursor(11));
        }
    }

    public void mouseMoved(MouseEvent me) {
        if (this.active()) {
            this.display.setSelection(me.getX(), me.getY());
            if (this.display.bordersSelection(me.getX(), me.getY())) {
                this.display.setCursor(Cursor.getPredefinedCursor(11));
            } else {
                this.display.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private boolean active() {
        return this.task.getPlottableTool() == this;
    }

    private class SeismogramExtractor
    extends AbstractJob {
        private RequestFilter internalFilter;
        private Map previousExtracts = new HashMap();

        public SeismogramExtractor() {
            super("Day Viewer Extractor");
            JobTracker.getTracker().add((Job)this);
            this.setFinished();
        }

        public void extract(RequestFilter filter) {
            this.internalFilter = filter;
            this.previousExtracts.put(this.internalFilter, Boolean.FALSE);
            extractorPool.invokeLater((Runnable)((Object)this));
        }

        public void runJob() {
            this.setFinished(false);
            RequestFilter filter = this.internalFilter;
            try {
                this.setStatus("Loading seismogram from filter");
                DataSetSeismogram seismogram = PlottableSelectionTask.this.loadSeismogram.retrieveSeismogram(filter);
                Channel[] chans = PlottableSelectionTask.this.task.getChannels();
                this.setStatus("Loading filter");
                DataSetSeismogram[] friends = new DataSetSeismogram[chans.length];
                for (int i = 0; i < chans.length; ++i) {
                    if (chans[i].get_id().equals(filter.channel_id)) {
                        friends[i] = seismogram;
                        continue;
                    }
                    RequestFilter friendFilter = new RequestFilter(chans[i].get_id(), filter.start_time, filter.end_time);
                    friends[i] = PlottableSelectionTask.this.loadSeismogram.retrieveSeismogram(friendFilter);
                }
                Organizer organizer = CommonAccess.getCommonAccess().getOrganizer();
                AuditInfo[] audit = new AuditInfo[]{new AuditInfo(System.getProperty("user.name", "GEE"), "loaded from Day Viewer")};
                this.setStatus("Getting event");
                EventAccessOperations[] eao = PlottableSelectionTask.this.display.getSelectedEvents();
                this.setStatus("Populating dataset");
                if (eao.length > 0) {
                    EventAccessOperations selectedEvent = eao[0];
                    if (eao.length > 1 && (selectedEvent = PlottableSelectionTask.this.pickEvent(eao)) == null) {
                        return;
                    }
                    for (int i = 0; i < friends.length; ++i) {
                        organizer.addSeismogram(friends[i], selectedEvent, audit);
                        organizer.addChannel(chans[i], selectedEvent, audit);
                    }
                } else {
                    for (int i = 0; i < friends.length; ++i) {
                        organizer.addSeismogram(friends[i], audit);
                        organizer.addChannel(chans[i], audit);
                    }
                }
                this.setStatus("Adding Seismogram");
                PlottableSelectionTask.this.colSeisTask.addSeismogram(seismogram);
                PlottableSelectionTask.this.colSeisTaskAction.checkDisplayLocation(true);
                this.previousExtracts.put(filter, Boolean.TRUE);
            }
            catch (Exception ex) {
                GlobalExceptionHandler.handle((Throwable)ex);
            }
            this.setFinished();
        }
    }
}

