/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TauPTask;
import java.util.Map;
import java.util.StringTokenizer;

public class PhasePlotTask
implements Task {
    protected boolean displayed = false;
    protected TauPTask calculator;
    protected ColumnSeismogramTask[] destinations;
    protected Map params;

    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        CommonAccess ca = CommonAccess.getCommonAccess();
        if (!params.containsKey("travelCalculator")) {
            throw new ConfigurationException("No travelCalculator in PhasePlotTask configuration!");
        }
        String tc = (String)params.get("travelCalculator");
        this.calculator = (TauPTask)ca.getTaskAction(tc).getTask();
        this.calculator.setTauPListener(this);
        if (params.containsKey("phaseDestinations")) {
            String pd = (String)params.get("phaseDestinations");
            StringTokenizer destinationTokenizer = new StringTokenizer(pd, ",");
            int tokens = destinationTokenizer.countTokens();
            this.destinations = new ColumnSeismogramTask[tokens];
            for (int i = 0; i < tokens; ++i) {
                String destID = destinationTokenizer.nextToken();
                this.destinations[i] = (ColumnSeismogramTask)ca.getTaskAction(destID).getTask();
            }
        } else {
            throw new ConfigurationException("no phaseDestinations in PhasePlotTask configuration");
        }
    }

    public void invoke() {
        if (this.displayed) {
            for (int i = 0; i < this.destinations.length; ++i) {
                this.destinations[i].removeTravelTimes();
            }
        } else {
            for (int i = 0; i < this.destinations.length; ++i) {
                this.destinations[i].displayTravelTimes();
            }
        }
        this.displayed = !this.displayed;
    }

    public boolean getDisplayed() {
        return this.displayed;
    }

    public void update() {
        if (this.displayed) {
            for (int i = 0; i < this.destinations.length; ++i) {
                this.destinations[i].removeTravelTimes();
                this.destinations[i].displayTravelTimes();
            }
        }
    }

    public void destroy() {
    }
}

