/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkAccess;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.NameListCellRenderer;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ChannelChooserTask;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class NetworkAddTask
implements GUITask {
    JPanel panel = null;
    JList networkList;
    DefaultListModel networks;
    ChannelChooserTask channelChooserTask;
    Map params;
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$gee$task$NetworkAddTask == null ? (class$edu$sc$seis$gee$task$NetworkAddTask = NetworkAddTask.class$("edu.sc.seis.gee.task.NetworkAddTask")) : class$edu$sc$seis$gee$task$NetworkAddTask));
    static /* synthetic */ Class class$edu$sc$seis$gee$task$NetworkAddTask;

    public JComponent getMoreOptionsGUI() {
        return null;
    }

    public void configure(Map params) throws ConfigurationException {
        logger.debug((Object)"configure");
        this.params = params;
        String chanChooserId = (String)params.get("channelChooserTask");
        TaskAction chanChooserAction = CommonAccess.getCommonAccess().getTaskAction(chanChooserId);
        this.channelChooserTask = (ChannelChooserTask)chanChooserAction.getTask();
    }

    public void destroy() {
    }

    public boolean hasMoreOptions() {
        return false;
    }

    public JComponent getGUI() throws Exception {
        if (this.panel == null) {
            logger.debug((Object)"Panel is null, initPanel");
            this.panel = this.initPanel();
        }
        return this.panel;
    }

    public void invoke() throws Exception {
    }

    protected JPanel initPanel() throws ConfigurationException {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        this.networks = new DefaultListModel();
        this.networkList = new JList(this.networks);
        this.networkList.setCellRenderer(new NameListCellRenderer(true, true, true));
        this.networkList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int first = e.getFirstIndex();
                int last = e.getLastIndex();
                ListSelectionModel selections = NetworkAddTask.this.networkList.getSelectionModel();
                for (int i = first; i <= last; ++i) {
                    NetworkAccess net = (NetworkAccess)NetworkAddTask.this.networks.get(i);
                    if (!selections.isSelectedIndex(i)) continue;
                    NetworkAccess selectedNet = (NetworkAccess)NetworkAddTask.this.networks.get(i);
                    try {
                        NetworkAddTask.this.channelChooserTask.getChannelChooser().appendNetwork(selectedNet);
                        continue;
                    }
                    catch (NoNetworkException ex) {
                        GlobalExceptionHandler.handle((String)("Caught no network, ignoring user selection " + i), (Throwable)ex);
                    }
                }
            }
        });
        ProxyNetworkDC[] netDC = this.channelChooserTask.getConfiguredNetworkDCs();
        LoadNetworks loader = new LoadNetworks(netDC, this.networks);
        JobTracker.getTracker().add((Job)loader);
        WorkerThreadPool.getDefaultPool().invokeLater((Runnable)((Object)loader));
        panel.add((Component)new JScrollPane(this.networkList), "Center");
        return panel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class LoadNetworks
    extends AbstractJob {
        DefaultListModel networks;
        ProxyNetworkDC[] netDCs;

        LoadNetworks(ProxyNetworkDC[] netDCs, DefaultListModel networks) {
            super("Network List Loader");
            this.netDCs = netDCs;
            this.networks = networks;
        }

        public void runJob() {
            for (int i = 0; i < this.netDCs.length; ++i) {
                this.setStatus("Getting networks from net datacenter " + i);
                NetworkAccess[] all = this.netDCs[i].a_finder().retrieve_all();
                for (int j = 0; j < all.length; ++j) {
                    ProxyNetworkAccess cache = BulletproofVestFactory.vestNetworkAccess((NetworkAccess)all[j], (ProxyNetworkDC)this.netDCs[i]);
                    all[j] = cache;
                    SwingUtilities.invokeLater(new Runnable(this, (NetworkAccess)cache){
                        private final /* synthetic */ NetworkAccess val$cache;
                        private final /* synthetic */ LoadNetworks this$1;
                        {
                            this.this$1 = this$1;
                            this.val$cache = val$cache;
                        }

                        public void run() {
                            this.this$1.networks.addElement(this.val$cache);
                            LoadNetworks.access$000((LoadNetworks)this.this$1).networkList.repaint();
                        }
                    });
                }
            }
            this.setFinished();
            NetworkAddTask.this.networkList.repaint();
        }

        static /* synthetic */ NetworkAddTask access$000(LoadNetworks x0) {
            return x0.NetworkAddTask.this;
        }
    }
}

