/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.sc.seis.fissuresUtil.chooser.FileNameFilter;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterSelectionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileFilter;
import multivalent.Browser;
import multivalent.Multivalent;
import org.apache.log4j.Logger;

public class MultivalentViewTask
implements GUITask {
    protected JComboBox comboBox = new JComboBox();
    protected HashMap nameURLMap = new HashMap();
    Browser browser;
    JPanel panel;
    DataSetBrowser datasetBrowser;
    Map params;
    static URI URI_DEMO = URI.create("http://www.sc.edu");
    static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$gee$task$MultivalentViewTask == null ? (class$edu$sc$seis$gee$task$MultivalentViewTask = MultivalentViewTask.class$("edu.sc.seis.gee.task.MultivalentViewTask")) : class$edu$sc$seis$gee$task$MultivalentViewTask));
    static /* synthetic */ Class class$edu$sc$seis$gee$task$MultivalentViewTask;

    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        if (params.containsKey("datasetbrowser")) {
            String browserId = (String)params.get("datasetbrowser");
            TaskAction browserAction = CommonAccess.getCommonAccess().getTaskAction(browserId);
            this.datasetBrowser = (DataSetBrowser)browserAction.getTask();
            this.datasetBrowser.addParameterSelectedListener(new ParameterSelectedListener(){

                public void parameterSelected(ParameterSelectionEvent p) {
                    if (p.isSelected()) {
                        Object param = p.getValue();
                        String st_url = param instanceof String ? (String)param : (param instanceof ParameterRef ? ((ParameterRef)param).creator : "none");
                        try {
                            URL given_url;
                            Object o = p.getDataSet().getParameter("xml:base");
                            if (o != null && o instanceof String) {
                                String baseStr = (String)o;
                                URL base = new URL(baseStr);
                                given_url = new URL(base, st_url);
                            } else {
                                given_url = new URL(st_url);
                            }
                            MultivalentViewTask.this.addURL(p.getName(), given_url);
                            MultivalentViewTask.this.show(p.getName());
                        }
                        catch (MalformedURLException e) {
                            logger.error((Object)("Bad image url, " + st_url), (Throwable)e);
                        }
                    }
                }
            });
        }
        Iterator it = params.keySet().iterator();
        while (it.hasNext()) {
            URL given_url;
            String name;
            Object key = it.next();
            String stkey = (String)key;
            if (stkey.startsWith("image_url_")) {
                name = stkey.substring(10);
                String st_url = (String)params.get(key);
                try {
                    given_url = new URL(st_url);
                    this.addURL(name, given_url);
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("Image Viewer could not parse url " + st_url, e);
                }
            }
            if (!stkey.startsWith("image_jar_")) continue;
            name = stkey.substring(10);
            String resource = (String)params.get(key);
            given_url = this.getClass().getClassLoader().getResource(resource);
            if (given_url == null) {
                throw new ConfigurationException("Image Viewer could not find image: " + stkey + "  from " + resource);
            }
            logger.debug((Object)("jar url is " + given_url));
            this.addURL(name, given_url);
        }
        TaskAction taskAction = (TaskAction)params.get("gee.task.taskAction");
        taskAction.addToToolBar(this.comboBox);
        this.comboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    logger.debug((Object)("select " + e.getItem()));
                    MultivalentViewTask.this.show((String)e.getItem());
                }
            }
        });
    }

    public void invoke() throws Exception {
        if (this.datasetBrowser != null) {
            DataSet[] datasets = this.datasetBrowser.getSelectedDataSets();
            if (datasets == null || datasets.length == 0) {
                DataSet dataset = CommonAccess.getCommonAccess().getDataSetRoot();
                this.retrieveImages(dataset);
                String[] dsNames = dataset.getDataSetNames();
                if (dsNames.length == 1) {
                    DataSet child = dataset.getDataSet(dsNames[0]);
                    this.retrieveImages(child);
                } else {
                    String dsNameStr = "";
                    for (int j = 0; j < dsNames.length; ++j) {
                        dsNameStr = dsNameStr + dsNames[j] + " ";
                    }
                    JOptionPane.showMessageDialog(null, "There are " + dsNames.length + " datasets, and none is selected." + dsNameStr, "alert", 0);
                }
            } else {
                for (int counter = 0; counter < datasets.length; ++counter) {
                    DataSet dataset = datasets[counter];
                    this.retrieveImages(dataset);
                }
            }
        }
    }

    public void destroy() {
    }

    public JComponent getMoreOptionsGUI() {
        return null;
    }

    public JComponent getGUI() {
        if (this.panel == null) {
            this.panel = this.initGUI();
        }
        return this.panel;
    }

    public boolean hasMoreOptions() {
        return false;
    }

    public void show(String name) {
        logger.debug((Object)("before show " + name));
        try {
            JComponent pan = this.getGUI();
            String urlString = ((URL)this.nameURLMap.get(name)).toString();
            logger.debug((Object)("show " + urlString));
            if (urlString.endsWith(".pdf") || urlString.endsWith(".PDF")) {
                urlString = this.findPDFAsFile(urlString);
                logger.debug((Object)("fixing pdf, now url=" + urlString));
            }
            URI uri = new URI(urlString);
            logger.debug((Object)("show " + uri));
            this.browser.eventq("openDocument", (Object)uri);
            this.browser.repaint();
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle((String)("Problam with URL in image viewer: " + ((URL)this.nameURLMap.get(name)).toString()), (Throwable)e);
        }
        logger.debug((Object)("after show " + name));
    }

    public String findPDFAsFile(String url) throws MalformedURLException, FileNotFoundException, IOException {
        if (url.startsWith("file:")) {
            return url;
        }
        URL tempURL = new URL(url);
        String resourceName = url.startsWith("jar:file:") ? url.substring(url.lastIndexOf("!") + 1) : tempURL.getPath();
        File tempPDF = new File(CommonAccess.getCacheDirectory() + "/PDF/" + resourceName);
        if (!tempPDF.exists()) {
            URL resourceURL = this.getClass().getResource(resourceName);
            logger.debug((Object)("resource =" + resourceName + " URL = " + resourceURL.toString()));
            this.copyFromURL(resourceURL, tempPDF);
        }
        return "file:///" + tempPDF.getPath().replace('\\', '/');
    }

    void copyFromURL(URL url, File outFile) throws IOException {
        outFile.getParentFile().mkdirs();
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
        byte[] tmp = new byte[512];
        int numRead = in.read(tmp, 0, tmp.length);
        while (numRead > 0) {
            out.write(tmp, 0, numRead);
            numRead = in.read(tmp, 0, tmp.length);
        }
        in.close();
        out.close();
    }

    public void retrieveImages(DataSet dataSet) {
        logger.debug((Object)("The NAME of THE dataset in RETRIEVE IMAGES is " + dataSet.getName()));
        String[] paramNames = dataSet.getParameterNames();
        URL base = null;
        Object o = dataSet.getParameter("xml:base");
        if (o != null && o instanceof String) {
            String baseStr = (String)o;
            try {
                base = new URL(baseStr);
            }
            catch (MalformedURLException e) {
                logger.warn((Object)("Problem with url: " + baseStr), (Throwable)e);
            }
        }
        for (int i = 0; i < paramNames.length; ++i) {
            logger.debug((Object)("Param name=" + paramNames[i]));
            if (paramNames[i].startsWith("edu.sc.seis.fissuresUtil.xml#EVENT") || paramNames[i].startsWith("edu.sc.seis.fissuresUtil.xml#CHANNEL_")) continue;
            Object param = dataSet.getParameter(paramNames[i]);
            String paramStr = null;
            if (param instanceof String) {
                paramStr = (String)param;
            } else if (param instanceof ParameterRef) {
                paramStr = ((ParameterRef)param).creator;
            }
            if (paramStr == null || paramStr.length() == 0 || !paramStr.endsWith(".gif") && !paramStr.endsWith(".png") && !paramStr.endsWith(".jpg") && !paramStr.endsWith(".pdf") && !paramStr.endsWith(".jpeg")) continue;
            try {
                URL url = base != null ? new URL(base, paramStr) : new URL(paramStr);
                logger.debug((Object)("Adding to image viewer " + paramNames[i] + " " + url.toString()));
                this.addURL(paramNames[i], url);
                continue;
            }
            catch (MalformedURLException e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
        }
    }

    JPanel initGUI() {
        Multivalent v = Multivalent.getInstance();
        this.browser = v.getBrowser((String)this.params.get("gee.task.id"), "Basic");
        JScrollPane scroll = new JScrollPane((Component)this.browser);
        JFileChooser jfc = new JFileChooser();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.browser, "Center");
        TaskAction taskAction = (TaskAction)this.params.get("gee.task.taskAction");
        JButton b = new JButton("page back");
        b.addActionListener(new SemanticSender(this.browser, "previousPage", null));
        taskAction.addToToolBar(b);
        b = new JButton("page next");
        b.addActionListener(new SemanticSender(this.browser, "nextPage", null));
        taskAction.addToToolBar(b);
        b = new JButton(new ImageIcon(this.getClass().getClassLoader().getResource("edu/sc/seis/gee/data/images/pdf.png")));
        b.setMargin(new Insets(0, 0, 0, 0));
        b.setToolTipText("Click this button to save this pdf file for viewing outside of GEE");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object name = null;
                URL url = null;
                try {
                    name = MultivalentViewTask.this.comboBox.getItemAt(MultivalentViewTask.this.comboBox.getSelectedIndex());
                    url = (URL)MultivalentViewTask.this.nameURLMap.get(name);
                    MultivalentViewTask.this.printToFile();
                }
                catch (Exception ex) {
                    GlobalExceptionHandler.handle((String)("Unable to get file for " + name + " url=" + url), (Throwable)ex);
                }
            }
        });
        taskAction.addToToolBar(b);
        return jPanel;
    }

    public void addURL(String name, URL url) {
        String urlName = url != null ? url.toString() : "";
        logger.debug((Object)("addURL " + urlName));
        if (urlName != null && urlName.length() != 0 && (urlName.endsWith(".gif") || urlName.endsWith(".png") || urlName.endsWith(".jpg") || urlName.endsWith(".pdf") || urlName.endsWith(".jpeg"))) {
            if (urlName.indexOf(32) != -1) {
                urlName = urlName.replaceAll(" ", "%20");
                try {
                    url = new URL(urlName);
                }
                catch (MalformedURLException e) {
                    GlobalExceptionHandler.handle((String)("Cannot construct a URL from this string: " + urlName), (Throwable)e);
                }
            }
            this.nameURLMap.put(name, url);
            for (int i = 0; i < this.comboBox.getItemCount(); ++i) {
                if (!((String)this.comboBox.getItemAt(i)).equals(name)) continue;
                return;
            }
            this.comboBox.addItem(name);
        }
        logger.debug((Object)("after addUrl " + urlName));
    }

    public File printToFile() throws MalformedURLException, FileNotFoundException, IOException {
        String outFilename;
        Object name = this.comboBox.getItemAt(this.comboBox.getSelectedIndex());
        URL url = (URL)this.nameURLMap.get(name);
        String urlString = url.toString();
        String extension = urlString.substring(urlString.lastIndexOf(".") + 1);
        if (extension == null) {
            extension = "";
        }
        logger.debug((Object)("print " + urlString));
        if (extension.equals(".pdf") || extension.equals(".PDF")) {
            urlString = this.findPDFAsFile(urlString);
            logger.debug((Object)("fixing pdf, now url=" + urlString));
            url = new URL(urlString);
        }
        if ((outFilename = this.chooseOutputFile(extension)) != null) {
            File outFile = new File(outFilename);
            this.copyFromURL(url, outFile);
            return outFile;
        }
        return null;
    }

    private String chooseOutputFile(String extension) {
        JFileChooser fc = new JFileChooser();
        String[] extensions = new String[]{extension};
        fc.setFileFilter((FileFilter)new FileNameFilter(extensions));
        fc.setDialogTitle("Save to File");
        fc.setSelectedFile(new File("output." + extension));
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            String newExtension = file.getName().substring(file.getName().lastIndexOf(extension) + 1);
            if (!newExtension.equalsIgnoreCase(extension)) {
                file = new File(file.getAbsolutePath() + "." + extension);
            }
            if (file.exists()) {
                Object[] options = new String[]{"Replace", "Choose Again", "Cancel"};
                int n = JOptionPane.showOptionDialog(FrameManager.getManager().getCurrentFrame(), "File " + file.getName() + " exists, replace?", "File Exists", 1, 3, null, options, options[0]);
                logger.debug((Object)("return val is " + n));
                if (n == 2) {
                    return null;
                }
                if (n == 2) {
                    return this.chooseOutputFile(extension);
                }
            }
            String fileName = file.getAbsolutePath();
            return file.getAbsolutePath();
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class SemanticSender
    implements ActionListener {
        Browser br_;
        String cmd_;
        Object arg_;

        SemanticSender(Browser br, String cmd, Object arg) {
            this.br_ = br;
            this.cmd_ = cmd;
            this.arg_ = arg;
        }

        public void actionPerformed(ActionEvent e) {
            this.br_.eventq(this.cmd_, this.arg_);
        }
    }
}

