/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.Flag;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.GlobalToolBar;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.VerticalLineTask;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.parsers.ParserConfigurationException;

public class MarkerFlagTask
extends VerticalLineTask {
    private FlagNamingDialog namingDialog = new FlagNamingDialog();
    private ColumnSeismogramTask colSeis;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$drawable$Flag;

    public MarkerFlagTask() {
        this.line.setColor(Color.YELLOW);
    }

    public void configure(Map params) throws ConfigurationException {
        String taskId = (String)params.get("colSeisTask");
        if (taskId == null || taskId.length() == 0) {
            throw new ConfigurationException("colSeisTask must be set in configuration file");
        }
        TaskAction taskAction = CommonAccess.getCommonAccess().getTaskAction(taskId);
        this.colSeis = (ColumnSeismogramTask)taskAction.getTask();
    }

    public void invoke() {
        if (this.colSeis.getDisplay() instanceof RecordSectionDisplay) {
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentMainFrame(), "You cannot add Pick Flags in Record Section viewing mode.");
        } else {
            GlobalToolBar.setActive(this);
        }
    }

    public void destroy() {
    }

    public void mouseClicked(SDMouseEvent event) {
        this.namingDialog.openDialog(event);
    }

    public String getDefaultName(SeismogramDisplay disp, String name) {
        int i = 0;
        String tagName = name;
        DrawableIterator it = disp.iterator(class$edu$sc$seis$fissuresUtil$display$drawable$Flag == null ? (class$edu$sc$seis$fissuresUtil$display$drawable$Flag = MarkerFlagTask.class$("edu.sc.seis.fissuresUtil.display.drawable.Flag")) : class$edu$sc$seis$fissuresUtil$display$drawable$Flag);
        while (it.hasNext()) {
            Flag cur = (Flag)it.next();
            if (!cur.getName().equals(name)) continue;
            ++i;
        }
        return name + "_" + i;
    }

    public void createFlag(SeismogramDisplay disp, MicroSecondDate time, String name) {
        Flag flag = new Flag(time, name);
        flag.setColor(Color.YELLOW);
        disp.add((Drawable)flag);
        String auxDataString = StdAuxillaryDataNames.PICK_FLAG + '_' + this.getDefaultName(disp, name);
        try {
            disp.getSeismograms()[0].addAuxillaryData((Object)auxDataString, (Object)Flag.createFlagElement((String)name, (MicroSecondDate)time));
        }
        catch (ParserConfigurationException e) {
            GlobalExceptionHandler.handle((String)"There was a problem putting your flag in the seismogram.", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FlagNamingDialog
    extends JFrame {
        private JPanel textPanel = new JPanel();
        private JPanel buttonPanel = new JPanel();
        private JTextField nameField = new JTextField("", 8);
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");
        private SeismogramDisplay currentDisplay = null;
        private MicroSecondDate currentTime = null;

        public FlagNamingDialog() {
            super("Name Flag");
            this.nameField.addKeyListener(new KeyListener(this){
                private final /* synthetic */ FlagNamingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        this.this$1.doCreateAction();
                    } else if (e.getKeyCode() == 27) {
                        this.this$1.hide();
                    }
                }

                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        this.this$1.doCreateAction();
                    } else if (e.getKeyCode() == 27) {
                        this.this$1.hide();
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            this.okButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ FlagNamingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent p1) {
                    this.this$1.doCreateAction();
                }
            });
            this.okButton.setSelected(true);
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ FlagNamingDialog this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent p1) {
                    this.this$1.hide();
                }
            });
            this.textPanel.setLayout(new BorderLayout());
            this.textPanel.add((Component)new JLabel("Flag Name: "), "West");
            this.textPanel.add((Component)this.nameField, "East");
            this.buttonPanel.setLayout(new BorderLayout());
            this.buttonPanel.add((Component)this.okButton, "West");
            this.buttonPanel.add((Component)this.cancelButton, "East");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.textPanel, "North");
            this.getContentPane().add((Component)this.buttonPanel, "South");
            this.pack();
        }

        public void doCreateAction() {
            MarkerFlagTask.this.createFlag(this.currentDisplay, this.currentTime, this.nameField.getText());
            this.hide();
        }

        public void openDialog(SDMouseEvent event) {
            this.setLocationRelativeTo(FrameManager.getManager().getCurrentMainFrame());
            this.currentDisplay = event.getDisplay();
            this.currentTime = event.getTime();
            this.nameField.setText("P");
            this.show();
        }
    }
}

