/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkDCOperations;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.cache.DataCenterRouter;
import edu.sc.seis.fissuresUtil.cache.HardCodeDataCenterRouter;
import edu.sc.seis.fissuresUtil.cache.InstrumentationLoader;
import edu.sc.seis.fissuresUtil.cache.NSNetworkDC;
import edu.sc.seis.fissuresUtil.cache.ProxySeismogramDC;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.chooser.DateChooser;
import edu.sc.seis.fissuresUtil.chooser.DateChooserOptions;
import edu.sc.seis.fissuresUtil.chooser.IntervalChooser;
import edu.sc.seis.fissuresUtil.chooser.IntervalChooserOptions;
import edu.sc.seis.fissuresUtil.database.DBDataCenter;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.fissuresUtil.xml.DCDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.NoCorbaException;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.organizer.Organizer;
import edu.sc.seis.gee.task.ChannelChooserTask;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.log4j.Category;
import org.omg.CORBA.SystemException;

public class LoadSeismogram
implements GUITask {
    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy MMM dd HH:mm:ss z");
    protected boolean guiInitialized = false;
    protected JPanel panel = null;
    protected DataCenterRouter dataCenterRouter;
    protected DataCenterOperations dataCenter;
    protected HashMap nameToDataCenterMap = new HashMap();
    private Map configParams;
    private ChannelChooserTask channelChooserTask;
    private String messageStr = new String();
    private InstrumentationLoader instLoader;
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$gee$task$LoadSeismogram == null ? (class$edu$sc$seis$gee$task$LoadSeismogram = LoadSeismogram.class$("edu.sc.seis.gee.task.LoadSeismogram")) : class$edu$sc$seis$gee$task$LoadSeismogram).getName());
    static /* synthetic */ Class class$edu$sc$seis$gee$task$LoadSeismogram;

    public LoadSeismogram() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.instLoader = new InstrumentationLoader();
        this.instLoader.start();
    }

    public void invoke() throws Exception {
    }

    public JComponent getMoreOptionsGUI() {
        return null;
    }

    public boolean hasMoreOptions() {
        return false;
    }

    public JComponent getGUI() {
        if (!this.guiInitialized) {
            this.guiInitialized = true;
            this.createGUI();
        }
        return this.panel;
    }

    public void destroy() {
    }

    public void createGUI() {
        this.panel = new JPanel();
        IntervalChooserOptions[] options = new IntervalChooserOptions[]{IntervalChooserOptions.SECOND, IntervalChooserOptions.MINUTE, IntervalChooserOptions.HOUR, IntervalChooserOptions.DAY, IntervalChooserOptions.MONTH, IntervalChooserOptions.YEAR};
        final IntervalChooser intervalChooser = new IntervalChooser(options);
        intervalChooser.setSelectedValue(10);
        DateChooserOptions[] dateformat = new DateChooserOptions[]{DateChooserOptions.YEAR, DateChooserOptions.MONTH, DateChooserOptions.DAY, DateChooserOptions.HOUR, DateChooserOptions.MINUTES, DateChooserOptions.SECONDS};
        final DateChooser startDate = new DateChooser(dateformat);
        MicroSecondDate end = ClockUtil.now();
        MicroSecondDate begin = end.subtract(new TimeInterval(10.0, UnitImpl.MINUTE));
        startDate.setDate((Date)begin);
        JPanel endPanel = new JPanel();
        final JLabel endDateLabel = new JLabel("End Date");
        JLabel intervalLabel = new JLabel("Interval");
        JLabel startDateLabel = new JLabel("Start Date");
        JButton okButton = new JButton("OK");
        GridBagLayout bagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        endPanel.setLayout(new FlowLayout());
        endPanel.add(okButton);
        this.panel.setLayout(bagLayout);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.fill = 2;
        bagLayout.setConstraints(startDateLabel, constraints);
        this.panel.add(startDateLabel);
        constraints.weightx = 0.0;
        ++constraints.gridy;
        bagLayout.setConstraints((Component)startDate, constraints);
        this.panel.add((Component)startDate);
        constraints.gridheight = 1;
        constraints.gridy = 2;
        constraints.gridx = 0;
        bagLayout.setConstraints(intervalLabel, constraints);
        this.panel.add(intervalLabel);
        constraints.gridx = 0;
        constraints.gridheight = 1;
        constraints.weightx = 1.0;
        ++constraints.gridy;
        bagLayout.setConstraints((Component)intervalChooser, constraints);
        this.panel.add((Component)intervalChooser);
        constraints.gridx = 0;
        constraints.weighty = 1.0;
        ++constraints.gridy;
        bagLayout.setConstraints(endDateLabel, constraints);
        this.panel.add(endDateLabel);
        ++constraints.gridy;
        bagLayout.setConstraints(endPanel, constraints);
        this.panel.add(endPanel);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Date intervalDate = intervalChooser.addTo(startDate.getDate());
                    endDateLabel.setText("End Date:" + LoadSeismogram.this.dateFormat.format(intervalDate));
                    MicroSecondDate when = new MicroSecondDate(startDate.getDate());
                    Time startTime = when.getFissuresTime();
                    Time endTime = new MicroSecondDate(intervalDate).getFissuresTime();
                    Channel[] channels = LoadSeismogram.this.channelChooserTask.getChannelChooser().getSelectedChannels(when);
                    ChannelId[] chanIds = new ChannelId[channels.length];
                    for (int i = 0; i < channels.length; ++i) {
                        logger.debug((Object)(channels[i].get_id().station_code + "=" + channels[i].my_site.my_station.name));
                        chanIds[i] = channels[i].get_id();
                    }
                    LoadSeismogram.this.populateLocalDataSet(channels);
                    LoadSeismogram.this.loadAndStore(startTime, endTime, chanIds);
                }
                catch (Exception fe) {
                    GlobalExceptionHandler.handle((String)"Exception while Getting the Seismograms", (Throwable)fe);
                }
            }
        });
    }

    protected DataSetSeismogram[] loadAndStore(Time startTime, Time endTime, ChannelId[] channelId) throws ConfigurationException, NoNetworkException {
        DataSetSeismogram[] seis = new DataSetSeismogram[]{};
        boolean tryAgain = true;
        while (tryAgain) {
            try {
                seis = this.retrieveSeismograms(startTime, endTime, channelId);
                this.populateLocalDataSet(seis);
                tryAgain = false;
            }
            catch (SystemException corbaE) {
                int n = JOptionPane.showConfirmDialog(this.panel, "A problem has occured in connecting to the server. Would you like to try again?", "Network Error", 2, 0);
                if (n == 2) {
                    tryAgain = false;
                    seis = new DataSetSeismogram[]{};
                    continue;
                }
                tryAgain = true;
                this.dataCenter = null;
            }
        }
        this.messageStr = new String("Retrieved " + seis.length + " Seismograms");
        JOptionPane.showMessageDialog(null, this.messageStr, "Seismogram Information", 1);
        return seis;
    }

    public DataSetSeismogram retrieveSeismogram(RequestFilter request) throws ConfigurationException, NoNetworkException {
        RequestFilter[] inRequest = new RequestFilter[]{request};
        RequestFilter[] outRequest = this.checkAvailableData(inRequest);
        if (outRequest.length != 0) {
            DCDataSetSeismogram seis = new DCDataSetSeismogram(request, this.getDataCenter());
            ChannelChooser channelChooser = this.channelChooserTask.getChannelChooser();
            if (channelChooser.isNetworkAccessKnown(inRequest[0].channel_id.network_id)) {
                this.instLoader.getInstrumentation((DataSetSeismogram)seis, channelChooser.getNetworkAccess(inRequest[0].channel_id.network_id));
            } else {
                logger.warn((Object)("networkAccess for " + NetworkIdUtil.toString((NetworkId)outRequest[0].channel_id.network_id) + " is not loaded, skipping instrumentation"));
            }
            return seis;
        }
        return null;
    }

    public DataSetSeismogram retrieveSeismogram(Time startTime, Time endTime, ChannelId channelId) throws ConfigurationException, NoNetworkException {
        return this.retrieveSeismogram(new RequestFilter(channelId, startTime, endTime));
    }

    public DataSetSeismogram[] retrieveSeismograms(Time startTime, Time endTime, ChannelId[] channelId) throws ConfigurationException, NoNetworkException {
        LinkedList<DataSetSeismogram> seismos = new LinkedList<DataSetSeismogram>();
        for (int i = 0; i < channelId.length; ++i) {
            DataSetSeismogram seis = this.retrieveSeismogram(new RequestFilter(channelId[i], startTime, endTime));
            if (seis == null) continue;
            seismos.add(seis);
        }
        DataSetSeismogram[] seismoArray = new DataSetSeismogram[]{};
        return seismos.toArray(seismoArray);
    }

    public RequestFilter[] checkAvailableData(RequestFilter[] inFilters) throws ConfigurationException, NoNetworkException {
        RequestFilter[] outFilters;
        if (!NetworkGateKeeper.corbaAccessAllowed()) {
            throw new NoCorbaException();
        }
        try {
            outFilters = this.getDataCenter().available_data(inFilters);
        }
        catch (SystemException e) {
            outFilters = this.getDataCenter().available_data(inFilters);
        }
        return outFilters;
    }

    public void populateLocalDataSet(DataSetSeismogram[] seismograms) {
        Organizer organizer = CommonAccess.getCommonAccess().getOrganizer();
        for (int i = 0; i < seismograms.length; ++i) {
            if (seismograms[i] != null) {
                AuditInfo[] audit_info = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "loaded seismogram " + seismograms[i].getName())};
                organizer.addSeismogram(seismograms[i], audit_info);
                continue;
            }
            logger.warn((Object)"Received a null seismogram");
        }
    }

    public void populateLocalDataSet(Channel[] channels) {
        Organizer organizer = CommonAccess.getCommonAccess().getOrganizer();
        AuditInfo[] audit = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "loaded channel.")};
        for (int counter = 0; counter < channels.length; ++counter) {
            organizer.addChannel(channels[counter], audit);
        }
    }

    public void configure(Map params) throws ConfigurationException {
        this.configParams = params;
        String chanChooserId = (String)params.get("channelChooserTask");
        TaskAction chanChooserAction = CommonAccess.getCommonAccess().getTaskAction(chanChooserId);
        this.channelChooserTask = (ChannelChooserTask)chanChooserAction.getTask();
    }

    void initializeDCRouter() throws ConfigurationException {
        if (!NetworkGateKeeper.corbaAccessAllowed()) {
            return;
        }
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        FissuresNamingService fissuresNamingService = commonAccess.getFissuresNamingService();
        this.dataCenterRouter = new HardCodeDataCenterRouter(fissuresNamingService);
        try {
            this.dataCenter = DBDataCenter.getDataCenter((String)commonAccess.getCacheDirectory(), (String)"GEE_database", (DataCenterOperations)this.dataCenterRouter);
        }
        catch (SQLException e) {
            throw new ConfigurationException("Database problem.", e);
        }
    }

    void addDefaults(DataCenterRouter router) throws ConfigurationException {
        Set keySet = this.configParams.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith("serverDNS")) continue;
            String dnsValue = (String)this.configParams.get(key);
            String nameValue = (String)this.configParams.get("serverName" + key.substring(9));
            logger.debug((Object)(key + " " + key.substring(9) + " " + nameValue));
            if (dnsValue == null && dnsValue.length() == 0 && nameValue == null && nameValue.length() == 0) {
                throw new ConfigurationException("Bad configuration for " + key + " and " + (String)this.configParams.get(key));
            }
            ProxySeismogramDC dc = this.getDataCenter(dnsValue, nameValue);
            this.dataCenterRouter.addDataCenter(dc);
        }
    }

    void addNetworkToRouter(DataCenterRouter router, NetworkAccess net) throws ConfigurationException, NoNetworkException {
        NetworkDCOperations[] netDCs = this.channelChooserTask.getChannelChooser().getNetworkDCs();
        Map netDCToNetMap = this.channelChooserTask.getChannelChooser().getNetDCToNetMap();
        logger.debug((Object)("netDCToNetMap size is " + netDCToNetMap.size() + "  netDCs length =" + netDCs.length));
        Set keySet = this.configParams.keySet();
        Iterator iter = keySet.iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith("serverDNS")) continue;
            String dnsValue = (String)this.configParams.get(key);
            String nameValue = (String)this.configParams.get("serverName" + key.substring(9));
            logger.debug((Object)(key + " " + key.substring(9) + " " + nameValue));
            if (dnsValue == null && dnsValue.length() == 0 && nameValue == null && nameValue.length() == 0) {
                throw new ConfigurationException("Bad configuration for " + key + " and " + (String)this.configParams.get(key));
            }
            try {
                boolean found = false;
                NSNetworkDC nsnetDC = null;
                block3: for (int i = 0; !found && i < netDCs.length; ++i) {
                    nsnetDC = (NSNetworkDC)netDCs[i];
                    NetworkAccess[] nets = (NetworkAccess[])netDCToNetMap.get(netDCs[i]);
                    if (nets == null) continue;
                    for (int j = 0; j < nets.length; ++j) {
                        logger.debug((Object)("nets for dc are " + j + " " + nets[j].get_attributes().get_code()));
                        if (nets[j] != net) continue;
                        found = true;
                        continue block3;
                    }
                }
                logger.debug((Object)("try to match serverDNS " + nsnetDC.getServerDNS() + " " + dnsValue));
                logger.debug((Object)("nsnetDC=" + nsnetDC + " " + netDCToNetMap.keySet().size()));
                if (!nsnetDC.getServerDNS().equals(dnsValue)) continue;
                ProxySeismogramDC dc = this.getDataCenter(dnsValue, nameValue);
                this.dataCenterRouter.addDataCenter(net, dc);
            }
            catch (Exception e) {
                logger.error((Object)"Exception loading seismogram datacenters", (Throwable)e);
                throw new ConfigurationException("Unable to resolve" + dnsValue + " " + nameValue + " FVer=" + "1.0", e);
            }
        }
    }

    public ProxySeismogramDC getDataCenter(String dns, String name) throws ConfigurationException {
        String key = dns + "/" + name;
        if (this.nameToDataCenterMap.containsKey(key)) {
            return (ProxySeismogramDC)this.nameToDataCenterMap.get(key);
        }
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        FissuresNamingService fissuresNamingService = commonAccess.getFissuresNamingService();
        ProxySeismogramDC seisDC = BulletproofVestFactory.vestSeismogramDC((String)dns, (String)name, (FissuresNamingService)fissuresNamingService);
        this.nameToDataCenterMap.put(key, seisDC);
        return seisDC;
    }

    public DataCenterOperations getDataCenter() throws ConfigurationException {
        if (this.dataCenter == null) {
            this.initializeDCRouter();
        }
        return this.dataCenter;
    }

    public DataCenterRouter getDataCenterRouter() throws ConfigurationException {
        if (this.dataCenterRouter == null) {
            this.initializeDCRouter();
        }
        return this.dataCenterRouter;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

