/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.AuditInfo;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.FileNameFilter;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetToXML;
import edu.sc.seis.fissuresUtil.xml.IncomprehensibleDSMLException;
import edu.sc.seis.fissuresUtil.xml.UnsupportedFileTypeException;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.organizer.Organizer;
import edu.sc.seis.gee.task.LoadSacFile;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Category;

public class LoadDataSetTask
extends JPanel
implements Task {
    private boolean loadIntoDisplay = false;
    private boolean bringToFront = false;
    private Map params;
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$gee$task$LoadDataSetTask == null ? (class$edu$sc$seis$gee$task$LoadDataSetTask = LoadDataSetTask.class$("edu.sc.seis.gee.task.LoadDataSetTask")) : class$edu$sc$seis$gee$task$LoadDataSetTask).getName());
    static /* synthetic */ Class class$edu$sc$seis$gee$task$LoadDataSetTask;

    public void invoke() throws ConfigurationException, NoNetworkException {
        String respondId = (String)this.params.get("do_file_input");
        if (respondId != null && respondId.equals("true")) {
            this.showFileGUI();
        } else {
            respondId = (String)this.params.get("do_url_directory");
            if (respondId != null) {
                try {
                    this.loadDataSet(new URL(respondId));
                }
                catch (MalformedURLException e) {
                    throw new ConfigurationException("URL is malformed, " + respondId, e);
                }
            } else {
                respondId = (String)this.params.get("do_jar_file");
                if (respondId != null) {
                    this.loadClassic(respondId);
                } else {
                    respondId = (String)this.params.get("do_url_input");
                    if (respondId != null) {
                        this.showURLInputGUI();
                    } else {
                        throw new ConfigurationException("One of do_file_input, do_url_directory, do_jar_file or do_url_input must be defined");
                    }
                }
            }
        }
        if (this.params.containsKey("automaticAction")) {
            String autoAction = (String)this.params.get("automaticAction");
            if (autoAction.equals("none")) {
                this.loadIntoDisplay = false;
                this.bringToFront = false;
            } else if (autoAction.equals("load into display")) {
                this.loadIntoDisplay = true;
                this.bringToFront = false;
            } else if (autoAction.equals("load into display and bring to front")) {
                this.loadIntoDisplay = true;
                this.bringToFront = true;
            }
        }
    }

    public void destroy() {
    }

    public void loadDataSet(URL url) throws NoNetworkException {
        this.checkForNetUsage(url);
        WorkerThreadPool.getDefaultPool().invokeLater((Runnable)((Object)new DataSetLoader(url)));
    }

    private void checkForNetUsage(URL url) throws NoNetworkException {
        if (!(url.getProtocol().equalsIgnoreCase("file") || url.getProtocol().equalsIgnoreCase("jar") || url.getProtocol().equalsIgnoreCase("jar:file") || NetworkGateKeeper.accessAllowed())) {
            throw new NoNetworkException();
        }
    }

    private void showURLInputGUI() {
        if (!NetworkGateKeeper.accessAllowed()) {
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentMainPanel(), "GEE is unable to get to the network to load a URL", "Network unavailable!", 2);
            return;
        }
        String value = (String)JOptionPane.showInputDialog(FrameManager.getManager().getCurrentMainPanel(), "Select a URL to load", "Load a DataSet from a URL", 3, null, null, "http://");
        if (value == null) {
            return;
        }
        try {
            this.loadDataSet(new URL(value));
        }
        catch (NoNetworkException e) {
            GlobalExceptionHandler.handle((Throwable)e);
        }
        catch (MalformedURLException ex) {
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentMainPanel(), value + " doesn't appear to be a valid URL.  Try navigating to the DataSet file in your browser, copying the location, and pasting it into the dialog", "Invalid URL", 2);
            this.showURLInputGUI();
        }
    }

    private void showFileGUI() {
        JFileChooser jfileChooser = new JFileChooser();
        jfileChooser.setFileFilter((FileFilter)new FileNameFilter(new String[]{"dsml"}));
        jfileChooser.setDialogTitle("Load DataSet");
        int returnVal = jfileChooser.showOpenDialog(this);
        if (returnVal == 0) {
            File file = jfileChooser.getSelectedFile();
            try {
                this.loadDataSet(file.toURL());
            }
            catch (NoNetworkException e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
            catch (MalformedURLException e) {
                GlobalExceptionHandler.handle((String)"Bad file selected.", (Throwable)e);
            }
        }
    }

    public void configure(Map configParams) {
        this.params = configParams;
    }

    private void loadClassic(String dataSetFileName) throws ConfigurationException {
        String fullFileName = "edu/sc/seis/gee/classicDataSets/" + dataSetFileName;
        URL jarURL = (class$edu$sc$seis$gee$task$LoadDataSetTask == null ? (class$edu$sc$seis$gee$task$LoadDataSetTask = LoadDataSetTask.class$("edu.sc.seis.gee.task.LoadDataSetTask")) : class$edu$sc$seis$gee$task$LoadDataSetTask).getClassLoader().getResource(fullFileName);
        if (jarURL != null) {
            try {
                new DataSetLoader(jarURL).run();
            }
            catch (Exception e) {
                throw new ConfigurationException("Couln't load dataset from " + jarURL, e);
            }
        } else {
            throw new ConfigurationException("Unable to find classic dataset for " + fullFileName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class DataSetLoader
    extends AbstractJob {
        boolean placeholderDS = true;
        private URL url;

        public DataSetLoader(URL url) {
            super("Data Set Loader");
            this.url = url;
            JobTracker.getTracker().add((Job)this);
        }

        public void runJob() {
            try {
                this.loadDataSet(this.url);
            }
            catch (Exception ex) {
                GlobalExceptionHandler.handle((String)"A problem occurred while trying to load a DataSet", (Throwable)ex);
            }
        }

        protected void loadDataSet(URL dsURL) throws NoNetworkException, ConfigurationException {
            LoadDataSetTask.this.checkForNetUsage(dsURL);
            this.setStatus("Converting DataSet to XML");
            try {
                DataSet ds = DataSetToXML.load((URL)dsURL);
                Organizer organizer = CommonAccess.getCommonAccess().getOrganizer();
                this.setStatus("Setting audit info");
                AuditInfo[] audit_info = new AuditInfo[]{new AuditInfo(System.getProperty("user.name"), "loaded from " + dsURL.toString())};
                this.setStatus("Adding to organizer");
                organizer.addDataSet(ds, audit_info);
                if (LoadDataSetTask.this.params.containsKey("DataSetBrowser")) {
                    TaskAction dsbAction = CommonAccess.getCommonAccess().getTaskAction((String)LoadDataSetTask.this.params.get("DataSetBrowser"));
                    DataSetBrowser dsb = (DataSetBrowser)dsbAction.getTask();
                    dsb.invoke();
                    dsbAction.checkDisplayLocation();
                    dsb.getTree().expandRow(dsb.getTree().getRowCount() - 1);
                }
                if (LoadDataSetTask.this.loadIntoDisplay) {
                    String[] names = ds.getDataSetSeismogramNames();
                    for (int i = 0; i < names.length; ++i) {
                        LoadSacFile.addToDisplay(ds.getDataSetSeismogram(names[i]), LoadDataSetTask.this.bringToFront);
                    }
                }
            }
            catch (IncomprehensibleDSMLException sax) {
                JOptionPane.showMessageDialog(null, "We had trouble loading the dataset you specified(" + dsURL + ").\n\n" + "The URL must specify a valid DSML file, not a directory or other data\n" + "file.  DMSL files normally end in \".dsml\".  Please check and retry.", "Unable to load dataset", 2);
                logger.debug((Object)("We had trouble loading the dataset you specified(" + dsURL + ")"), (Throwable)sax);
            }
            catch (IOException io) {
                JOptionPane.showMessageDialog(null, "We had trouble reading the dataset you specified(" + dsURL + ").\n", "Unable to load dataset", 2);
                logger.debug((Object)("We had trouble reading the dataset you specified(" + dsURL + ")."), (Throwable)io);
            }
            catch (ParserConfigurationException parser) {
                GlobalExceptionHandler.handle((String)"XML parser misconfigured", (Throwable)parser);
            }
            catch (UnsupportedFileTypeException unsup) {
                GlobalExceptionHandler.handle((String)("Unsupported file type at URL " + dsURL), (Throwable)unsup);
            }
            this.setFinished();
        }
    }
}

