/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.AbstractHandler;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.SAXTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.apache.log4j.Category;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class LayoutTask
extends JPanel
implements SAXTask {
    Map params;
    HashMap layoutParams = new HashMap();
    LinkedList taskList = null;
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$gee$task$LayoutTask == null ? (class$edu$sc$seis$gee$task$LayoutTask = LayoutTask.class$("edu.sc.seis.gee.task.LayoutTask")) : class$edu$sc$seis$gee$task$LayoutTask).getName());
    static /* synthetic */ Class class$edu$sc$seis$gee$task$LayoutTask;
    static /* synthetic */ Class class$java$awt$GridBagConstraints;

    public LayoutTask() {
        this.setLayout(new GridBagLayout());
    }

    public void configure(Map params) throws ConfigurationException {
        this.params = params;
    }

    public AbstractHandler getConfigureHandler(String name, XMLReader parser, AbstractHandler parent) {
        return new MyConfigHandler(name, parser, parent);
    }

    public void invoke() throws ConfigurationException {
        if (this.taskList == null) {
            this.taskList = new LinkedList();
            Iterator it = this.layoutParams.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if (!key.startsWith("layout_")) continue;
                Object value = this.layoutParams.get(key);
                if (value instanceof GridBagConstraints) {
                    GridBagConstraints gbc = (GridBagConstraints)value;
                    this.addToLayout(key, gbc);
                    continue;
                }
                logger.warn((Object)"Can't layout if config value is not element");
            }
        }
    }

    protected void addToLayout(String name, GridBagConstraints gbc) {
        String layoutTaskName = name.substring(7);
        TaskAction taskAction = CommonAccess.getCommonAccess().getTaskAction(layoutTaskName);
        this.taskList.add(taskAction);
        try {
            if (taskAction == null || !(taskAction.getTask() instanceof JComponent)) {
                logger.warn((Object)("Can't layout " + name + " if task is not available."));
                this.add((Component)new JLabel(name), gbc);
            } else {
                Task task = taskAction.getTask();
                task.invoke();
                if (task instanceof JComponent) {
                    JPanel panel = new JPanel();
                    panel.setLayout(new BorderLayout());
                    panel.add((Component)((JComponent)((Object)task)), "Center");
                    JToolBar toolbar = taskAction.getToolBar();
                    if (toolbar != null) {
                        panel.add((Component)toolbar, "North");
                    }
                    this.add((Component)panel, gbc);
                }
            }
        }
        catch (ConfigurationException e) {
            logger.warn((Object)("Can't add to layout " + name), (Throwable)e);
            this.add((Component)new JLabel(name), gbc);
        }
        catch (Exception e) {
            logger.warn((Object)"Can't get task ", (Throwable)e);
            this.add((Component)new JLabel(name), gbc);
        }
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MyConfigHandler
    extends AbstractHandler {
        String paramName = "";
        String currValue = "";
        GridBagConstraints gbc;

        public MyConfigHandler(String name, XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
            this.paramName = name;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (localName == "gridbag") {
                this.gbc = new GridBagConstraints();
            }
            this.currValue = "";
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.currValue = this.currValue == null ? new String(ch, start, length) : this.currValue + new String(ch, start, length);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("complexValue")) {
                LayoutTask.this.layoutParams.put(this.paramName, this.gbc);
                super.endElement(namespaceURI, localName, qName);
            } else {
                try {
                    Class gbcClass;
                    Class clazz = gbcClass = class$java$awt$GridBagConstraints == null ? (class$java$awt$GridBagConstraints = LayoutTask.class$("java.awt.GridBagConstraints")) : class$java$awt$GridBagConstraints;
                    if (localName.equals("gridx") || localName.equals("gridy") || localName.equals("gridwidth") || localName.equals("gridheight") || localName.equals("ipadx") || localName.equals("ipady") || localName.equals("insets")) {
                        Field f = gbcClass.getField(localName);
                        f.set(this.gbc, new Integer(this.currValue));
                    } else if (localName.equals("weightx") || localName.equals("weighty")) {
                        Field f = gbcClass.getField(localName);
                        f.set(this.gbc, new Double(this.currValue));
                    } else if (localName.equals("fill")) {
                        if (this.currValue.equals("NONE")) {
                            this.gbc.fill = 0;
                        } else if (this.currValue.equals("HORIZONTAL")) {
                            this.gbc.fill = 2;
                        } else if (this.currValue.equals("VERTICAL")) {
                            this.gbc.fill = 3;
                        } else if (this.currValue.equals("BOTH")) {
                            this.gbc.fill = 1;
                        }
                    } else if (localName.equals("anchor")) {
                        if (this.currValue.equals("CENTER")) {
                            this.gbc.anchor = 10;
                        } else if (this.currValue.equals("NORTHWEST")) {
                            this.gbc.anchor = 18;
                        } else if (this.currValue.equals("NORTH")) {
                            this.gbc.anchor = 11;
                        } else if (this.currValue.equals("NORTHEAST")) {
                            this.gbc.anchor = 12;
                        } else if (this.currValue.equals("EAST")) {
                            this.gbc.anchor = 13;
                        } else if (this.currValue.equals("SOUTHEAST")) {
                            this.gbc.anchor = 14;
                        } else if (this.currValue.equals("SOUTH")) {
                            this.gbc.anchor = 15;
                        } else if (this.currValue.equals("SOUTHWEST")) {
                            this.gbc.anchor = 16;
                        } else if (this.currValue.equals("WEST")) {
                            this.gbc.anchor = 17;
                        }
                    }
                }
                catch (IllegalArgumentException e) {
                    GlobalExceptionHandler.handle((String)"Bad reflection ", (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    GlobalExceptionHandler.handle((String)"Bad reflection ", (Throwable)e);
                }
                catch (NullPointerException e) {
                    GlobalExceptionHandler.handle((String)"Bad reflection ", (Throwable)e);
                }
                catch (NoSuchFieldException e) {
                    GlobalExceptionHandler.handle((String)"Bad reflection ", (Throwable)e);
                }
                this.currValue = "";
            }
        }
    }
}

