/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.FileNameFilter;
import edu.sc.seis.fissuresUtil.display.TextTable;
import edu.sc.seis.fissuresUtil.display.drawable.Flag;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.DataSetCrawler;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;

public class FlagExportTask
extends DataSetCrawler
implements Task {
    private static final String[] template = new String[]{"Flag Name", "Time from Origin (s)", "TauP P Wave (s)", "Prediction Difference (s)", "Distance From Origin (deg)", "Back Azimuth (deg)", "Channel", "Event Name", "Event Latitude", "Event Longitude", "Event Depth (km)", "Magnitude", "Origin Time", "Flag Time"};
    private TaskAction dsbAction;
    private DataSetBrowser dataSetBrowser;
    private TextTable textTable = new TextTable(Flag.getFlagDataHeader((String[])template).length, true);
    private boolean tabDelimited = true;
    private PickOptionsDialogue optionsDialogue = new PickOptionsDialogue();

    public void configure(Map params) throws ConfigurationException {
        if (!params.containsKey("DataSetBrowser")) {
            throw new ConfigurationException("FlagExportTask must have a DataSetBrowser associated with it");
        }
        String displayId = (String)params.get("DataSetBrowser");
        this.dsbAction = CommonAccess.getCommonAccess().getTaskAction(displayId);
        this.initCrawler(this.dsbAction);
        this.dataSetBrowser = (DataSetBrowser)this.dsbAction.getTask();
        this.textTable.addRow(Flag.getFlagDataHeader((String[])template), true);
    }

    public void invoke() throws Exception {
        this.textTable.clear();
        boolean doneSomething = this.crawlDataSets();
        if (this.textTable.numRows() > 0) {
            this.optionsDialogue.setVisible(true);
        } else if (doneSomething) {
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(), "No picks were found in current dataset.", "No Picks", 1);
        }
    }

    public void destroy() {
    }

    public void crawlAction(DataSetSeismogram seis) {
        EventAccessOperations event = seis.getDataSet().getEvent();
        this.textTable.join(Flag.getFlagData((DataSetSeismogram)seis, (EventAccessOperations)event, (String[])template));
    }

    public void createFileGUI() throws ConfigurationException {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        String[] extensions = new String[]{"txt"};
        fc.setFileFilter((FileFilter)new FileNameFilter(extensions));
        fc.setDialogTitle("Save Pick Flag Data");
        String defName = "picks.txt";
        fc.setSelectedFile(new File(defName));
        int returnVal = fc.showSaveDialog(FrameManager.getManager().getCurrentFrame());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            PickSaver saver = this.tabDelimited ? new PickSaver(this.textTable.toString("\t"), file) : new PickSaver(this.textTable.toString(), file);
            JobTracker.getTracker().add((Job)saver);
            WorkerThreadPool.getDefaultPool().invokeLater((Runnable)((Object)saver));
        }
    }

    class PickSaver
    extends AbstractJob {
        File file;
        String data;

        PickSaver(String data, File file) {
            super("Save pick flags");
            this.file = file;
            this.data = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void runJob() {
            block11: {
                FileWriter writer;
                block10: {
                    writer = null;
                    writer = new FileWriter(this.file);
                    writer.write(this.data);
                    Object var4_2 = null;
                    if (writer == null) break block10;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        GlobalExceptionHandler.handle((String)"unable to close the file.", (Throwable)e2);
                    }
                }
                this.setFinished();
                {
                    break block11;
                    catch (Throwable e) {
                        GlobalExceptionHandler.handle((String)"problem saving pick flags.", (Throwable)e);
                        Object var4_3 = null;
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException e2) {
                                GlobalExceptionHandler.handle((String)"unable to close the file.", (Throwable)e2);
                            }
                        }
                        this.setFinished();
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            GlobalExceptionHandler.handle((String)"unable to close the file.", (Throwable)e2);
                        }
                    }
                    this.setFinished();
                    throw throwable;
                }
            }
        }
    }

    private class PickOptionsDialogue
    extends JFrame {
        private JPanel radioButtonPanel = new JPanel();
        private JPanel controlButtonPanel = new JPanel();
        private JRadioButton tabDelimButton = new JRadioButton("Tab Delimited");
        private JRadioButton spaceFilledButton = new JRadioButton("Formatted Table");
        private ButtonGroup buttonGroup = new ButtonGroup();
        private Border groupBorder = BorderFactory.createTitledBorder("Text Output");
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public PickOptionsDialogue() {
            super("Set Text Formatting");
            this.getContentPane().setLayout(new BorderLayout());
            this.buttonGroup.add(this.tabDelimButton);
            this.buttonGroup.add(this.spaceFilledButton);
            this.radioButtonPanel.setBorder(this.groupBorder);
            this.radioButtonPanel.add(this.tabDelimButton);
            this.radioButtonPanel.add(this.spaceFilledButton);
            this.getContentPane().add((Component)this.radioButtonPanel, "North");
            this.okButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PickOptionsDialogue this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    PickOptionsDialogue.access$000(this.this$1);
                }
            });
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ PickOptionsDialogue this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    PickOptionsDialogue.access$100(this.this$1);
                }
            });
            this.controlButtonPanel.add(this.okButton);
            this.controlButtonPanel.add(this.cancelButton);
            this.tabDelimButton.setSelected(true);
            this.okButton.setSelected(true);
            this.getContentPane().add((Component)this.radioButtonPanel, "North");
            this.getContentPane().add((Component)this.controlButtonPanel, "South");
            this.pack();
        }

        private void doOKAction() {
            try {
                if (this.tabDelimButton.isSelected()) {
                    FlagExportTask.this.tabDelimited = true;
                } else {
                    FlagExportTask.this.tabDelimited = false;
                }
                this.setVisible(false);
                FlagExportTask.this.createFileGUI();
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
        }

        private void doCancelAction() {
            this.setVisible(false);
        }

        public void setVisible(boolean b) {
            this.setLocationRelativeTo(FrameManager.getManager().getCurrentMainFrame());
            super.setVisible(b);
        }

        static /* synthetic */ void access$000(PickOptionsDialogue x0) {
            x0.doOKAction();
        }

        static /* synthetic */ void access$100(PickOptionsDialogue x0) {
            x0.doCancelAction();
        }
    }
}

