/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.IfNetwork.StationId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.StationIdUtil;
import edu.sc.seis.fissuresUtil.display.EventInfoDisplay;
import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.GUITask;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JComponent;
import org.apache.log4j.Category;

public class EventInfoTask
implements GUITask {
    protected Map configParams;
    protected EventInfoDisplay display = null;
    protected ColumnSeismogramTask colSeis = null;
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$gee$task$EventInfoTask == null ? (class$edu$sc$seis$gee$task$EventInfoTask = EventInfoTask.class$("edu.sc.seis.gee.task.EventInfoTask")) : class$edu$sc$seis$gee$task$EventInfoTask).getName());
    static /* synthetic */ Class class$edu$sc$seis$gee$task$EventInfoTask;

    public void configure(Map params) throws ConfigurationException {
        this.configParams = params;
        this.display = new EventInfoDisplay();
        if (params.containsKey("colSeisDisplay")) {
            String colSeisId = (String)params.get("colSeisDisplay");
            this.colSeis = (ColumnSeismogramTask)CommonAccess.getCommonAccess().getTaskAction(colSeisId).getTask();
        }
    }

    public JComponent getGUI() throws ConfigurationException {
        return this.display;
    }

    public boolean hasMoreOptions() {
        return false;
    }

    public JComponent getMoreOptionsGUI() {
        return null;
    }

    public void invoke() throws ConfigurationException {
        if (this.colSeis != null) {
            HashMap stations;
            HashMap events = new HashMap();
            LinkedList displays = new LinkedList();
            if (this.colSeis.getDisplay() instanceof VerticalSeismogramDisplay) {
                displays = ((VerticalSeismogramDisplay)this.colSeis.getDisplay()).getDisplays();
            } else if (this.colSeis.getDisplay() instanceof RecordSectionDisplay) {
                displays.add(this.colSeis.getDisplay());
            }
            Iterator<Object> it = displays.iterator();
            while (it.hasNext()) {
                SeismogramDisplay currDisp = (SeismogramDisplay)it.next();
                DataSetSeismogram[] seismos = currDisp.getSeismograms();
                for (int i = 0; i < seismos.length; ++i) {
                    DataSet dataset = seismos[i].getDataSet();
                    EventAccessOperations currEvent = dataset.getEvent();
                    if (!events.containsKey(currEvent)) {
                        events.put(currEvent, new HashMap());
                    }
                    stations = (HashMap)events.get(currEvent);
                    try {
                        Channel chan = dataset.getChannel(seismos[i].getRequestFilter().channel_id);
                        if (chan == null) continue;
                        Station currStation = chan.my_site.my_station;
                        stations.put(StationIdUtil.toString((StationId)currStation.get_id()), currStation);
                        continue;
                    }
                    catch (Throwable e) {
                        GlobalExceptionHandler.handle((String)("Problem getting the station information for channel " + ChannelIdUtil.toString((ChannelId)seismos[i].getRequestFilter().channel_id)), (Throwable)e);
                    }
                }
            }
            this.display.clear();
            it = events.keySet().iterator();
            if (it.hasNext()) {
                while (it.hasNext()) {
                    EventAccessOperations currEvent = (EventAccessOperations)it.next();
                    stations = (HashMap)events.get(currEvent);
                    Collection stationCollection = stations.values();
                    Station[] stationArray = stationCollection.toArray(new Station[0]);
                    this.display.appendEventStation(currEvent, stationArray);
                }
            } else {
                this.display.appendEvent(null);
            }
        }
    }

    public void destroy() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

