/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.display.mouse.SDMouseAdapter;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.CursorUtil;
import edu.sc.seis.gee.task.GlobalToolBar;
import edu.sc.seis.gee.task.Task;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.util.Map;

public class DragTask
extends SDMouseAdapter
implements Task {
    private Cursor handOpen;
    private Cursor handClosed;
    private MouseEvent previousEvent;
    private boolean isPressed = false;
    private static final String BASE_PATH = "edu/sc/seis/gee/data/images/";

    public void configure(Map params) throws ConfigurationException {
        if (!params.containsKey("defaultcursor")) {
            throw new ConfigurationException("defaultcursor not set");
        }
        String imagePath = (String)params.get("defaultcursor");
        imagePath = BASE_PATH + imagePath;
        this.handOpen = CursorUtil.getCursor("HandOpen", imagePath, 0.5f, 0.5f);
        if (!params.containsKey("dragcursor")) {
            throw new ConfigurationException("dragcursor not set");
        }
        imagePath = (String)params.get("dragcursor");
        imagePath = BASE_PATH + imagePath;
        this.handClosed = CursorUtil.getCursor("ClosedHand", imagePath, 0.5f, 0.5f);
    }

    public void invoke() {
        GlobalToolBar.setActive(this);
    }

    public void destroy() {
    }

    public void mouseDragged(SDMouseEvent me) {
        if (this.previousEvent != null) {
            double width = me.getComponent().getSize().width;
            double xDiff = -((double)(me.getX() - this.previousEvent.getX()) / width);
            me.getDisplay().getTimeConfig().shaleTime(xDiff, 1.0);
        }
        this.previousEvent = me;
    }

    public void mousePressed(SDMouseEvent me) {
        this.isPressed = true;
        this.previousEvent = me;
        this.setCursor(this.handClosed, (MouseEvent)me);
    }

    public void mouseReleased(SDMouseEvent me) {
        this.isPressed = false;
        this.previousEvent = null;
        this.setCursor(this.handOpen, (MouseEvent)me);
    }

    public void mouseEntered(SDMouseEvent me) {
        this.setCursor(this.handOpen, (MouseEvent)me);
    }

    public void mouseExited(SDMouseEvent me) {
        if (!this.isPressed) {
            this.setCursor(Cursor.getDefaultCursor(), (MouseEvent)me);
        }
    }

    private void setCursor(Cursor cursor, MouseEvent me) {
        me.getComponent().setCursor(cursor);
    }
}

