/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.FileNameFilter;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.Task;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public abstract class DisplayOutputTask
implements Task {
    protected String dialogueTitle;

    public abstract void configure(Map var1) throws ConfigurationException;

    public void invoke() throws Exception {
        this.createFileGUI();
    }

    public void destroy() {
    }

    protected void createFileGUI() throws ConfigurationException {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        String[] extensions = new String[]{"png"};
        fc.setFileFilter((FileFilter)new FileNameFilter(extensions));
        fc.setDialogTitle(this.dialogueTitle);
        String defName = "output.png";
        fc.setSelectedFile(new File(defName));
        int returnVal = fc.showSaveDialog(FrameManager.getManager().getCurrentFrame());
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            Saver saver = new Saver(file);
            JobTracker.getTracker().add((Job)saver);
            WorkerThreadPool.getDefaultPool().invokeLater((Runnable)((Object)saver));
        }
    }

    protected abstract void save(File var1) throws IOException;

    protected class Saver
    extends AbstractJob {
        File file;

        Saver(File file) {
            super("Save display image");
            this.file = file;
        }

        public void runJob() {
            try {
                DisplayOutputTask.this.save(this.file);
            }
            catch (IOException e) {
                GlobalExceptionHandler.handle((String)"problem saving display to image file", (Throwable)e);
            }
            this.setFinished();
        }
    }
}

