/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.fissuresUtil.freq.SeisGramText;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.FilterTarget;
import edu.sc.seis.gee.task.FilterTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.ToolPaletteTask;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CustomFilterTask
extends JPanel
implements Task {
    private boolean guiInitialized = false;
    Map configParams;
    private String[] types = new String[]{"ButterWorth"};
    private String[] styles = new String[]{"LP", "BP", "HP", "BS"};
    private String[] passes = new String[]{"CAUSAL", "NONCAUSAL"};
    protected SeisGramText localeText = new SeisGramText(null);
    protected FilterTarget[] filterTarget;
    private ToolPaletteTask paletteTask;
    private TaskAction taskAction;
    HashMap customFilters = new HashMap();

    public void invoke() {
        if (!this.guiInitialized) {
            this.guiInitialized = true;
            this.createGUI();
        }
    }

    public void configure(Map params) throws ConfigurationException {
        this.configParams = params;
        if (params.containsKey("filterTargets")) {
            String filterTargetIds = (String)params.get("filterTargets");
            this.filterTarget = FilterTask.parseFilterTargets(filterTargetIds);
        }
    }

    public void destroy() {
    }

    private void createGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.fill = 2;
        this.setLayout(gridBagLayout);
        final JComboBox filterType = new JComboBox();
        final JComboBox filterStyle = new JComboBox();
        final JComboBox filterPasses = new JComboBox();
        JLabel filterTypeLabel = new JLabel("filterType");
        JLabel filterStyleLabel = new JLabel("filterStyle");
        JLabel filterPassesLabel = new JLabel("passes");
        this.populateComboBox(filterType, this.types);
        this.populateComboBox(filterStyle, this.styles);
        this.populateComboBox(filterPasses, this.passes);
        gridBagLayout.setConstraints(filterTypeLabel, constraints);
        this.add(filterTypeLabel);
        constraints.gridwidth = 1;
        ++constraints.gridx;
        gridBagLayout.setConstraints(filterStyleLabel, constraints);
        this.add(filterStyleLabel);
        constraints.gridwidth = 1;
        ++constraints.gridx;
        gridBagLayout.setConstraints(filterPassesLabel, constraints);
        this.add(filterPassesLabel);
        constraints.gridx = 0;
        ++constraints.gridy;
        gridBagLayout.setConstraints(filterType, constraints);
        this.add(filterType);
        ++constraints.gridx;
        gridBagLayout.setConstraints(filterStyle, constraints);
        this.add(filterStyle);
        constraints.gridwidth = 1;
        ++constraints.gridx;
        gridBagLayout.setConstraints(filterPasses, constraints);
        this.add(filterPasses);
        final JTextField poles = new JTextField("2", 10);
        JLabel polesLabel = new JLabel("poles");
        final JTextField minFrequency = new JTextField(".01");
        final JLabel minFrequencyLabel = new JLabel("minFreq");
        final JTextField maxFrequency = new JTextField("1");
        final JLabel maxFrequencyLabel = new JLabel("maxFreq");
        final JTextField filterName = new JTextField("noName");
        JLabel filterNameLabel = new JLabel("Enter Name for the Filter: ");
        JButton applyButton = new JButton("Apply");
        this.applyVisibility(filterStyle, minFrequencyLabel, minFrequency, maxFrequencyLabel, maxFrequency);
        constraints.gridx = 0;
        ++constraints.gridy;
        gridBagLayout.setConstraints(polesLabel, constraints);
        this.add(polesLabel);
        ++constraints.gridx;
        gridBagLayout.setConstraints(minFrequencyLabel, constraints);
        this.add(minFrequencyLabel);
        ++constraints.gridx;
        gridBagLayout.setConstraints(maxFrequencyLabel, constraints);
        this.add(maxFrequencyLabel);
        constraints.gridx = 0;
        ++constraints.gridy;
        gridBagLayout.setConstraints(poles, constraints);
        this.add(poles);
        ++constraints.gridx;
        gridBagLayout.setConstraints(minFrequency, constraints);
        this.add(minFrequency);
        ++constraints.gridx;
        gridBagLayout.setConstraints(maxFrequency, constraints);
        this.add(maxFrequency);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        gridBagLayout.setConstraints(filterNameLabel, constraints);
        this.add(filterNameLabel);
        constraints.gridx += 2;
        constraints.gridwidth = 1;
        gridBagLayout.setConstraints(filterName, constraints);
        this.add(filterName);
        constraints.gridwidth = 3;
        ++constraints.gridy;
        constraints.gridx = 0;
        gridBagLayout.setConstraints(applyButton, constraints);
        this.add(applyButton);
        constraints.gridwidth = 1;
        applyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                NamedFilter filter;
                int polesValue = 2;
                try {
                    polesValue = Integer.parseInt(poles.getText());
                }
                catch (NumberFormatException nfe) {
                    GlobalExceptionHandler.handle((String)("poles must be an integer: '" + poles.getText() + "'"), (Throwable)nfe);
                }
                double minFrequencyValue = 0.0;
                try {
                    minFrequencyValue = Double.parseDouble(minFrequency.getText());
                }
                catch (NumberFormatException nfe) {
                    GlobalExceptionHandler.handle((String)("min frequency must be an number: '" + poles.getText() + "'"), (Throwable)nfe);
                }
                double maxFrequencyValue = 0.0;
                try {
                    maxFrequencyValue = Double.parseDouble(maxFrequency.getText());
                }
                catch (NumberFormatException nfe) {
                    GlobalExceptionHandler.handle((String)("max frequency must be an number: '" + poles.getText() + "'"), (Throwable)nfe);
                }
                String filterTypeValue = (String)filterType.getSelectedItem();
                String filterStyleValue = (String)filterStyle.getSelectedItem();
                String filterPassesValue = (String)filterPasses.getSelectedItem();
                minFrequencyValue = CustomFilterTask.this.getMinFrequencyValue(minFrequencyValue, filterStyleValue);
                maxFrequencyValue = CustomFilterTask.this.getMaxFrequencyValue(maxFrequencyValue, filterStyleValue);
                String fName = filterName.getText();
                if (CustomFilterTask.this.customFilters.containsKey(fName) && (filter = (NamedFilter)CustomFilterTask.this.customFilters.get(filterName.getText())).getVisibility()) {
                    CustomFilterTask.this.applyFilter(fName);
                    CustomFilterTask.this.customFilters.remove(fName);
                }
                CustomFilterTask.this.createFilter(filterTypeValue, filterStyleValue, filterPassesValue, polesValue, minFrequencyValue, maxFrequencyValue, filterName.getText());
            }
        });
        filterStyle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                CustomFilterTask.this.applyVisibility(filterStyle, minFrequencyLabel, minFrequency, maxFrequencyLabel, maxFrequency);
            }
        });
    }

    private void applyFilter(String name) {
        NamedFilter filter = (NamedFilter)this.customFilters.get(name);
        filter.toggleVisibility();
        for (int i = 0; i < this.filterTarget.length; ++i) {
            this.filterTarget[i].applyFilter(filter, filter.getVisibility());
        }
    }

    private double getMinFrequencyValue(double minFreq, String style) {
        if (style.equals("LP")) {
            return 0.0;
        }
        return minFreq;
    }

    private double getMaxFrequencyValue(double maxFreq, String style) {
        if (style.equals("HP")) {
            return 10000.0;
        }
        return maxFreq;
    }

    private void applyVisibility(JComboBox filterStyleBox, JLabel minFrequencyLabel, JTextField minFrequency, JLabel maxFrequencyLabel, JTextField maxFrequency) {
        String filterStyle = (String)filterStyleBox.getSelectedItem();
        if (filterStyle.equals("LP")) {
            minFrequencyLabel.setVisible(false);
            minFrequency.setVisible(false);
            maxFrequencyLabel.setVisible(true);
            maxFrequency.setVisible(true);
        } else if (filterStyle.equals("HP")) {
            minFrequencyLabel.setVisible(true);
            minFrequency.setVisible(true);
            maxFrequencyLabel.setVisible(false);
            maxFrequency.setVisible(false);
        } else if (filterStyle.equals("BP")) {
            minFrequencyLabel.setVisible(true);
            minFrequency.setVisible(true);
            maxFrequencyLabel.setVisible(true);
            maxFrequency.setVisible(true);
        } else if (filterStyle.equals("BS")) {
            minFrequencyLabel.setVisible(true);
            minFrequency.setVisible(true);
            maxFrequencyLabel.setVisible(true);
            maxFrequency.setVisible(true);
        }
    }

    private void createFilter(String filterType, String filterStyle, String passes, int poles, double minFrequency, double maxFrequency, String filterName) {
        int filterPassType = 0;
        filterPassType = passes.equals("CAUSAL") ? 0 : 1;
        System.out.println("Create filter: " + this.localeText + " " + minFrequency + " " + maxFrequency + " " + poles + " " + filterPassType);
        NamedFilter filter = new NamedFilter(this.localeText, minFrequency, maxFrequency, poles, filterPassType);
        filter.setVisibility(false);
        this.customFilters.put(filterName, filter);
        this.applyFilter(filterName);
    }

    private void populateComboBox(JComboBox comboBox, String[] values) {
        for (int counter = 0; counter < values.length; ++counter) {
            comboBox.addItem(values[counter]);
        }
    }
}

