/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.PlaceholderImage;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class CopyFromJarTask
extends PlaceholderImage {
    String buttonName = "Save Locally";
    String outputDirName = "output";

    public void configure(Map params) throws ConfigurationException {
        super.configure(params);
        if (params.containsKey("saveButtonName")) {
            this.buttonName = (String)params.get("saveButtonName");
        }
        if (params.containsKey("outputDirectoryName")) {
            this.outputDirName = (String)params.get("outputDirectoryName");
        }
    }

    public void invoke() {
        if (this.panel == null) {
            this.copy();
        }
    }

    public JComponent getGUI() throws ConfigurationException {
        JComponent superComponent = super.getGUI();
        JPanel myPanel = new JPanel();
        myPanel.setLayout(new BorderLayout());
        myPanel.add((Component)superComponent, "Center");
        JButton copy = new JButton(this.buttonName);
        copy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CopyFromJarTask.this.copy();
            }
        });
        myPanel.add((Component)copy, "South");
        return myPanel;
    }

    void copy() {
        Iterator it = this.params.keySet().iterator();
        String outDirname = this.chooseOutputFile();
        if (outDirname == null) {
            return;
        }
        File outDir = new File(outDirname);
        outDir.mkdirs();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object val = this.params.get(key);
            if (!key.startsWith("copy")) continue;
            String filename = (String)val;
            File outFile = new File(outDir, filename.substring(filename.lastIndexOf("/")));
            try {
                URL resourceURL = this.getClass().getClassLoader().getResource(filename);
                BufferedInputStream in = new BufferedInputStream(resourceURL.openStream());
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outFile));
                byte[] tmp = new byte[512];
                int numRead = in.read(tmp, 0, tmp.length);
                while (numRead > 0) {
                    out.write(tmp, 0, numRead);
                    numRead = in.read(tmp, 0, tmp.length);
                }
                in.close();
                in = null;
                out.close();
                out = null;
            }
            catch (FileNotFoundException e) {
                GlobalExceptionHandler.handle((String)("Problem saving " + filename + " to " + outFile.getAbsolutePath()), (Throwable)e);
            }
            catch (IOException e) {
                GlobalExceptionHandler.handle((String)("Problem saving " + filename + " to " + outFile.getAbsolutePath()), (Throwable)e);
            }
        }
    }

    private String chooseOutputFile() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Save to Directory");
        fc.setSelectedFile(new File(this.outputDirName));
        int returnVal = fc.showSaveDialog(null);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            if (file.exists() && !file.isDirectory()) {
                Object[] options = new String[]{"Replace", "Choose Again", "Cancel"};
                int n = JOptionPane.showOptionDialog(FrameManager.getManager().getCurrentFrame(), "File " + file.getName() + " exists, replace?", "File Exists", 1, 3, null, options, options[0]);
                if (n == 2) {
                    return null;
                }
                if (n == 2) {
                    return this.chooseOutputFile();
                }
                file.delete();
            }
            String fileName = file.getAbsolutePath();
            return file.getAbsolutePath();
        }
        return null;
    }
}

