/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.netConnChecker.ConnChecker;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatus;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatusChangedListener;
import edu.sc.seis.fissuresUtil.netConnChecker.ConnStatusResult;
import edu.sc.seis.fissuresUtil.netConnChecker.CorbaChecker;
import edu.sc.seis.fissuresUtil.netConnChecker.HTTPChecker;
import edu.sc.seis.fissuresUtil.netConnChecker.StatusChangedEvent;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.Task;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import org.apache.log4j.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA_2_3.ORB;

public class ConnectionStatusTask
extends JPanel
implements Task,
ConnStatusChangedListener {
    private Map params;
    private ImageIcon green;
    private ImageIcon red;
    private ImageIcon yellow;
    private ImageIcon blue;
    private Map statusIcons = new HashMap();
    private static boolean built = false;
    private GridBagLayout grid = new GridBagLayout();
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$gee$task$ConnectionStatusTask == null ? (class$edu$sc$seis$gee$task$ConnectionStatusTask = ConnectionStatusTask.class$("edu.sc.seis.gee.task.ConnectionStatusTask")) : class$edu$sc$seis$gee$task$ConnectionStatusTask));
    static /* synthetic */ Class class$edu$sc$seis$gee$task$ConnectionStatusTask;

    public ConnectionStatusTask() {
        String imageFilename = "green.gif";
        String defaultsFilename = "edu/sc/seis/gee/data/images/";
        String fileName = defaultsFilename + imageFilename;
        this.green = new ImageIcon((class$edu$sc$seis$gee$task$ConnectionStatusTask == null ? (class$edu$sc$seis$gee$task$ConnectionStatusTask = ConnectionStatusTask.class$("edu.sc.seis.gee.task.ConnectionStatusTask")) : class$edu$sc$seis$gee$task$ConnectionStatusTask).getClassLoader().getResource(fileName));
        fileName = defaultsFilename + "yellow.gif";
        this.yellow = new ImageIcon((class$edu$sc$seis$gee$task$ConnectionStatusTask == null ? (class$edu$sc$seis$gee$task$ConnectionStatusTask = ConnectionStatusTask.class$("edu.sc.seis.gee.task.ConnectionStatusTask")) : class$edu$sc$seis$gee$task$ConnectionStatusTask).getClassLoader().getResource(fileName));
        fileName = defaultsFilename + "red.gif";
        this.red = new ImageIcon((class$edu$sc$seis$gee$task$ConnectionStatusTask == null ? (class$edu$sc$seis$gee$task$ConnectionStatusTask = ConnectionStatusTask.class$("edu.sc.seis.gee.task.ConnectionStatusTask")) : class$edu$sc$seis$gee$task$ConnectionStatusTask).getClassLoader().getResource(fileName));
        fileName = defaultsFilename + "blue.gif";
        this.blue = new ImageIcon((class$edu$sc$seis$gee$task$ConnectionStatusTask == null ? (class$edu$sc$seis$gee$task$ConnectionStatusTask = ConnectionStatusTask.class$("edu.sc.seis.gee.task.ConnectionStatusTask")) : class$edu$sc$seis$gee$task$ConnectionStatusTask).getClassLoader().getResource(fileName));
    }

    public void statusChanged(StatusChangedEvent e) {
        this.updateStatus();
    }

    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        this.setLayout(this.grid);
        if (!built) {
            Iterator it = params.keySet().iterator();
            while (it.hasNext()) {
                HTTPChecker config = null;
                String cur = (String)it.next();
                if (params.get(cur) instanceof String) {
                    String url = (String)params.get(cur);
                    if (url.startsWith("http")) {
                        config = new HTTPChecker(cur, url);
                    } else if (url.startsWith("corbaloc")) {
                        ORB orb = CommonAccess.getCommonAccess().getORB();
                        Object rootObj = orb.string_to_object(url);
                        config = new CorbaChecker(rootObj, cur);
                    }
                }
                if (config == null) continue;
                config.addConnStatusChangedListener((ConnStatusChangedListener)this);
                CommonAccess.getCommonAccess().add((ConnChecker)config);
            }
            built = true;
        }
    }

    public void invoke() {
        this.updateStatus();
    }

    public void destroy() {
    }

    private void updateStatus() {
        CommonAccess ca = CommonAccess.getCommonAccess();
        ConnChecker[] connCheckers = ca.getChecker().getCheckers();
        boolean newChecker = false;
        for (int i = 0; i < connCheckers.length; ++i) {
            ConnStatusResult status = connCheckers[i].getStatus();
            JLabel label = null;
            if (this.statusIcons.containsKey(connCheckers[i])) {
                label = (JLabel)this.statusIcons.get(connCheckers[i]);
            } else {
                label = new JLabel();
                this.statusIcons.put(connCheckers[i], label);
                connCheckers[i].addConnStatusChangedListener((ConnStatusChangedListener)this);
                newChecker = true;
            }
            if (status.getStatus() == ConnStatus.SUCCESSFUL) {
                label.setIcon(this.green);
                continue;
            }
            if (status.getStatus() == ConnStatus.TRYING) {
                label.setIcon(this.yellow);
                continue;
            }
            if (status.getStatus() == ConnStatus.UNKNOWN) {
                label.setIcon(this.blue);
                continue;
            }
            label.setIcon(this.red);
        }
        if (newChecker) {
            this.createGUI();
        }
    }

    private void createGUI() {
        this.removeAll();
        JButton retryButton = new JButton("Retry Connections");
        JPanel endPanel = new JPanel();
        endPanel.setLayout(new FlowLayout());
        endPanel.add(retryButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridy = 0;
        constraints.fill = 2;
        Iterator iter = this.statusIcons.keySet().iterator();
        logger.debug((java.lang.Object)("The size of the statusIcons is " + this.statusIcons.size()));
        while (iter.hasNext()) {
            ConnChecker key = (ConnChecker)iter.next();
            JLabel keyLabel = new JLabel(key.toString());
            JLabel addLabel = (JLabel)this.statusIcons.get(key);
            constraints.gridx = 0;
            this.grid.setConstraints(keyLabel, constraints);
            this.add(keyLabel);
            ++constraints.gridx;
            this.grid.setConstraints(addLabel, constraints);
            this.add(addLabel);
            constraints.gridy += 3;
        }
        constraints.gridwidth = 2;
        constraints.gridx = 0;
        JSeparator separator = new JSeparator(0);
        this.grid.setConstraints(separator, constraints);
        this.add(separator);
        constraints.gridwidth = 1;
        ++constraints.gridy;
        JLabel label = new JLabel("successful", this.green, 2);
        this.grid.setConstraints(label, constraints);
        this.add(label);
        ++constraints.gridx;
        label = new JLabel("trying", this.yellow, 2);
        this.grid.setConstraints(label, constraints);
        this.add(label);
        constraints.gridx = 0;
        ++constraints.gridy;
        label = new JLabel("unknown", this.blue, 2);
        this.grid.setConstraints(label, constraints);
        this.add(label);
        ++constraints.gridx;
        label = new JLabel("failed", this.red, 2);
        this.grid.setConstraints(label, constraints);
        this.add(label);
        constraints.gridx = 0;
        constraints.gridwidth = 2;
        ++constraints.gridy;
        this.grid.setConstraints(endPanel, constraints);
        this.add(endPanel);
        retryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CommonAccess ca = CommonAccess.getCommonAccess();
                ca.getChecker().runChecks();
            }
        });
        this.revalidate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

