/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.Start;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.Task;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.swing.JOptionPane;

public class ConfigSwitchTask
implements Task {
    private String configFile;

    public void configure(Map params) throws ConfigurationException {
        this.configFile = (String)params.get("configFile");
        if (this.configFile == null) {
            throw new ConfigurationException("ConfigSwitchTask must have a configFile element");
        }
    }

    public void invoke() throws Exception {
        this.switchConfig(this.configFile);
    }

    public void switchConfig(String newConfigFile) throws IOException, ConfigurationException {
        if (!NetworkGateKeeper.accessAllowed() && (newConfigFile.startsWith("http:") || newConfigFile.startsWith("ftp:"))) {
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(), "This feature needs an Internet Connection. Please check your connection and restart GEE", "Warning", 2);
        } else {
            this.switchConfig(Start.getReader(newConfigFile));
        }
    }

    public void switchConfig(Reader newConfig) throws ConfigurationException {
        CommonAccess common = CommonAccess.getCommonAccess();
        common.getConfigure().load(newConfig);
        common.resetActivity();
    }

    public void destroy() {
    }
}

