/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.MultiSeismogramWindowDisplay;
import edu.sc.seis.fissuresUtil.display.RecordSectionDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.fissuresUtil.display.drawable.Event;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseForwarder;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseMotionForwarder;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.freq.NamedFilter;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.AllTasks;
import edu.sc.seis.gee.task.AmpSetterTask;
import edu.sc.seis.gee.task.DisplayMakerTask;
import edu.sc.seis.gee.task.FilterTarget;
import edu.sc.seis.gee.task.GlobalToolBar;
import edu.sc.seis.gee.task.PlaceholderImage;
import edu.sc.seis.gee.task.RecordSectionTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.TauPTask;
import edu.sc.seis.gee.task.TimeAmpLabelTask;
import edu.sc.seis.gee.task.TimeSetterTask;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import edu.sc.seis.gee.task.dataSetBrowser.SeismogramSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.SeismogramSelectionEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.apache.log4j.Category;

public class ColumnSeismogramTask
extends JPanel
implements Task,
FilterTarget {
    private int columnSeismogramTaskCount = 0;
    private LinkedList orderedSeis = new LinkedList();
    private boolean addDisplay = false;
    private DisplayMakerTask displayMaker;
    private TaskAction safeDisplayMakerTA;
    private TaskAction defaultDisplayMakerTA;
    private TimeSetterTask safeTimeSetter;
    private TaskAction ampSetter;
    private TaskAction timeSetter;
    private TaskAction rangeSelTA;
    private TaskAction customPickTA;
    private JScrollPane scrollPane = new JScrollPane();
    private boolean taupulate = false;
    protected Map params;
    protected SeismogramDisplay display;
    private TimeAmpLabelTask timeAmpLabelTask;
    private TaskAction taupTaskAction;
    private PlaceholderImage placeholder;
    private boolean careAboutLackOfEventForTime = true;
    private boolean careAboutLackOfEventForDisplay = true;
    private static Category logger = Category.getInstance((String)(class$edu$sc$seis$gee$task$ColumnSeismogramTask == null ? (class$edu$sc$seis$gee$task$ColumnSeismogramTask = ColumnSeismogramTask.class$("edu.sc.seis.gee.task.ColumnSeismogramTask")) : class$edu$sc$seis$gee$task$ColumnSeismogramTask).getName());
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram;
    static /* synthetic */ Class class$edu$sc$seis$fissuresUtil$display$drawable$Event;
    static /* synthetic */ Class class$edu$sc$seis$gee$task$ColumnSeismogramTask;

    public ColumnSeismogramTask() {
        this.setLayout(new BorderLayout());
        SeismogramDisplay.setMouseMotionForwarder((SDMouseMotionForwarder)GlobalToolBar.getMouseMotionForwarder());
        SeismogramDisplay.setMouseForwarder((SDMouseForwarder)GlobalToolBar.getMouseForwarder());
        this.timeAmpLabelTask = new TimeAmpLabelTask();
        ++this.columnSeismogramTaskCount;
    }

    public void configure(Map params) throws ConfigurationException {
        CommonAccess ca = CommonAccess.getCommonAccess();
        this.params = params;
        this.timeAmpLabelTask.configure(params);
        this.timeAmpLabelTask.invoke();
        if (params.containsKey("datasetbrowser")) {
            String browserId = (String)params.get("datasetbrowser");
            TaskAction browserAction = ca.getTaskAction(browserId);
            DataSetBrowser browser = (DataSetBrowser)browserAction.getTask();
            browser.addSeismogramSelectedListener(new SeismogramSelectedListener(){

                public void seismogramSelected(SeismogramSelectionEvent e) {
                    if (e.isSelected()) {
                        DataSetSeismogram seis = e.getSeismogram();
                        ColumnSeismogramTask.this.addSeismogram(seis);
                        TaskAction ta = AllTasks.getTaskAction(ColumnSeismogramTask.this);
                        try {
                            ta.checkDisplayLocation();
                        }
                        catch (ConfigurationException ex) {
                            // empty catch block
                        }
                    }
                }
            });
        }
        if (params.containsKey("rangeSelectionTask")) {
            this.rangeSelTA = ca.getTaskAction((String)params.get("rangeSelectionTask"));
        }
        if (params.containsKey("customPickTask")) {
            this.customPickTA = ca.getTaskAction((String)params.get("customPickTask"));
        }
        if (!params.containsKey("safeDisplayMaker")) {
            throw new ConfigurationException("Column Seismogram task requires a safeDisplayMaker");
        }
        String dmId = (String)params.get("safeDisplayMaker");
        this.safeDisplayMakerTA = ca.getTaskAction(dmId);
        if (params.containsKey("defaultDisplayMaker")) {
            dmId = (String)params.get("defaultDisplayMaker");
            this.defaultDisplayMakerTA = ca.getTaskAction(dmId);
            this.setDisplayMaker((DisplayMakerTask)this.defaultDisplayMakerTA.getTask());
        } else {
            this.setDisplayMaker((DisplayMakerTask)this.safeDisplayMakerTA.getTask());
        }
        if (!params.containsKey("safeTimeSetter")) {
            throw new ConfigurationException("Column Seismogram task requires a safeTimeConfig");
        }
        String tsId = (String)params.get("safeTimeSetter");
        this.safeTimeSetter = (TimeSetterTask)ca.getTaskAction(tsId).getTask();
        this.setTimeSetter(this.safeTimeSetter);
        if (params.containsKey("TauP")) {
            String taupID = (String)params.get("TauP");
            this.taupTaskAction = ca.getTaskAction(taupID);
        }
        if (params.containsKey("Placeholder")) {
            String placeholderID = (String)params.get("Placeholder");
            TaskAction placeholderTA = ca.getTaskAction(placeholderID);
            this.placeholder = (PlaceholderImage)placeholderTA.getTask();
        }
    }

    public void invoke() throws ConfigurationException, NoNetworkException {
        if (this.placeholder != null) {
            this.add(this.placeholder.generateImagePanel());
            this.placeholder = null;
        }
    }

    public void destroy() {
        if (this.defaultDisplayMakerTA != null) {
            this.defaultDisplayMakerTA.reset();
        }
        this.safeDisplayMakerTA.reset();
        this.timeAmpLabelTask.destroy();
        this.removeAllDisplays();
        --this.columnSeismogramTaskCount;
        if (this.columnSeismogramTaskCount == 0) {
            BasicSeismogramDisplay.getActiveFilters().clear();
        }
    }

    public void addSeismogram(LocalSeismogramImpl seis, DataSet ds) {
        this.addSeismogram((DataSetSeismogram)new MemoryDataSetSeismogram(seis, ds));
    }

    public void addSeismogram(DataSetSeismogram dss) {
        if (this.orderedSeis.contains(dss)) {
            this.orderedSeis.remove(dss);
        }
        this.orderedSeis.addLast(dss);
        this.makeSeismogramDisplayVisible();
        if ((this.careAboutLackOfEventForDisplay || this.careAboutLackOfEventForTime) && (this.displayMaker.needsEventInformation() || this.timeSetter != null && this.getTimeSetter().needsEventInformation()) && !this.hasDistance(dss)) {
            if (this.getDisplay().getSeismograms().length == 0) {
                this.setTimeSetter(this.safeTimeSetter);
                this.safeDisplayMakerTA.invoke(false);
            } else {
                int decision = JOptionPane.showConfirmDialog(this, "You are attempting to add a seismogram with no event information to a display that requires it.\nWould you like to switch to a display type that supports this?", "Adding seismogram with no event", 0, 3);
                if (decision == 0) {
                    if (this.displayMaker.needsEventInformation()) {
                        if (this.timeSetter != null && this.getTimeSetter().needsEventInformation()) {
                            this.setTimeSetter(this.safeTimeSetter);
                            this.safeDisplayMakerTA.invoke(false);
                        } else {
                            this.safeDisplayMakerTA.invoke(false);
                        }
                    } else {
                        this.setTimeSetter(this.safeTimeSetter);
                    }
                } else {
                    this.careAboutLackOfEventForDisplay = false;
                    this.careAboutLackOfEventForTime = false;
                }
            }
        }
        DataSetSeismogram[] seismos = new DataSetSeismogram[]{dss};
        this.getDisplay().add(seismos);
        if (this.ampSetter != null) {
            this.getAmpSetter().setAmp(this.getDisplay());
        }
        if (this.taupulate) {
            this.displayTravelTimes(this.getDisplay());
        }
    }

    public void removeSeismogram(DataSetSeismogram dss) {
        DataSetSeismogram[] seis = new DataSetSeismogram[]{dss};
        this.getDisplay().remove(seis);
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void checkTravelTimes() {
        if (this.taupulate) {
            this.displayTravelTimes(this.getDisplay());
        }
    }

    public void displayTravelTimes() {
        this.displayTravelTimes(this.getDisplay());
    }

    private void displayTravelTimes(SeismogramDisplay display) {
        if (this.taupTaskAction == null) {
            return;
        }
        boolean shownDialog = false;
        try {
            DrawableIterator it = display.iterator(class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram == null ? (class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram = ColumnSeismogramTask.class$("edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram")) : class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram);
            while (it.hasNext()) {
                DrawableSeismogram curSeis = (DrawableSeismogram)it.next();
                DataSetSeismogram curDSS = curSeis.getSeismogram();
                if (this.hasDistance(curDSS)) {
                    if (display instanceof MultiSeismogramWindowDisplay) {
                        curSeis.add((Drawable)new Event(((TauPTask)this.taupTaskAction.getTask()).getArrivals(curDSS), this.getEventTime(curDSS), curSeis), Color.RED);
                        continue;
                    }
                    curSeis.add((Drawable)new Event(((TauPTask)this.taupTaskAction.getTask()).getArrivals(curDSS), this.getEventTime(curDSS), curSeis));
                    continue;
                }
                if (shownDialog) continue;
                JOptionPane.showMessageDialog(this, "You are attempting to show travel times for a seismogram without enough information to calculate them.\nNo flags will be shown for seismograms without this information.", "Some seismograms have no distance", 1);
                shownDialog = true;
            }
            this.taupulate = true;
        }
        catch (ConfigurationException e) {
            GlobalExceptionHandler.handle((String)"Travel time calculator is not configured correctly.", (Throwable)e);
        }
    }

    private MicroSecondDate getEventTime(DataSetSeismogram seis) {
        DataSet ds = seis.getDataSet();
        EventAccessOperations eao = ds.getEvent();
        if (eao != null) {
            return new MicroSecondDate(EventUtil.extractOrigin((EventAccessOperations)eao).origin_time);
        }
        return null;
    }

    public void removeAllDisplays() {
        this.getDisplay().clear();
    }

    public void removeTravelTimes() {
        DrawableIterator it = this.getDisplay().iterator(class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram == null ? (class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram = ColumnSeismogramTask.class$("edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram")) : class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram);
        while (it.hasNext()) {
            DrawableSeismogram curSeis = (DrawableSeismogram)it.next();
            curSeis.clear(class$edu$sc$seis$fissuresUtil$display$drawable$Event == null ? ColumnSeismogramTask.class$("edu.sc.seis.fissuresUtil.display.drawable.Event") : class$edu$sc$seis$fissuresUtil$display$drawable$Event);
        }
        this.taupulate = false;
    }

    public void applyFilter(NamedFilter filter, boolean visible) {
        filter.setVisibility(visible);
        if (visible) {
            SeismogramDisplay.getActiveFilters().add(filter);
        } else {
            SeismogramDisplay.getActiveFilters().remove(filter);
        }
        DisplayUtils.applyFilter((NamedFilter)filter, (DrawableIterator)this.getDisplay().iterator(class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram == null ? (class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram = ColumnSeismogramTask.class$("edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram")) : class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram));
    }

    public void setOriginal(boolean visible) {
        SeismogramDisplay disp = this.getDisplay();
        if (disp != null) {
            DrawableIterator it = disp.iterator(class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram == null ? (class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram = ColumnSeismogramTask.class$("edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram")) : class$edu$sc$seis$fissuresUtil$display$drawable$DrawableSeismogram);
            while (it.hasNext()) {
                ((DrawableSeismogram)it.next()).setVisibility(visible);
            }
        }
    }

    public void refreshDisplays() {
    }

    public void clearSelections() {
        if (this.getDisplay() instanceof VerticalSeismogramDisplay) {
            ((VerticalSeismogramDisplay)this.getDisplay()).clearSelections();
        }
    }

    public void setDisplayMaker(DisplayMakerTask task) {
        if (this.careAboutLackOfEventForDisplay && this.displayMaker != null && task.needsEventInformation() && !this.allHaveDistances(this.display.getSeismograms())) {
            if (JOptionPane.showConfirmDialog(this, "You are attempting to switch to a display that requires event information with some seismograms that don't have event information.\nIf you click yes, some traces will not display.  Do you want to do this?", "Some seismograms won't display in this mode", 0, 3) == 1) {
                return;
            }
            this.careAboutLackOfEventForDisplay = false;
        }
        this.displayMaker = task;
        this.setDisplay();
    }

    public boolean allHaveDistances(DataSetSeismogram[] seismograms) {
        for (int i = 0; i < seismograms.length; ++i) {
            if (this.hasDistance(seismograms[i])) continue;
            return false;
        }
        return true;
    }

    public boolean hasDistance(DataSetSeismogram seismo) {
        return DisplayUtils.calculateDistance((DataSetSeismogram)seismo) != null;
    }

    public void setAmpSetter(AmpSetterTask task) {
        this.ampSetter = AllTasks.getTaskAction(task);
        task.setAmp(this.getDisplay());
    }

    public void setTimeSetter(TimeSetterTask task) {
        if (this.careAboutLackOfEventForTime && task.needsEventInformation() && !this.allHaveDistances(this.display.getSeismograms())) {
            if (JOptionPane.showConfirmDialog(this, "This mode requires event origin time, which is not available for some/all of your seismograms.\nThese seismograms will be aligned by their first data point.", "Some seismograms won't display in this mode", 2, 3) == 2) {
                return;
            }
            this.careAboutLackOfEventForTime = false;
        }
        this.timeSetter = AllTasks.getTaskAction(task);
        task.setTime(this.getDisplay());
    }

    protected void setDisplay() {
        SeismogramDisplay newDisplay = this.displayMaker.makeDisplay();
        if (this.timeSetter != null) {
            this.getTimeSetter().setTime(newDisplay);
        }
        if (this.display != null && this.display.getSeismograms().length > 0) {
            newDisplay.setTimeConfig(this.display.getTimeConfig());
            newDisplay.setAmpConfig(this.display.getAmpConfig());
            DataSetSeismogram[] seis = this.display.getSeismograms();
            ListIterator it = this.orderedSeis.listIterator();
            while (it.hasNext()) {
                DataSetSeismogram cur = (DataSetSeismogram)it.next();
                boolean found = false;
                for (int i = 0; i < seis.length; ++i) {
                    if (!cur.equals((Object)seis[i])) continue;
                    found = true;
                }
                if (found) continue;
                it.remove();
            }
            DataSetSeismogram[] orderedExistantSeis = new DataSetSeismogram[this.orderedSeis.size()];
            this.orderedSeis.toArray(orderedExistantSeis);
            newDisplay.add(orderedExistantSeis);
            if (this.taupulate) {
                this.displayTravelTimes(newDisplay);
            }
            this.display.clear();
        }
        if (this.ampSetter != null) {
            this.getAmpSetter().setAmp(newDisplay);
        }
        if (this.addDisplay) {
            this.removeAll();
            this.add(this.scrollPane);
            if (this.displayMaker instanceof RecordSectionTask) {
                this.add((Component)((RecordSectionTask)this.displayMaker).getSliderPanel(), "East");
            }
        }
        JViewport scrollViewport = this.scrollPane.getViewport();
        scrollViewport.removeAll();
        scrollViewport.add((Component)newDisplay);
        this.display = newDisplay;
        boolean recSecDisplay = this.display instanceof RecordSectionDisplay;
        if (this.rangeSelTA != null) {
            this.rangeSelTA.setEnabled(!recSecDisplay);
        }
        if (this.customPickTA != null) {
            this.customPickTA.setEnabled(!recSecDisplay);
        }
        this.revalidate();
    }

    public SeismogramDisplay getDisplay() {
        if (this.display == null) {
            this.setDisplay();
        }
        return this.display;
    }

    public void makeSeismogramDisplayVisible() {
        if (!this.addDisplay) {
            this.getDisplay();
            this.addDisplay = true;
            this.removeAll();
            this.add(this.scrollPane);
            if (this.displayMaker instanceof RecordSectionTask) {
                this.add((Component)((RecordSectionTask)this.displayMaker).getSliderPanel(), "East");
            }
            this.revalidate();
        }
    }

    private AmpSetterTask getAmpSetter() {
        try {
            return (AmpSetterTask)this.ampSetter.getTask();
        }
        catch (ConfigurationException e) {
            GlobalExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    private TimeSetterTask getTimeSetter() {
        try {
            return (TimeSetterTask)this.timeSetter.getTask();
        }
        catch (ConfigurationException e) {
            GlobalExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

