/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfEvent.NoPreferredOrigin;
import edu.iris.Fissures.IfNetwork.NetworkDCOperations;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.BulletproofVestFactory;
import edu.sc.seis.fissuresUtil.cache.FilterNetworkDC;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkDC;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.namingService.FissuresNamingService;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.NoCorbaException;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.LoadSeismogram;
import edu.sc.seis.gee.task.ShowEventsTask;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Category;

public class ChannelChooserTask
implements GUITask {
    private Pattern[] patterns = new Pattern[0];
    private String[] autoSelectBand = new String[]{"B"};
    private int orientation = 0;
    Map params = new HashMap();
    JPanel panel;
    boolean showSites = false;
    boolean showNetworks = true;
    boolean showCodes = false;
    protected boolean guiInitialized = false;
    private ChannelChooserCubbyHole channelChooserCubbyHole = null;
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$gee$task$ChannelChooserTask == null ? (class$edu$sc$seis$gee$task$ChannelChooserTask = ChannelChooserTask.class$("edu.sc.seis.gee.task.ChannelChooserTask")) : class$edu$sc$seis$gee$task$ChannelChooserTask).getName());
    private TaskAction processDisplayAction;
    static /* synthetic */ Class class$edu$sc$seis$gee$task$ChannelChooserTask;

    public JComponent getMoreOptionsGUI() {
        return null;
    }

    public boolean hasMoreOptions() {
        return false;
    }

    public void invoke() {
    }

    public JComponent getGUI() throws Exception {
        if (!this.guiInitialized) {
            this.panel = new JPanel();
            this.guiInitialized = true;
            this.panel.setLayout(new BorderLayout());
            this.panel.add((Component)this.getChannelChooser());
        }
        return this.panel;
    }

    public void configure(Map map) throws ConfigurationException {
        this.params = map;
        if (map.containsKey("showSites") && ((String)map.get("showSites")).equalsIgnoreCase("true")) {
            this.showSites = true;
        }
        if (map.containsKey("showNetworks") && ((String)map.get("showNetworks")).equalsIgnoreCase("false")) {
            this.showNetworks = false;
        }
        if (map.containsKey("showCodes") && ((String)map.get("showCodes")).equalsIgnoreCase("true")) {
            this.showCodes = true;
        }
        if (map.containsKey("eventSelector")) {
            TaskAction taskAction = CommonAccess.getCommonAccess().getTaskAction((String)map.get("eventSelector"));
            final ShowEventsTask showEventsTask = (ShowEventsTask)taskAction.getTask();
            final ListSelectionModel selectionModel = showEventsTask.getEventSelectionModel();
            selectionModel.addListSelectionListener(new ListSelectionListener(){

                public void valueChanged(ListSelectionEvent e) {
                    ArrayList<EventAccessOperations> selectedEvents = new ArrayList<EventAccessOperations>();
                    EventAccessOperations[] allEvents = showEventsTask.getEventTableModel().getAllEvents();
                    for (int i = 0; i < allEvents.length; ++i) {
                        if (!selectionModel.isSelectedIndex(i)) continue;
                        selectedEvents.add(allEvents[i]);
                    }
                    if (selectedEvents.size() > 0) {
                        try {
                            EventAccessOperations event = (EventAccessOperations)selectedEvents.get(0);
                            ChannelChooserTask.this.getChannelChooser().setAvailbleDataOrigin(event.get_preferred_origin());
                        }
                        catch (NoPreferredOrigin ex) {
                        }
                        catch (NoNetworkException ex) {
                            GlobalExceptionHandler.handle((Throwable)ex);
                        }
                    }
                }
            });
        }
        if (map.containsKey("filterStations")) {
            String filterURL = (String)map.get("filterStations");
            try {
                this.patterns = FilterNetworkDC.readPattern((String)filterURL);
            }
            catch (MalformedURLException e) {
                throw new ConfigurationException("The url for the file with a list of stations to filter, " + filterURL + ", is malformed", e);
            }
            catch (IOException e) {
                GlobalExceptionHandler.handle((String)"Trouble reading list of patterns", (Throwable)e);
            }
        }
        if (map.containsKey("orientation")) {
            String orient = (String)map.get("orientation");
            if (orient.equals("INDIVIDUAL_CHANNELS")) {
                this.orientation = 3;
            } else if (orient.equals("THREE_COMPONENT")) {
                this.orientation = 4;
            } else if (orient.equals("VERTICAL_ONLY")) {
                this.orientation = 1;
            } else if (orient.equals("HORIZONTAL_ONLY")) {
                this.orientation = 2;
            } else {
                throw new ConfigurationException("That orientation string isn't supported.  As of now, INDIVIDUAL_CHANNELS is the only one.  Add more in ChannelChooserTask if you need it.");
            }
        }
        if (map.containsKey("bands")) {
            ArrayList<String> bands = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer((String)map.get("bands"), ",");
            while (tokenizer.hasMoreTokens()) {
                bands.add(tokenizer.nextToken());
            }
            this.autoSelectBand = bands.toArray(new String[0]);
        }
        this.initializeChannelChooser();
    }

    public void destroy() {
    }

    protected ProxyNetworkDC[] getConfiguredNetworkDCs() throws ConfigurationException {
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        FissuresNamingService fissuresNamingService = commonAccess.getFissuresNamingService();
        Set keySet = this.params.keySet();
        Iterator iter = keySet.iterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith("serverDNS")) continue;
            String dnsValue = (String)this.params.get(key);
            String nameValue = (String)this.params.get("serverName" + key.substring(9));
            logger.debug((Object)(key + " " + key.substring(9) + " " + nameValue));
            if (dnsValue == null && dnsValue.length() == 0 && nameValue == null && nameValue.length() == 0) {
                throw new ConfigurationException("Bad configuration for " + key);
            }
            try {
                ProxyNetworkDC dc = BulletproofVestFactory.vestNetworkDC((String)dnsValue, (String)nameValue, (FissuresNamingService)fissuresNamingService);
                if (this.patterns.length > 0) {
                    arrayList.add(new FilterNetworkDC((NetworkDCOperations)dc, this.patterns));
                    continue;
                }
                arrayList.add(dc);
            }
            catch (Exception e) {
                throw new ConfigurationException("Unable to resolve NetworkDC:" + dnsValue + " " + nameValue + " FVer=" + "1.0", e);
            }
        }
        ProxyNetworkDC[] rtnValues = new ProxyNetworkDC[arrayList.size()];
        rtnValues = arrayList.toArray(rtnValues);
        return rtnValues;
    }

    public String[] getConfiguredNetworks() {
        Set keySet = this.params.keySet();
        Iterator iter = keySet.iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.startsWith("network")) continue;
            String value = (String)this.params.get(key);
            arrayList.add(value);
        }
        String[] rtnValues = new String[arrayList.size()];
        rtnValues = arrayList.toArray(rtnValues);
        return rtnValues;
    }

    public ChannelChooser getChannelChooser() throws NoNetworkException {
        if (!NetworkGateKeeper.corbaAccessAllowed()) {
            throw new NoCorbaException();
        }
        if (this.channelChooserCubbyHole == null) {
            try {
                this.initializeChannelChooser();
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((String)"Problem initializing the channel chooser", (Throwable)e);
            }
        }
        return this.channelChooserCubbyHole.get();
    }

    protected void initializeChannelChooser() throws ConfigurationException {
        if (this.channelChooserCubbyHole == null) {
            this.channelChooserCubbyHole = new ChannelChooserCubbyHole();
            ChannelChooserInitializer cci = new ChannelChooserInitializer();
            JobTracker.getTracker().add((Job)cci);
            if (this.processDisplayAction != null) {
                this.processDisplayAction.checkDisplayLocation();
            }
            cci.run();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ChannelChooserInitializer
    extends AbstractJob {
        public ChannelChooserInitializer() {
            super("Channel Chooser");
        }

        public void runJob() {
            if (!NetworkGateKeeper.corbaAccessAllowed()) {
                this.setFinished();
                return;
            }
            ProxyNetworkDC[] netDC = null;
            try {
                this.setStatus("Getting Networks");
                netDC = ChannelChooserTask.this.getConfiguredNetworkDCs();
            }
            catch (ConfigurationException e) {
                // empty catch block
            }
            String[] band = new String[]{"B", "L", "S", "E"};
            this.setStatus("Creating chooser");
            ChannelChooser myChannelChooser = new ChannelChooser(netDC, ChannelChooserTask.this.showSites, ChannelChooserTask.this.showNetworks, ChannelChooserTask.this.getConfiguredNetworks(), band, ChannelChooserTask.this.autoSelectBand, ChannelChooser.DEFAULT_SELECTABLE_ORIENTATIONS, ChannelChooserTask.this.orientation);
            if (ChannelChooserTask.this.showCodes) {
                myChannelChooser.setShowCodes(ChannelChooserTask.this.showCodes);
            }
            String dcTaskId = (String)ChannelChooserTask.this.params.get("loadSeismogramTask");
            this.setStatus("Getting Seismogram Loaders");
            if (dcTaskId != null) {
                TaskAction taskAction = CommonAccess.getCommonAccess().getTaskAction(dcTaskId);
                try {
                    LoadSeismogram loadSeismogramTask = (LoadSeismogram)taskAction.getTask();
                    myChannelChooser.setSeismogramDC(loadSeismogramTask.getDataCenterRouter());
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle((String)("Unable to get seismogram DC from task " + dcTaskId), (Throwable)e);
                }
            }
            ChannelChooserTask.this.channelChooserCubbyHole.put(myChannelChooser);
            this.setFinished();
        }
    }

    private class ChannelChooserCubbyHole {
        private ChannelChooser contents;
        private boolean available = false;

        private ChannelChooserCubbyHole() {
        }

        public synchronized ChannelChooser get() {
            if (!this.available) {
                logger.debug((Object)"Waiting to get channel chooser from CubbyHole");
            }
            while (!this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.notifyAll();
            return this.contents;
        }

        public synchronized void put(ChannelChooser value) {
            while (this.available) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.contents = value;
            this.available = true;
            this.notifyAll();
        }
    }
}

