/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.FileNameFilter;
import edu.sc.seis.fissuresUtil.display.TextTable;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.StdAuxillaryDataNames;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameManager;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.DataSetCrawler;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetBrowser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.filechooser.FileFilter;

public class ApprovalExportTask
extends DataSetCrawler
implements Task {
    private static final String[] template = new String[]{"Event", "Station", "Approved"};
    private int seisCount = 0;
    private CrawlAction currentCrawlAction = new TextTableCrawlAction();
    private TaskAction dsbAction;
    private DataSetBrowser dataSetBrowser;
    private TextTable textTable = new TextTable(template.length, true);
    private boolean tabDelimited = true;
    private boolean copyScript = false;
    private ApprovalOptionsDialogue optionsDialogue = new ApprovalOptionsDialogue();

    public void configure(Map params) throws ConfigurationException {
        if (!params.containsKey("DataSetBrowser")) {
            throw new ConfigurationException("ApprovalExportTask must have a DataSetBrowser associated with it");
        }
        String displayId = (String)params.get("DataSetBrowser");
        this.dsbAction = CommonAccess.getCommonAccess().getTaskAction(displayId);
        this.initCrawler(this.dsbAction);
        this.dataSetBrowser = (DataSetBrowser)this.dsbAction.getTask();
        if (params.containsKey("PromptIfNoOpenDataSets")) {
            String promptString = (String)params.get("PromptIfNoOpenDataSets");
            this.setPromptIfNoOpenDataSets(Boolean.valueOf(promptString));
        }
    }

    public void invoke() throws Exception {
        this.currentCrawlAction = new InitialCrawlAction();
        boolean doneSomething = this.crawlDataSets();
        if (this.seisCount > 0) {
            this.optionsDialogue.setVisible(true);
        } else if (doneSomething) {
            JOptionPane.showMessageDialog(FrameManager.getManager().getCurrentFrame(), "No quality control data were found in current dataset.", "No quality control data", 1);
        }
    }

    public void destroy() {
    }

    public void crawlAction(DataSetSeismogram seis) {
        this.currentCrawlAction.doCrawlAction(seis);
    }

    public void createFileGUI() throws ConfigurationException {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(2);
        String defName = null;
        String[] extensions = new String[1];
        if (this.copyScript) {
            extensions[0] = "sh";
            defName = "qc_copy.sh";
        } else {
            extensions[0] = "txt";
            defName = "quality_control.txt";
        }
        fc.setSelectedFile(new File(defName));
        fc.setFileFilter((FileFilter)new FileNameFilter(extensions));
        fc.setDialogTitle("Save Quality Control Data");
        int returnVal = fc.showSaveDialog(FrameManager.getManager().getCurrentFrame());
        if (returnVal == 0) {
            ApprovalSaver saver;
            File file = fc.getSelectedFile();
            if (this.copyScript) {
                this.createCopyScript();
                saver = new ApprovalSaver(this.textTable.toString("\t"), file);
            } else {
                this.createTextTable();
                saver = this.tabDelimited ? new ApprovalSaver(this.textTable.toString("\t"), file) : new ApprovalSaver(this.textTable.toString(), file);
            }
            JobTracker.getTracker().add((Job)saver);
            WorkerThreadPool.getDefaultPool().invokeLater((Runnable)((Object)saver));
        }
    }

    private void createTextTable() {
        this.textTable = new TextTable(template.length, true);
        this.textTable.addRow(template, true);
        this.currentCrawlAction = new TextTableCrawlAction();
        this.crawlDataSets();
    }

    private void createCopyScript() {
        this.textTable = new TextTable(1, false);
        this.textTable.addRow("#!/bin/sh");
        this.currentCrawlAction = new CopyScriptCrawlAction();
        this.crawlDataSets();
    }

    class ApprovalSaver
    extends AbstractJob {
        File file;
        String data;

        ApprovalSaver(String data, File file) {
            super("Save quality control data");
            this.file = file;
            this.data = data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void runJob() {
            block11: {
                FileWriter writer;
                block10: {
                    writer = null;
                    writer = new FileWriter(this.file);
                    writer.write(this.data);
                    Object var4_2 = null;
                    if (writer == null) break block10;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        GlobalExceptionHandler.handle((String)"unable to close the file.", (Throwable)e2);
                    }
                }
                this.setFinished();
                {
                    break block11;
                    catch (Throwable e) {
                        GlobalExceptionHandler.handle((String)"problem saving quality control data.", (Throwable)e);
                        Object var4_3 = null;
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException e2) {
                                GlobalExceptionHandler.handle((String)"unable to close the file.", (Throwable)e2);
                            }
                        }
                        this.setFinished();
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            GlobalExceptionHandler.handle((String)"unable to close the file.", (Throwable)e2);
                        }
                    }
                    this.setFinished();
                    throw throwable;
                }
            }
        }
    }

    private class ApprovalOptionsDialogue
    extends JFrame {
        private JPanel radioButtonPanel = new JPanel();
        private JPanel controlButtonPanel = new JPanel();
        private JRadioButton tabDelimButton = new JRadioButton("Tab Delimited");
        private JRadioButton spaceFilledButton = new JRadioButton("Formatted Table");
        private JRadioButton copyScriptButton = new JRadioButton("UNIX Copy Script");
        private ButtonGroup buttonGroup = new ButtonGroup();
        private Border groupBorder = BorderFactory.createTitledBorder("Text Output");
        private JButton okButton = new JButton("OK");
        private JButton cancelButton = new JButton("Cancel");

        public ApprovalOptionsDialogue() {
            super("Set Text Formatting");
            this.getContentPane().setLayout(new BorderLayout());
            this.buttonGroup.add(this.tabDelimButton);
            this.buttonGroup.add(this.spaceFilledButton);
            this.buttonGroup.add(this.copyScriptButton);
            this.radioButtonPanel.setBorder(this.groupBorder);
            this.radioButtonPanel.add(this.tabDelimButton);
            this.radioButtonPanel.add(this.spaceFilledButton);
            this.radioButtonPanel.add(this.copyScriptButton);
            this.getContentPane().add((Component)this.radioButtonPanel, "North");
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    this.doOKAction();
                }
            });
            this.cancelButton.addActionListener(new ActionListener(this){
                private final /* synthetic */ ApprovalOptionsDialogue this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ApprovalOptionsDialogue.access$600(this.this$1);
                }
            });
            this.controlButtonPanel.add(this.okButton);
            this.controlButtonPanel.add(this.cancelButton);
            this.tabDelimButton.setSelected(true);
            this.okButton.setSelected(true);
            this.getContentPane().add((Component)this.radioButtonPanel, "North");
            this.getContentPane().add((Component)this.controlButtonPanel, "South");
            this.pack();
        }

        private void doOKAction() {
            try {
                if (this.tabDelimButton.isSelected()) {
                    System.out.println("tabDelimButton.isSelected()");
                    ApprovalExportTask.this.tabDelimited = true;
                    ApprovalExportTask.this.copyScript = false;
                } else if (this.spaceFilledButton.isSelected()) {
                    System.out.println("spaceFilledButton.isSelected()");
                    ApprovalExportTask.this.tabDelimited = false;
                    ApprovalExportTask.this.copyScript = false;
                } else {
                    System.out.println("else");
                    ApprovalExportTask.this.tabDelimited = false;
                    ApprovalExportTask.this.copyScript = true;
                }
                this.setVisible(false);
                ApprovalExportTask.this.createFileGUI();
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
        }

        private void doCancelAction() {
            this.setVisible(false);
        }

        public void setVisible(boolean b) {
            this.setLocationRelativeTo(FrameManager.getManager().getCurrentMainFrame());
            super.setVisible(b);
        }

        static /* synthetic */ void access$600(ApprovalOptionsDialogue x0) {
            x0.doCancelAction();
        }
    }

    private class CopyScriptCrawlAction
    implements CrawlAction {
        File previousDirectory;

        private CopyScriptCrawlAction() {
        }

        public void doCrawlAction(DataSetSeismogram seis) {
            URLDataSetSeismogram urlDSS = (URLDataSetSeismogram)seis;
            URL[] urls = urlDSS.getURLs();
            String approved = (String)seis.getAuxillaryData((Object)StdAuxillaryDataNames.APPROVED);
            for (int i = 0; i < urls.length; ++i) {
                File seisFile = new File(urls[i].getFile());
                File currentDirectory = new File(urls[i].getFile()).getParentFile();
                if (!currentDirectory.equals(this.previousDirectory)) {
                    ApprovalExportTask.this.textTable.addRow("cd " + currentDirectory.getParentFile());
                    ApprovalExportTask.this.textTable.addRow("mkdir -p good/" + currentDirectory.getName());
                    ApprovalExportTask.this.textTable.addRow("mkdir -p bad/" + currentDirectory.getName());
                    this.previousDirectory = currentDirectory;
                }
                if (Boolean.valueOf(approved).booleanValue()) {
                    ApprovalExportTask.this.textTable.addRow("cp " + seisFile + " good/" + currentDirectory.getName() + "/" + seisFile.getName());
                    continue;
                }
                ApprovalExportTask.this.textTable.addRow("cp " + seisFile + " bad/" + currentDirectory.getName() + "/" + seisFile.getName());
            }
        }
    }

    private class TextTableCrawlAction
    implements CrawlAction {
        private TextTableCrawlAction() {
        }

        public void doCrawlAction(DataSetSeismogram seis) {
            EventAccessOperations event = seis.getDataSet().getEvent();
            ChannelId chanId = seis.getRequestFilter().channel_id;
            String approved = (String)seis.getAuxillaryData((Object)StdAuxillaryDataNames.APPROVED);
            if (approved != null) {
                ApprovalExportTask.this.textTable.addRow(new String[]{EventUtil.getEventInfo((EventAccessOperations)event), ChannelIdUtil.toString((ChannelId)chanId), approved});
            }
        }
    }

    private class InitialCrawlAction
    implements CrawlAction {
        private InitialCrawlAction() {
        }

        public void doCrawlAction(DataSetSeismogram seis) {
            EventAccessOperations event = seis.getDataSet().getEvent();
            ChannelId chanId = seis.getRequestFilter().channel_id;
            String approved = (String)seis.getAuxillaryData((Object)StdAuxillaryDataNames.APPROVED);
            if (approved != null) {
                ApprovalExportTask.this.seisCount++;
            }
        }
    }

    private static interface CrawlAction {
        public void doCrawlAction(DataSetSeismogram var1);
    }
}

