/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.organizer;

import edu.iris.Fissures.AuditInfo;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.MemoryDataSet;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.organizer.DataSetChangeEvent;
import edu.sc.seis.gee.organizer.DataSetChangeListener;
import edu.sc.seis.gee.organizer.Organizer;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Category;

public class TopLevelOrganizer
implements Organizer {
    protected EventListenerList listenerList = new EventListenerList();
    CommonAccess commonAccess = CommonAccess.getCommonAccess();
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$gee$organizer$TopLevelOrganizer == null ? (class$edu$sc$seis$gee$organizer$TopLevelOrganizer = TopLevelOrganizer.class$("edu.sc.seis.gee.organizer.TopLevelOrganizer")) : class$edu$sc$seis$gee$organizer$TopLevelOrganizer).getName());
    static /* synthetic */ Class class$edu$sc$seis$gee$organizer$DataSetChangeListener;
    static /* synthetic */ Class class$edu$sc$seis$gee$organizer$TopLevelOrganizer;

    public DataSet getNoEarthquakeDataSet() {
        DataSet ds = this.commonAccess.getDataSetRoot();
        DataSet noEQDS = ds.getDataSet("No Earthquake");
        if (noEQDS == null) {
            noEQDS = new MemoryDataSet("NO_EQ", "No Earthquake", System.getProperty("user.name"), new AuditInfo[0]);
            this.addDataSet(noEQDS);
        }
        return noEQDS;
    }

    public void addSeismogram(DataSetSeismogram seis, AuditInfo[] audit) {
        DataSet noEQDS = this.getNoEarthquakeDataSet();
        seis.setDataSet(noEQDS);
        noEQDS.addDataSetSeismogram(seis, audit);
        this.fireDataSetChanged(noEQDS);
    }

    public void addSeismogram(DataSetSeismogram seis, EventAccessOperations event, AuditInfo[] audit) {
        this.addSeismogram(seis, audit);
        DataSet ds = this.getNoEarthquakeDataSet();
        ds.addParameter("edu.sc.seis.fissuresUtil.xml#EVENT", (Object)event, audit);
    }

    public void addSeismogram(DataSetSeismogram seis, DataSet dataSet, AuditInfo[] audit) {
        dataSet.addDataSetSeismogram(seis, audit);
        this.fireDataSetChanged(dataSet);
    }

    public void addChannel(Channel chan, AuditInfo[] audit) {
        DataSet noEQDS = this.getNoEarthquakeDataSet();
        String channelParamName = "edu.sc.seis.fissuresUtil.xml#CHANNEL_" + ChannelIdUtil.toString((ChannelId)chan.get_id());
        if (chan != null && noEQDS.getParameter(channelParamName) == null) {
            noEQDS.addParameter(channelParamName, (Object)chan, audit);
        }
    }

    public void addChannel(Channel chan, EventAccessOperations event, AuditInfo[] audit) {
        this.addChannel(chan, audit);
    }

    public void addDataSet(DataSet dataset, AuditInfo[] audit) {
        DataSet ds = this.commonAccess.getDataSetRoot();
        logger.debug((Object)("Before Dataset " + dataset.getName() + " added." + ds.getDataSetNames().length));
        ds.addDataSet(dataset, audit);
        logger.debug((Object)("Dataset " + dataset.getName() + " added." + ds.getDataSetNames().length));
        this.fireDataSetChanged(ds);
    }

    public void addDataSet(DataSet dataSet) {
        this.addDataSet(dataSet, new AuditInfo[0]);
    }

    public void addDataSetChangeListener(DataSetChangeListener l) {
        this.listenerList.add(class$edu$sc$seis$gee$organizer$DataSetChangeListener == null ? (class$edu$sc$seis$gee$organizer$DataSetChangeListener = TopLevelOrganizer.class$("edu.sc.seis.gee.organizer.DataSetChangeListener")) : class$edu$sc$seis$gee$organizer$DataSetChangeListener, l);
    }

    public void removeDataSetChangeListener(DataSetChangeListener l) {
        this.listenerList.remove(class$edu$sc$seis$gee$organizer$DataSetChangeListener == null ? (class$edu$sc$seis$gee$organizer$DataSetChangeListener = TopLevelOrganizer.class$("edu.sc.seis.gee.organizer.DataSetChangeListener")) : class$edu$sc$seis$gee$organizer$DataSetChangeListener, l);
    }

    protected void fireDataSetChanged(DataSet ds) {
        DataSetChangeEvent changeEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$sc$seis$gee$organizer$DataSetChangeListener == null ? TopLevelOrganizer.class$("edu.sc.seis.gee.organizer.DataSetChangeListener") : class$edu$sc$seis$gee$organizer$DataSetChangeListener)) continue;
            if (changeEvent == null) {
                changeEvent = new DataSetChangeEvent(this, ds);
            }
            ((DataSetChangeListener)listeners[i + 1]).datasetChanged(changeEvent);
        }
    }

    protected void fireDataSetAdded(DataSet ds) {
        DataSetChangeEvent changeEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$sc$seis$gee$organizer$DataSetChangeListener == null ? TopLevelOrganizer.class$("edu.sc.seis.gee.organizer.DataSetChangeListener") : class$edu$sc$seis$gee$organizer$DataSetChangeListener)) continue;
            if (changeEvent == null) {
                changeEvent = new DataSetChangeEvent(this, ds);
            }
            ((DataSetChangeListener)listeners[i + 1]).datasetAdded(changeEvent);
        }
    }

    protected void fireDataSetRemoved(DataSet ds) {
        DataSetChangeEvent changeEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$edu$sc$seis$gee$organizer$DataSetChangeListener == null ? TopLevelOrganizer.class$("edu.sc.seis.gee.organizer.DataSetChangeListener") : class$edu$sc$seis$gee$organizer$DataSetChangeListener)) continue;
            if (changeEvent == null) {
                changeEvent = new DataSetChangeEvent(this, ds);
            }
            ((DataSetChangeListener)listeners[i + 1]).datasetRemoved(changeEvent);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

