/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.configurator;

import edu.sc.seis.gee.configurator.AbstractHandler;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.DefaultParamNames;
import edu.sc.seis.gee.configurator.TaskConfigHandler;
import edu.sc.seis.gee.configurator.ToolBarHandler;
import edu.sc.seis.gee.task.AllTasks;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.XMLReader;

public class TaskHandler
extends AbstractHandler
implements DefaultParamNames {
    String id = "";
    String name = "";
    String classname = "";
    String iconName = "";
    HashMap configParam = new HashMap();
    ToolBarHandler toolbar;
    boolean toggle = false;
    boolean toggleSet = false;
    String tooltip = "";
    Task task = null;
    static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$gee$configurator$TaskHandler == null ? (class$edu$sc$seis$gee$configurator$TaskHandler = TaskHandler.class$("edu.sc.seis.gee.configurator.TaskHandler")) : class$edu$sc$seis$gee$configurator$TaskHandler));
    static /* synthetic */ Class class$edu$sc$seis$gee$configurator$TaskHandler;

    public TaskHandler(XMLReader parser, AbstractHandler parent) {
        super(parser, parent);
        this.configParam.put("gee.task.displayLocation", "frame");
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (localName.equals("id")) {
            this.parser.setContentHandler(new IdHandler(this.parser, this));
        } else if (localName.equals("class")) {
            this.parser.setContentHandler(new ClassNameHandler(this.parser, this));
        } else if (localName.equals("name")) {
            this.parser.setContentHandler(new NameHandler(this.parser, this));
        } else if (localName.equals("taskconfig")) {
            this.parser.setContentHandler(new TaskConfigHandler(this.parser, this, this.classname, this.getTaskInstance()));
        } else if (localName.equals("tooltip")) {
            this.parser.setContentHandler(new ToolTipHandler(this.parser, this));
        } else if (localName.equals("toggle")) {
            this.toggle = true;
            this.parser.setContentHandler(new ToggleHandler(this.parser, this));
        } else if (localName.equals("icon")) {
            this.parser.setContentHandler(new IconHandler(this.parser, this));
        } else if (localName.equals("toolbar")) {
            this.toolbar = new ToolBarHandler(this.parser, this);
            this.parser.setContentHandler(this.toolbar);
        } else {
            logger.warn((Object)("TaskHandler unknown tag: " + localName));
        }
    }

    protected void finished() {
        this.configParam.put("gee.task.name", this.name);
        this.configParam.put("gee.task.id", this.id);
        this.configParam.put("gee.task.classname", this.classname);
        if (this.tooltip.length() != 0) {
            this.configParam.put("gee.task.tooltip", this.makeHTML(this.tooltip, 50));
        }
    }

    public TaskAction getTaskAction() throws ConfigurationException {
        if (this.iconName != null && !this.iconName.equals("")) {
            return new TaskAction(this.id, this.classname, this.name, this.configParam, this.toolbar, this.toggle, this.iconName);
        }
        return new TaskAction(this.id, this.classname, this.name, this.configParam, this.toolbar, this.toggle);
    }

    public void addConfigParam(String configName, Object value) {
        this.configParam.put(configName, value);
    }

    String makeHTML(String text, int maxCol) {
        int nextSpace;
        String html = "<html><body>";
        int index = 0;
        while (index < text.length() && (nextSpace = text.indexOf(32, index + maxCol)) != -1) {
            html = html + text.substring(index, nextSpace);
            html = html + "<p>";
            index = nextSpace + 1;
        }
        html = html + text.substring(index);
        html = html + "</body></html>";
        return html;
    }

    void setTaskInstance(Task task) {
        this.task = task;
        this.addConfigParam("gee.task.task", this.getTaskInstance());
    }

    Task getTaskInstance() {
        if (this.task == null) {
            this.task = AllTasks.getTask(this.id);
        }
        return this.task;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class IconHandler
    extends AbstractHandler {
        IconHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            TaskHandler.this.iconName = TaskHandler.this.iconName + new String(ch, start, length);
        }
    }

    class ToggleHandler
    extends AbstractHandler {
        ToggleHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }
    }

    class ClassNameHandler
    extends AbstractHandler {
        ClassNameHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            TaskHandler.this.classname = TaskHandler.this.classname + new String(ch, start, length);
        }
    }

    class ToolTipHandler
    extends AbstractHandler {
        ToolTipHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            TaskHandler.this.tooltip = TaskHandler.this.tooltip + new String(ch, start, length);
        }
    }

    class NameHandler
    extends AbstractHandler {
        NameHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            TaskHandler.this.name = TaskHandler.this.name + new String(ch, start, length);
        }
    }

    class IdHandler
    extends AbstractHandler {
        IdHandler(XMLReader parser, AbstractHandler parent) {
            super(parser, parent);
        }

        public void characters(char[] ch, int start, int length) {
            TaskHandler.this.id = TaskHandler.this.id + new String(ch, start, length);
        }
    }
}

