/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.configurator;

import edu.sc.seis.fissuresUtil.xml.XMLDataSet;
import edu.sc.seis.fissuresUtil.xml.XMLUtil;
import edu.sc.seis.gee.Start;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Configuration {
    private String name;
    private String description;
    private String image;
    private String[] configs;
    private String[] names;

    public Configuration(Element configEl) {
        this(Configuration.extractLocations(configEl), Configuration.extractLocationNames(configEl), Configuration.extractName(configEl), Configuration.extractDescription(configEl), Configuration.extractImage(configEl));
    }

    public Configuration(String[] locations, String[] locationNames, String name, String description, String image) {
        this.name = name;
        this.description = description;
        this.image = image;
        this.configs = locations;
        this.names = locationNames;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public int getNumConfigs() {
        return this.configs.length;
    }

    public String getName(int i) {
        return this.names[i];
    }

    public String getConfig(int i) {
        return this.configs[i];
    }

    public String getImage() {
        return this.image;
    }

    public static Configuration[] loadConfigs(String configsFileLoc) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilder docBuilder = XMLDataSet.getDocumentBuilder();
        Document doc = docBuilder.parse(new InputSource(Start.getReader(configsFileLoc)));
        Element docElement = doc.getDocumentElement();
        NodeList configEls = docElement.getElementsByTagName("group");
        Configuration[] configs = new Configuration[configEls.getLength()];
        for (int i = 0; i < configEls.getLength(); ++i) {
            configs[i] = new Configuration((Element)configEls.item(i));
        }
        return configs;
    }

    private static String extractDescription(Element configEl) {
        return Configuration.getTextInElement(configEl, "description");
    }

    private static String extractName(Element configEl) {
        return Configuration.getTextInElement(configEl, "name");
    }

    private static String[] extractLocations(Element configEl) {
        return Configuration.extractFromConfigs(configEl, "location");
    }

    private static String[] extractLocationNames(Element configEl) {
        return Configuration.extractFromConfigs(configEl, "name");
    }

    private static String[] extractFromConfigs(Element mainEl, String tagName) {
        NodeList nl = mainEl.getElementsByTagName("config");
        String[] strings = new String[nl.getLength()];
        for (int i = 0; i < nl.getLength(); ++i) {
            Element config = (Element)nl.item(i);
            strings[i] = Configuration.getTextInElement(config, tagName);
        }
        return strings;
    }

    private static String extractImage(Element configEl) {
        return Configuration.getTextInElement(configEl, "image");
    }

    private static String getTextInElement(Element el, String textElName) {
        return XMLUtil.getText((Element)XMLUtil.getElement((Element)el, (String)textElName));
    }
}

