/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee;

import edu.iris.Fissures.AuditInfo;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetToXML;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.ProxySettings;
import edu.sc.seis.gee.Splash;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.Configure;
import edu.sc.seis.gee.task.LoadSacFile;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.UIManager;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;

public class Start
extends JFrame {
    private static boolean loadedFiles = false;
    protected static JWindow splashWin = null;
    static Category logger = Category.getInstance((String)(class$edu$sc$seis$gee$Start == null ? (class$edu$sc$seis$gee$Start = Start.class$("edu.sc.seis.gee.Start")) : class$edu$sc$seis$gee$Start).getName());
    static /* synthetic */ Class class$edu$sc$seis$gee$Start;

    public Start(String name) throws ConfigurationException {
        super(name);
        CommonAccess common = CommonAccess.getCommonAccess();
        splashWin.toFront();
        Configure config = common.getConfigure();
        try {
            String filename = System.getProperties().getProperty("edu.sc.seis.gee.configuration");
            String schemaFilename = "edu/sc/seis/gee/configurator/geeconfigurator.xsd";
            config.load(Start.getReader(filename), true, schemaFilename);
            logger.debug((Object)"finished loading configuration");
        }
        catch (Exception e) {
            if (e instanceof ConfigurationException) {
                throw (ConfigurationException)e;
            }
            throw new ConfigurationException("Problem loading configuration", e);
        }
    }

    public static Reader getReader(String filename) throws IOException {
        InputStream in;
        if (filename.startsWith("http:") || filename.startsWith("ftp:") || filename.startsWith("file:")) {
            URL url = new URL(filename);
            URLConnection conn = url.openConnection();
            in = conn.getInputStream();
        } else {
            ClassLoader classLoader = (class$edu$sc$seis$gee$Start == null ? (class$edu$sc$seis$gee$Start = Start.class$("edu.sc.seis.gee.Start")) : class$edu$sc$seis$gee$Start).getClassLoader();
            in = classLoader.getResourceAsStream(filename);
            if (in == null) {
                throw new IOException("Unable to read " + filename);
            }
        }
        return new BufferedReader(new InputStreamReader(in));
    }

    public static void loadDefaultsIntoSystemProperties() {
        if ((class$edu$sc$seis$gee$Start == null ? (class$edu$sc$seis$gee$Start = Start.class$("edu.sc.seis.gee.Start")) : class$edu$sc$seis$gee$Start).getClassLoader() == null) {
            throw new RuntimeException("Unable to get classloader to load default properties");
        }
        Properties defaultProps = new Properties();
        String defaults = "edu/sc/seis/gee/data/conf/gee.prop";
        try {
            defaultProps.load((class$edu$sc$seis$gee$Start == null ? (class$edu$sc$seis$gee$Start = Start.class$("edu.sc.seis.gee.Start")) : class$edu$sc$seis$gee$Start).getClassLoader().getResourceAsStream(defaults));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load defaults. ", e);
        }
        Enumeration<?> names = defaultProps.propertyNames();
        Properties sysProps = System.getProperties();
        while (names.hasMoreElements()) {
            String key = (String)names.nextElement();
            if (sysProps.containsKey(key)) continue;
            sysProps.put(key, defaultProps.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            block6: {
                try {
                    Start.loadDefaultsIntoSystemProperties();
                    Start.showSplash();
                    CommonAccess common = CommonAccess.getCommonAccess();
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    common.init(args);
                    Start window = new Start("Global Earthquake Explorer");
                    Start.initAppleOnly(window);
                    ArrayList<String> cleanArgs = new ArrayList<String>(args.length);
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i].equals("-props") || args[i].equals("-config")) {
                            ++i;
                            continue;
                        }
                        cleanArgs.add(args[i]);
                    }
                    Start.initMSOnly(cleanArgs, window);
                    logger.debug((Object)("LOADED FILES: " + loadedFiles));
                    if (cleanArgs.size() != 0 || loadedFiles) break block6;
                    common.resetActivity();
                }
                catch (Throwable e) {
                    logger.error((Object)"Exception in main!:", e);
                    GlobalExceptionHandler.handle((String)"A problem occured while starting GEE.", (Throwable)e);
                    Object var6_7 = null;
                    if (splashWin == null) return;
                    splashWin.dispose();
                    return;
                }
            }
            Object var6_6 = null;
            if (splashWin == null) return;
            splashWin.dispose();
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (splashWin == null) throw throwable;
            splashWin.dispose();
            throw throwable;
        }
    }

    public void handleOpenApplication(String[] filenames) {
        logger.debug((Object)"handleOpenApplication ");
        if (!loadedFiles) {
            loadedFiles = true;
            CommonAccess ca = CommonAccess.getCommonAccess();
            try {
                logger.debug((Object)"opening doSeisDisplay activity");
                ca.resetActivity("SeisDisplay", false);
            }
            catch (Exception ex) {
                GlobalExceptionHandler.handle((String)"Problem starting SeisDisplay task", (Throwable)ex);
            }
        }
        for (int i = 0; i < filenames.length; ++i) {
            logger.debug((Object)("opening file " + filenames[i]));
            this.handleOpenFile(filenames[i]);
        }
    }

    public void handleOpenFile(String filename) {
        logger.debug((Object)("handleOpenFile " + filename));
        if (filename == null) {
            return;
        }
        try {
            File file = new File(filename);
            if (filename.endsWith(".dsml")) {
                AuditInfo[] audit = new AuditInfo[]{new AuditInfo("load dataset from " + filename, System.getProperty("user.name"))};
                DataSet ds = DataSetToXML.load((URL)file.toURI().toURL());
                CommonAccess.getCommonAccess().getOrganizer().addDataSet(ds, audit);
                try {
                    CommonAccess.getCommonAccess().getTaskAction("DisplayAllSeismograms").getTask().invoke();
                }
                catch (Exception ex) {
                    GlobalExceptionHandler.handle((String)"Problem starting DisplayAllSeismograms task", (Throwable)ex);
                }
            } else {
                LoadSacFile.load(file, true);
            }
        }
        catch (Exception ex) {
            GlobalExceptionHandler.handle((String)("Problem loading " + filename), (Throwable)ex);
        }
    }

    public static void showSplash() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screen = toolkit.getScreenSize();
        Splash splash = new Splash();
        Dimension splashDim = splash.getPreferredSize();
        splash.setSize(splashDim);
        splashWin = new JWindow();
        splashWin.getContentPane().add(splash);
        splashWin.setSize(splashDim);
        splashWin.setLocation(screen.width / 2 - splashDim.width / 2, screen.height / 2 - splashDim.height / 2);
        try {
            splashWin.show();
            splashWin.toFront();
        }
        catch (Exception e) {
            logger.warn((Object)"problem showing splash", (Throwable)e);
        }
    }

    protected static void initAppleOnly(Start gee) {
        if (System.getProperty("mrj.version") != null) {
            try {
                Class<?> appleClass = Class.forName("edu.sc.seis.gee.macOnly.AppleOnly");
                Class[] startClass = new Class[]{class$edu$sc$seis$gee$Start == null ? (class$edu$sc$seis$gee$Start = Start.class$("edu.sc.seis.gee.Start")) : class$edu$sc$seis$gee$Start};
                Constructor<?> c = appleClass.getConstructor(startClass);
                Object[] param = new Object[]{gee};
                c.newInstance(param);
            }
            catch (Throwable e) {
                logger.warn((Object)"Error loading apple only extensions.", e);
            }
        }
    }

    protected static void initMSOnly(ArrayList cleanArgs, Start window) {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return;
        }
        if (osName.startsWith("Windows")) {
            try {
                Class.forName("com.ice.jni.registry.Registry");
                ProxySettings ps = new ProxySettings();
                if (ps.usesProxy()) {
                    System.setProperty("http.proxyHost", ps.getProxyServer());
                    System.setProperty("http.proxyPort", "" + ps.getProxyPort());
                }
                logger.debug((Object)ps);
            }
            catch (Throwable e) {
                logger.warn((Object)"Error loading windows only extensions.", e);
            }
            if (cleanArgs.size() > 0) {
                window.handleOpenApplication(cleanArgs.toArray(new String[0]));
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

