/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee;

import com.ice.jni.registry.NoSuchValueException;
import com.ice.jni.registry.RegDWordValue;
import com.ice.jni.registry.RegStringValue;
import com.ice.jni.registry.Registry;
import com.ice.jni.registry.RegistryException;
import com.ice.jni.registry.RegistryKey;
import com.ice.jni.registry.RegistryValue;
import java.util.StringTokenizer;

public class ProxySettings {
    boolean usesProxyServer = false;
    String ProxyServer = "0.0.0.0";
    int ProxyPort = -1;

    public ProxySettings() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return;
        }
        if (osName.startsWith("Windows")) {
            try {
                this.checkProxyStatus();
            }
            catch (NoSuchValueException ex) {
                this.usesProxyServer = false;
                this.ProxyServer = "0.0.0.0";
                this.ProxyPort = -1;
            }
            catch (RegistryException ex) {
                this.usesProxyServer = false;
                this.ProxyServer = "0.0.0.0";
                this.ProxyPort = -1;
            }
        }
    }

    private boolean checkProxyEnable() throws NoSuchValueException, RegistryException {
        RegDWordValue val;
        RegistryKey topKey = null;
        boolean isRemote = false;
        String topKeyName = "HKCU";
        Object hostName = null;
        topKey = Registry.getTopLevelKey((String)topKeyName);
        RegistryKey subKey = Registry.openSubkey((RegistryKey)topKey, (String)"software\\microsoft\\windows\\currentversion\\internet settings", (int)1);
        if (subKey == null) {
            return this.usesProxyServer;
        }
        RegistryValue data = null;
        String valueName = "ProxyEnable";
        data = subKey.getValue(valueName);
        if (data instanceof RegDWordValue && (val = (RegDWordValue)data).getData() == 1) {
            this.usesProxyServer = true;
        }
        return this.usesProxyServer;
    }

    private void getProxyInfo() throws NoSuchValueException, RegistryException {
        RegistryKey topKey = null;
        boolean isRemote = false;
        String topKeyName = "HKCU";
        Object hostName = null;
        String valueName = "ProxyServer";
        RegistryValue data = null;
        topKey = Registry.getTopLevelKey((String)topKeyName);
        RegistryKey subKey = Registry.openSubkey((RegistryKey)topKey, (String)"software\\microsoft\\windows\\currentversion\\internet settings", (int)1);
        if (subKey == null) {
            return;
        }
        data = subKey.getValue(valueName);
        if (data instanceof RegStringValue) {
            RegStringValue val = (RegStringValue)data;
            String retVal = val.getData();
            StringTokenizer st = new StringTokenizer(retVal, ":");
            while (st.hasMoreTokens()) {
                this.ProxyServer = st.nextToken();
                String port = st.nextToken();
                this.ProxyPort = Integer.parseInt(port);
            }
        }
    }

    private void checkProxyStatus() throws NoSuchValueException, RegistryException {
        this.checkProxyEnable();
        this.getProxyInfo();
    }

    public boolean usesProxy() {
        return this.usesProxyServer;
    }

    public int getProxyPort() {
        return this.ProxyPort;
    }

    public String getProxyServer() {
        return this.ProxyServer;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        if (this.usesProxy()) {
            ret.append("Using Proxy Server\n");
        } else {
            ret.append("Not Using Proxy Server\n");
        }
        ret.append("ProxyServer is " + this.ProxyServer + "\n");
        ret.append("ProxyPort is " + this.ProxyPort + "\n");
        return ret.toString();
    }

    public static void main(String[] args) {
        ProxySettings ps = new ProxySettings();
    }
}

