/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.FrameEventListener;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.configurator.Configure;
import edu.sc.seis.gee.task.Task;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.apache.log4j.Logger;

public class FrameManager {
    private List listeners = new ArrayList();
    private List motherFrames = new ArrayList();
    private Map childFrames = new HashMap();
    private JFrame currentFrame;
    private HashMap frameToPanel = new HashMap();
    private WindowListener defWindowListener = new MyWindowListener();
    private static FrameManager frameManager = new FrameManager();
    private static Logger logger = Logger.getLogger((Class)(class$edu$sc$seis$gee$FrameManager == null ? (class$edu$sc$seis$gee$FrameManager = FrameManager.class$("edu.sc.seis.gee.FrameManager")) : class$edu$sc$seis$gee$FrameManager));
    static /* synthetic */ Class class$edu$sc$seis$gee$FrameManager;

    private FrameManager() {
    }

    public static final FrameManager getManager() {
        return frameManager;
    }

    public JFrame createNewMother() {
        String newName = "GEE";
        int windowCount = 1;
        while (true) {
            boolean foundName = false;
            Iterator it = this.motherFrames.iterator();
            while (it.hasNext() && !foundName) {
                JFrame current = (JFrame)it.next();
                if (!current.getName().equals(newName)) continue;
                foundName = true;
            }
            if (!foundName) {
                return this.createNewMother(newName);
            }
            newName = "GEE " + windowCount++;
        }
    }

    public JFrame createNewMother(String name) {
        return this.createNewMother(name, new JPanel());
    }

    public JFrame createNewMother(String name, JPanel panel) {
        return this.createNewMother(name, panel, new Dimension(600, 500));
    }

    public JFrame createNewMother(String name, JPanel panel, Dimension dim) {
        return this.createNewMother(name, panel, dim, this.getNextMotherLoc(dim, panel.getGraphicsConfiguration()));
    }

    public JFrame createNewMother(String name, JPanel panel, Dimension dim, Point loc) {
        JFrame nf = this.createNewFrame(name, dim, loc, panel);
        this.motherFrames.add(nf);
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        if (commonAccess == null) {
            throw new RuntimeException("CommonAccess is NULL");
        }
        this.setMenuBar(nf);
        return nf;
    }

    public JFrame createNewChild(String name, JFrame motherFrame) {
        return this.createNewChild(name, motherFrame, new Dimension(400, 400));
    }

    public JFrame createNewChild(String name, JFrame motherFrame, Dimension size) {
        return this.createNewChild(name, motherFrame, size, new JPanel());
    }

    public JFrame createNewChild(String name, JFrame motherFrame, JPanel panel) {
        return this.createNewChild(name, motherFrame, (Dimension)null, panel);
    }

    public JFrame createNewChild(String name, JFrame motherFrame, Dimension size, JPanel panel) {
        return this.createNewChild(name, motherFrame, size, panel, null);
    }

    public JFrame createNewChild(String name, JFrame motherFrame, JPanel panel, Point location) {
        return this.createNewChild(name, motherFrame, null, panel, location);
    }

    public JFrame createNewChild(String name, JFrame motherFrame, Dimension size, JPanel panel, Point location) {
        if (!this.motherFrames.contains(motherFrame)) {
            throw new IllegalArgumentException("Child frame found dressing up in mothers clothes.");
        }
        JFrame frame = this.createNewFrame(name, size, location, panel);
        this.childFrames.put(frame, motherFrame);
        return frame;
    }

    public JFrame reset() {
        JFrame[] frames = this.getAllFrames();
        Dimension size = new Dimension(800, 600);
        Point p = this.getCurrentMainFrame() != null ? this.getCurrentMainFrame().getLocation() : this.getNextMotherLoc(size, null);
        this.currentFrame = this.createNewMother("GEE", null, size, p);
        this.currentFrame.show();
        for (int i = 0; i < frames.length; ++i) {
            this.removeFrame(frames[i]);
        }
        return this.currentFrame;
    }

    public JPanel createNewTab(JFrame frame, String name) {
        if (frame == null) {
            throw new IllegalArgumentException("frame for tab is null, name=" + name);
        }
        JPanel panel = new JPanel();
        panel.setName(name);
        JTabbedPane tab = null;
        if (this.frameToPanel.get(frame) == null) {
            frame.getContentPane().add(panel);
            this.frameToPanel.put(frame, panel);
        } else {
            if (this.frameToPanel.get(frame) instanceof JTabbedPane) {
                tab = (JTabbedPane)this.frameToPanel.get(frame);
            }
            if (tab == null) {
                tab = new JTabbedPane();
                this.frameToPanel.put(frame, tab);
                frame.getContentPane().add((Component)tab, "Center");
            }
            tab.add((Component)panel, tab.getComponentCount());
        }
        frame.show();
        return panel;
    }

    public JFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public JFrame getCurrentMainFrame() {
        if (this.motherFrames.contains(this.currentFrame)) {
            return this.currentFrame;
        }
        return (JFrame)this.childFrames.get(this.currentFrame);
    }

    public JPanel getCurrentPanel() {
        JPanel panel = this.getPanelForFrame(this.currentFrame);
        if (panel == null) {
            panel = new JPanel();
            this.currentFrame.getContentPane().add(panel);
            this.frameToPanel.put(this.currentFrame, panel);
        }
        return panel;
    }

    public void setCurrentPanel(JPanel panel) {
        JFrame frame = this.getFrameForPanel(panel);
        if (frame != null) {
            JComponent framePanel;
            if (!frame.isVisible()) {
                frame.show();
            }
            if (frame.getState() == 1) {
                frame.setState(0);
            }
            if ((framePanel = (JComponent)this.frameToPanel.get(frame)) instanceof JTabbedPane) {
                ((JTabbedPane)framePanel).setSelectedComponent(panel);
            }
        }
    }

    public JPanel getCurrentMainPanel() {
        return this.getPanelForFrame(this.getCurrentMainFrame());
    }

    public JPanel getPanelForFrame(JFrame frame) {
        JComponent panel = (JComponent)this.frameToPanel.get(frame);
        if (panel instanceof JTabbedPane) {
            return (JPanel)((JTabbedPane)panel).getSelectedComponent();
        }
        return (JPanel)panel;
    }

    public JFrame getFrameForPanel(JPanel panel) {
        Iterator it = this.frameToPanel.keySet().iterator();
        while (it.hasNext()) {
            JFrame curFrame = (JFrame)it.next();
            JComponent curComp = (JComponent)this.frameToPanel.get(curFrame);
            if (curComp instanceof JTabbedPane) {
                JTabbedPane tabPane = (JTabbedPane)curComp;
                for (int i = 0; i < tabPane.getComponentCount(); ++i) {
                    if (tabPane.getComponentAt(i) != panel) continue;
                    return curFrame;
                }
                continue;
            }
            if (curComp != panel) continue;
            return curFrame;
        }
        return null;
    }

    public void resize(JFrame frame, Dimension size) {
        Dimension frameSize = frame.getSize();
        int width = size.width;
        if (frameSize.getWidth() > (double)width) {
            width = frameSize.width;
        }
        int height = size.height;
        if (frameSize.getHeight() > (double)height) {
            height = frameSize.height;
        }
        this.setSize(frame, new Dimension(width, height));
    }

    public void setSize(JFrame frame, Dimension size) {
        frame.setSize(size);
    }

    public JFrame[] getAllFrames() {
        ArrayList allFrames = new ArrayList(this.motherFrames);
        allFrames.addAll(this.childFrames.keySet());
        return allFrames.toArray(new JFrame[allFrames.size()]);
    }

    public void clearComponent(Component comp) {
        if (comp instanceof Task) {
            Task task = (Task)((Object)comp);
            CommonAccess.getCommonAccess().getTaskAction(task).reset(false);
        } else if (comp instanceof Container) {
            Container container = (Container)comp;
            Component[] components = container.getComponents();
            for (int i = 0; i < components.length; ++i) {
                this.clearComponent(components[i]);
            }
        }
    }

    public void updateName(JPanel panel) {
        JFrame frame = this.getFrameForPanel(panel);
        if (this.frameToPanel.get(frame) instanceof JTabbedPane) {
            JTabbedPane tab = (JTabbedPane)this.frameToPanel.get(frame);
            for (int i = 0; i < tab.getComponentCount(); ++i) {
                if (tab.getComponentAt(i) != panel) continue;
                tab.setTitleAt(i, panel.getName());
                return;
            }
        }
    }

    public void removeFrame(JFrame frame) {
        Object obj;
        if (this.motherFrames.contains(frame)) {
            Iterator<Object> it = this.childFrames.keySet().iterator();
            ArrayList<JFrame> toRemove = new ArrayList<JFrame>();
            while (it.hasNext()) {
                JFrame curChild = (JFrame)it.next();
                JFrame curFrame = (JFrame)this.childFrames.get(curChild);
                if (!curFrame.equals(frame)) continue;
                toRemove.add(curChild);
            }
            it = toRemove.iterator();
            while (it.hasNext()) {
                this.removeFrame((JFrame)it.next());
            }
            this.motherFrames.remove(frame);
        } else if (this.childFrames.containsKey(frame)) {
            this.childFrames.remove(frame);
        }
        if (this.currentFrame != null && this.currentFrame.equals(frame)) {
            this.currentFrame = null;
        }
        if ((obj = this.frameToPanel.get(frame)) != null && obj instanceof Component) {
            this.clearComponent((Component)obj);
        }
        this.frameToPanel.remove(frame);
        frame.removeWindowListener(this.defWindowListener);
        frame.dispose();
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((FrameEventListener)it.next()).frameRemoved(frame);
        }
        if (this.motherFrames.size() == 0) {
            CommonAccess.getCommonAccess().appQuit();
        }
    }

    public void addFrameEventListener(FrameEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeFrameEventListener(FrameEventListener listener) {
        this.listeners.remove(listener);
    }

    public static Point getLoc(String justification, Dimension objectSize) {
        int x = 0;
        int y = 0;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        if (justification.equals("center")) {
            x = (screenSize.width - objectSize.width) / 2;
            y = (screenSize.height - objectSize.height) / 2;
        } else if (justification.equals("topleft")) {
            x = 0;
            y = 0;
        } else if (justification.equals("topright")) {
            x = screenSize.width - objectSize.width;
            y = 0;
        } else if (justification.equals("bottomleft")) {
            x = 0;
            y = screenSize.height - objectSize.height - 40;
        } else if (justification.equals("bottomright")) {
            x = screenSize.width - objectSize.width;
            y = screenSize.height - objectSize.height - 40;
        }
        return new Point(x, y);
    }

    private Point getNextMotherLoc(Dimension motherSize, GraphicsConfiguration graphics) {
        return this.getNextMotherLoc(motherSize, graphics, null);
    }

    private Point getNextMotherLoc(Dimension motherSize, GraphicsConfiguration graphics, JFrame frame) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        Rectangle usableScreen = this.getUsableScreen(graphics);
        Iterator it = this.motherFrames.iterator();
        Point curPoint = new Point((int)(usableScreen.getCenterX() - (double)(motherSize.width / 2)), (int)(usableScreen.getCenterY() - (double)(motherSize.height / 2)));
        while (curPoint.x + motherSize.width < screenSize.width && curPoint.y + motherSize.height < screenSize.height) {
            boolean occupied = false;
            while (it.hasNext() && !occupied) {
                JFrame curFrame = (JFrame)it.next();
                if (frame == curFrame || (double)curFrame.getX() != curPoint.getX() || (double)curFrame.getY() != curPoint.getY()) continue;
                occupied = true;
            }
            if (!occupied) {
                return curPoint;
            }
            curPoint.x += 30;
            curPoint.y += 30;
        }
        return new Point(usableScreen.x, usableScreen.y);
    }

    private Rectangle getUsableScreen(GraphicsConfiguration graphics) {
        Insets insets;
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension size = tk.getScreenSize();
        if (graphics != null) {
            insets = tk.getScreenInsets(graphics);
        } else {
            JFrame frame = new JFrame();
            insets = tk.getScreenInsets(frame.getGraphicsConfiguration());
            frame.dispose();
        }
        int width = size.width - insets.left - insets.right;
        int height = size.height - insets.top - insets.bottom;
        return new Rectangle(insets.left, insets.top, width, height);
    }

    private Point getNextChildLoc(Dimension childSize, GraphicsConfiguration graphics) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension screenSize = tk.getScreenSize();
        Insets screenInsets = tk.getScreenInsets(graphics);
        int screenHeight = screenSize.height - screenInsets.top - screenInsets.bottom;
        int screenWidth = screenSize.width - screenInsets.left - screenInsets.right;
        int childHeight = childSize.height;
        int childWidth = childSize.width;
        Coverage coveredX = new Coverage();
        Coverage coveredY = new Coverage();
        Iterator it = this.childFrames.keySet().iterator();
        while (it.hasNext()) {
            JFrame current = (JFrame)it.next();
            Point curLoc = current.getLocation();
            Dimension curSize = current.getSize();
            if ((double)curSize.height + curLoc.getY() > (double)(screenHeight - childHeight)) {
                coveredX.add((int)curLoc.getX(), (int)curLoc.getX() + curSize.width);
            }
            if (!((double)curSize.width + curLoc.getX() > (double)(screenWidth - childWidth))) continue;
            coveredY.add((int)curLoc.getY(), (int)curLoc.getY() + curSize.height);
        }
        int[][] xCoverage = coveredX.getCoveredAreas();
        if (xCoverage.length == 0) {
            return new Point(screenInsets.left, screenHeight - childHeight);
        }
        int curPos = 0;
        int[] xSpace = new int[]{0, 0};
        for (int i = 0; i < xCoverage.length; ++i) {
            int spaceAvailable = xCoverage[i][0] - curPos;
            if (spaceAvailable >= childWidth) {
                return new Point(curPos, screenHeight - childHeight);
            }
            if (spaceAvailable > xSpace[0]) {
                xSpace[0] = spaceAvailable;
                xSpace[1] = curPos;
            }
            curPos = xCoverage[i][1];
        }
        if (curPos + childWidth < screenWidth) {
            return new Point(curPos, screenHeight - childHeight);
        }
        int[][] yCoverage = coveredY.getCoveredAreas();
        if (yCoverage.length == 0) {
            return new Point(screenWidth - childWidth, screenInsets.top);
        }
        curPos = 0;
        int[] ySpace = new int[]{0, 0};
        for (int i = 0; i < yCoverage.length; ++i) {
            int spaceAvailable = yCoverage[i][0] - curPos;
            if (spaceAvailable >= childHeight) {
                return new Point(screenWidth - childWidth, curPos);
            }
            if (spaceAvailable > ySpace[0]) {
                ySpace[0] = spaceAvailable;
                ySpace[1] = curPos;
            }
            curPos = yCoverage[i][1];
        }
        if (xSpace[0] > ySpace[0]) {
            return new Point(xSpace[1], screenHeight - childHeight);
        }
        return new Point(screenWidth - childWidth, ySpace[1]);
    }

    private JFrame createNewFrame(String name, Dimension size, Point location, JPanel panel) {
        JFrame nf = new JFrame(name);
        nf.setName(name);
        String resource = "edu/sc/seis/gee/data/images/gee-icon.gif";
        URL url = this.getClass().getClassLoader().getResource(resource);
        nf.setIconImage(new ImageIcon(url).getImage());
        this.currentFrame = nf;
        nf.addWindowListener(this.defWindowListener);
        nf.getContentPane().setLayout(new BorderLayout());
        if (panel != null) {
            panel.setName(name);
            this.frameToPanel.put(nf, panel);
            nf.getContentPane().add((Component)panel, "Center");
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        if (size == null) {
            nf.pack();
            size = nf.getSize();
        }
        if (size.width > dimension.width) {
            size.width = dimension.width;
        }
        if (size.height > dimension.height) {
            size.height = dimension.height;
        }
        nf.setSize(size);
        nf.setDefaultCloseOperation(2);
        if (location == null) {
            location = this.getNextChildLoc(size, nf.getGraphicsConfiguration());
        }
        nf.setLocation(location);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((FrameEventListener)it.next()).frameAdded(nf);
        }
        return nf;
    }

    public void setMenuBar(JFrame frame) {
        try {
            Configure configure = CommonAccess.getCommonAccess().getConfigure();
            JMenuBar menubar = configure.getMenuBar();
            if (menubar != null) {
                if (menubar.getComponentCount() > 0) {
                    menubar.add(new WindowMenu());
                }
                frame.setJMenuBar(menubar);
            } else {
                frame.setJMenuBar(new JMenuBar());
            }
        }
        catch (ConfigurationException e) {
            GlobalExceptionHandler.handle((String)"Can't get the menubar due to a configuration problem.", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class MyWindowListener
    extends WindowAdapter {
        private MyWindowListener() {
        }

        public void windowClosed(WindowEvent e) {
            FrameManager.this.removeFrame((JFrame)e.getWindow());
        }

        public void windowActivated(WindowEvent e) {
            FrameManager.this.currentFrame = (JFrame)e.getWindow();
        }
    }

    private class WindowMenu
    extends JMenu
    implements FrameEventListener {
        private Map frameMenuItem = new HashMap();

        public WindowMenu() {
            super("Windows");
            JFrame[] currentFrames = FrameManager.this.getAllFrames();
            for (int i = 0; i < currentFrames.length; ++i) {
                this.frameAdded(currentFrames[i]);
            }
            FrameManager.this.addFrameEventListener(this);
        }

        public void destroy() {
            FrameManager manager = FrameManager.getManager();
            manager.removeFrameEventListener(this);
        }

        public void frameRemoved(JFrame jf) {
            if (this.frameMenuItem.get(jf) != null) {
                this.remove((FrameMenuItem)this.frameMenuItem.get(jf));
                this.frameMenuItem.remove(jf);
            }
        }

        public void frameAdded(JFrame jf) {
            this.frameMenuItem.put(jf, new FrameMenuItem(jf));
            this.add((FrameMenuItem)this.frameMenuItem.get(jf));
        }

        private class FrameMenuItem
        extends JMenuItem {
            private final JFrame jframe;

            private FrameMenuItem(JFrame frame) {
                super(frame.getName());
                this.jframe = frame;
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        if (jframe.getState() == 1) {
                            jframe.setState(0);
                        }
                        jframe.toFront();
                    }
                });
            }
        }
    }

    private class Coverage {
        private List coveredAreas = new ArrayList();

        private Coverage() {
        }

        private void add(int begin, int end) {
            Rectangle2D.Float newCoverage = new Rectangle2D.Float(begin, 0.0f, end - begin, 1.0f);
            for (int i = 0; i < this.coveredAreas.size(); ++i) {
                Rectangle2D current = (Rectangle2D)this.coveredAreas.get(i);
                if (!newCoverage.intersects(current) && !(Math.abs(newCoverage.getMinX() - current.getMaxX()) <= 1.0) && !(Math.abs(newCoverage.getMaxX() - current.getMinX()) <= 1.0)) continue;
                this.coveredAreas.remove(i);
                Rectangle2D.union(newCoverage, current, newCoverage);
                this.add((int)newCoverage.getMinX(), (int)newCoverage.getMaxX());
                return;
            }
            this.coveredAreas.add(newCoverage);
        }

        private int[][] getCoveredAreas() {
            ArrayList<int[]> orderedCoveredAreas = new ArrayList<int[]>();
            Iterator it = this.coveredAreas.iterator();
            for (int i = 0; i < this.coveredAreas.size(); ++i) {
                Rectangle2D current = (Rectangle2D)it.next();
                int[] covAreas = new int[]{(int)current.getX(), (int)(current.getMaxX() - current.getMinX())};
                ListIterator<int[]> orIt = orderedCoveredAreas.listIterator();
                while (orIt.hasNext()) {
                    int[] curOrIt = (int[])orIt.next();
                    if (!(current.getMinX() < (double)curOrIt[0])) continue;
                    orIt.previous();
                    orIt.add(covAreas);
                    break;
                }
                orderedCoveredAreas.add(covAreas);
            }
            int[][] twoDArray = new int[orderedCoveredAreas.size()][2];
            for (int i = 0; i < orderedCoveredAreas.size(); ++i) {
                twoDArray[i] = (int[])orderedCoveredAreas.get(i);
            }
            return twoDArray;
        }
    }
}

