/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.updatechecker;

import com.isti.util.IstiXmlUtils;
import com.isti.util.updatechecker.BasicUpdateCheckerServer;
import com.isti.util.updatechecker.LocationUpdate;
import com.isti.util.updatechecker.UpdateAction;
import com.isti.util.updatechecker.UpdateInformation;
import java.util.List;
import org.jdom.Element;

public class XMLUpdateCheckerServer
extends BasicUpdateCheckerServer {
    public static final String UPDATE_CHECKER_TAG = "UpdateChecker";
    public static final String ADMIN_EMAIL = "AdminEmail";
    public static final String UPDATE = "Update";
    public static final String VERSION = "Version";
    public static final String DATE = "Date";
    public static final String FEATURES = "Features";
    public static final String REASON = "Reason";
    public static final String UPDATE_ACTION = "UpdateAction";
    public static final String DESCRIPTION = "Description";
    public static final String UPDATE_LOCATION = "UpdateLocation";
    protected static final IstiXmlUtils istiXmlUtilsObj = new IstiXmlUtils();

    public XMLUpdateCheckerServer(String updateLocationString) {
        this(XMLUpdateCheckerServer.createRootElement(updateLocationString));
    }

    public XMLUpdateCheckerServer(Element rootElement) {
        super(XMLUpdateCheckerServer.createAdminEmailAddress(rootElement), XMLUpdateCheckerServer.createUpdates(rootElement));
    }

    protected static Element createRootElement(String updateLocationString) {
        Element rootElement = null;
        if (!istiXmlUtilsObj.loadFile(updateLocationString, UPDATE_CHECKER_TAG)) {
            System.out.println("Error loading file:  " + istiXmlUtilsObj.getErrorMessage());
            return rootElement;
        }
        rootElement = istiXmlUtilsObj.getRootElement();
        return rootElement;
    }

    protected static String getChildText(Element e, String name) {
        String text = null;
        Element child = e.getChild(name);
        if (child != null) {
            text = child.getText();
        }
        return text;
    }

    protected static String createAdminEmailAddress(Element rootElement) {
        if (rootElement == null) {
            return null;
        }
        return XMLUpdateCheckerServer.getChildText(rootElement, ADMIN_EMAIL);
    }

    protected static UpdateInformation[] createUpdates(Element rootElement) {
        if (rootElement == null) {
            return new UpdateInformation[0];
        }
        List children = rootElement.getChildren(UPDATE);
        UpdateInformation[] updates = new UpdateInformation[children.size()];
        int i = 0;
        while (i < children.size()) {
            Element currentElement = (Element)children.get(i);
            String versionString = currentElement.getAttributeValue(VERSION);
            String versionDate = currentElement.getAttributeValue(DATE);
            String features = XMLUpdateCheckerServer.getChildText(currentElement, FEATURES);
            String reasons = XMLUpdateCheckerServer.getChildText(currentElement, REASON);
            UpdateAction[] updateActions = XMLUpdateCheckerServer.createUpdateActions(currentElement);
            updates[i] = new UpdateInformation(versionString, versionDate, features, reasons, updateActions);
            ++i;
        }
        return updates;
    }

    protected static UpdateAction[] createUpdateActions(Element updateElement) {
        List children = updateElement.getChildren(UPDATE_ACTION);
        UpdateAction[] actions = new UpdateAction[children.size()];
        int i = 0;
        while (i < children.size()) {
            Element currentElement = (Element)children.get(i);
            String description = currentElement.getAttributeValue(DESCRIPTION);
            String location = XMLUpdateCheckerServer.getChildText(currentElement, UPDATE_LOCATION);
            actions[i] = new LocationUpdate(description, location);
            ++i;
        }
        return actions;
    }
}

