/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util.updatechecker;

import com.isti.util.IstiVersion;
import com.isti.util.updatechecker.BasicUpdateCheckerClient;
import com.isti.util.updatechecker.BasicUpdateCheckerServer;
import com.isti.util.updatechecker.LocationUpdate;
import com.isti.util.updatechecker.UpdateAction;
import com.isti.util.updatechecker.UpdateInformation;
import com.isti.util.updatechecker.XMLUpdateCheckerServer;

public class XMLUpdateCheckerClient
extends BasicUpdateCheckerClient {
    protected static boolean debug = false;

    public XMLUpdateCheckerClient(String versionString, String updateLocationString) {
        this(new IstiVersion(versionString), updateLocationString);
    }

    public XMLUpdateCheckerClient(IstiVersion version, String updateLocationString) {
        super(version, new XMLUpdateCheckerServer(updateLocationString));
    }

    public static void main(String[] args) {
        String versionString = "0.0.2";
        int i = 0;
        while (i < args.length) {
            if (args[i].toLowerCase().equals("debug")) {
                debug = true;
            } else {
                versionString = args[i];
            }
            ++i;
        }
        String localUpdateLocationString = "src/com/isti/util/updatechecker/UpdateChecker.xml";
        String remoteUpdateLocationString = "http://www.isti.com/~kevin/UpdateChecker.xml";
        XMLUpdateCheckerClient updateChecker = new XMLUpdateCheckerClient(versionString, "src/com/isti/util/updatechecker/UpdateChecker.xml");
        if (debug) {
            System.out.println(updateChecker);
            System.out.println("Update is" + (updateChecker.isUpdateAvailable() ? "" : " not") + " available");
        }
        UpdateInformation[] updates = updateChecker.getUpdates();
        if (debug) {
            System.out.println(BasicUpdateCheckerServer.toString(updates));
        } else {
            String installer = "No updates available";
            if (updates.length > 0) {
                UpdateAction[] actions = updates[updates.length - 1].getUpdateActions();
                installer = actions.length <= 0 ? "No installers available" : (actions[0] instanceof LocationUpdate ? ((LocationUpdate)actions[0]).getLocation() : actions[0].getDescription());
            }
            System.out.println("\nInstaller:\n" + installer);
        }
    }
}

