/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.AbstractFileFilter;
import java.io.File;
import java.util.StringTokenizer;

class WildcardFilter
extends AbstractFileFilter {
    private String fileNameStr;

    public WildcardFilter(String filter) {
        super(filter);
        this.fileNameStr = new File(filter).getName();
    }

    public boolean accept(String filename) {
        int idx = 0;
        boolean wildCard = false;
        StringTokenizer tokens = new StringTokenizer(this.fileNameStr, "*", true);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().toLowerCase();
            if (token.equals("*")) {
                wildCard = true;
            } else {
                int nextIdx = filename.indexOf(token, idx);
                if (wildCard) {
                    wildCard = false;
                    if (nextIdx < 0) break;
                    idx = nextIdx + token.length();
                } else {
                    if (nextIdx != idx) break;
                    idx += token.length();
                }
            }
            if (tokens.hasMoreTokens() || !wildCard && idx != filename.length()) continue;
            return true;
        }
        return false;
    }
}

