/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.BooleanCp;
import com.isti.util.CfgPropValidator;
import java.awt.Color;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;

public class UtilFns {
    public static final long MS_PER_MINUTE = 60000L;
    public static final long MS_PER_HOUR = 3600000L;
    public static final long MS_PER_DAY = 86400000L;
    public static final String DATE_FORMAT24_STR = "MMM dd yyyy HH:mm:ss z";
    public static final String DATE_FORMAT_AMPM_STR = "MMM dd yyyy hh:mm:ss a z";
    public static final TimeZone GMT_TIME_ZONE_OBJ = TimeZone.getTimeZone("GMT");
    public static final int colorPropertyStringLength = 8;
    private static final DateFormat dateFormatter = UtilFns.createDateFormatObj("MMM dd yyyy HH:mm:ss z");
    private static final DateFormat dateFormatterGMT = UtilFns.createDateFormatObj("MMM dd yyyy HH:mm:ss z", GMT_TIME_ZONE_OBJ);
    private static final DateFormat dateFormatterAmPm = UtilFns.createDateFormatObj("MMM dd yyyy hh:mm:ss a z");
    private static final DateFormat dateFormatterGMTAmPm = UtilFns.createDateFormatObj("MMM dd yyyy hh:mm:ss a z", GMT_TIME_ZONE_OBJ);
    private static final Runtime systemRuntimeObj = Runtime.getRuntime();
    private static final NumberFormat floatNumberFormatObj = new DecimalFormat("#0.0#");
    private static final NumberFormat variableNumberFormatObj = new DecimalFormat("#0.0#");
    public static final String newline;
    private static String blanksString;
    private static int blanksStringLen;
    private static final Object blanksStringSyncObj;
    private static Integer[] COLOR_HASH_VALUES;
    private static String[] COLOR_HASH_STRINGS;
    private static String[] COLOR_DISPLAY_STRINGS;
    private static Hashtable strToClrHashtable;
    private static Hashtable clrToStrHashtable;
    public static final String[] IGNORE_IP_ADDRS;
    public static final String DEF_SPECIAL_CHARS_STR = "\"\r\n\t\\";
    private static String[] timeZoneIDs;
    public static final CfgPropValidator timeZoneValidator;

    private UtilFns() {
    }

    public static long getSystemTimeSec() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long intTimeToLong(int intTime) {
        if (intTime >= 0) {
            return intTime;
        }
        return (long)intTime + 0x100000000L;
    }

    public static String timeMillisToString(long millis, boolean gmtFlag, boolean amPmFlag) {
        if (amPmFlag) {
            return gmtFlag ? dateFormatterGMTAmPm.format(new Date(millis)) : dateFormatterAmPm.format(new Date(millis));
        }
        return gmtFlag ? dateFormatterGMT.format(new Date(millis)) : dateFormatter.format(new Date(millis));
    }

    public static String timeMillisToString(long millis, boolean gmtFlag) {
        return UtilFns.timeMillisToString(millis, gmtFlag, false);
    }

    public static String timeMillisToString(long millis) {
        return UtilFns.timeMillisToString(millis, false, false);
    }

    public static String timeMillisToString() {
        return UtilFns.timeMillisToString(System.currentTimeMillis(), false, false);
    }

    public static Date parseStringToDate(String s, boolean gmtFlag, boolean amPmFlag) {
        Date dateObj;
        try {
            dateObj = amPmFlag ? (gmtFlag ? dateFormatterGMTAmPm.parse(s) : dateFormatterAmPm.parse(s)) : (gmtFlag ? dateFormatterGMT.parse(s) : dateFormatter.parse(s));
        }
        catch (Exception ex) {
            return null;
        }
        return dateObj;
    }

    public static Date parseStringToDate(String s, boolean gmtFlag) {
        return UtilFns.parseStringToDate(s, gmtFlag, false);
    }

    public static Date parseStringToDate(String s) {
        return UtilFns.parseStringToDate(s, false, false);
    }

    public static boolean setDateFormatPattern(DateFormat formatObj, String patternStr) {
        try {
            if (formatObj instanceof SimpleDateFormat && patternStr != null) {
                ((SimpleDateFormat)formatObj).applyPattern(patternStr);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static DateFormat createDateFormatObj(String patternStr, TimeZone timeZoneObj) {
        DateFormat formatObj = DateFormat.getDateTimeInstance();
        if (!UtilFns.setDateFormatPattern(formatObj, patternStr)) {
            formatObj = new SimpleDateFormat(patternStr);
        }
        if (timeZoneObj != null) {
            formatObj.setTimeZone(timeZoneObj);
        }
        return formatObj;
    }

    public static DateFormat createDateFormatObj(String patternStr) {
        return UtilFns.createDateFormatObj(patternStr, null);
    }

    public static String[] getTimeZoneIDs() {
        return timeZoneIDs;
    }

    public static TimeZone parseTimeZoneID(String id) {
        return TimeZone.getTimeZone(id);
    }

    public static boolean sleep(long millisecs) {
        try {
            Thread.sleep(millisecs);
            return true;
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    public static String shortClassString(Class classObj) {
        String str;
        if (classObj == null || (str = classObj.getName()) == null) {
            return "";
        }
        int p = str.lastIndexOf(46);
        if (p >= 0) {
            str = str.substring(p + 1);
        }
        return str;
    }

    public static String stripBrackets(String str) {
        int len;
        if (str == null || (len = str.length()) < 2 || str.charAt(0) != '[' || str.charAt(len - 1) != ']') {
            return str;
        }
        return str.substring(1, len - 1);
    }

    public static String stripChar(String str, char ch) {
        StringBuffer buff = new StringBuffer(str);
        int pos = 0;
        int c = 0;
        while ((pos = buff.toString().indexOf(ch, pos)) >= 0) {
            buff.deleteCharAt(pos);
            ++c;
        }
        return c > 0 ? buff.toString() : str;
    }

    public static String stripTrailingString(String dataStr, String stripStr) {
        if (dataStr != null && stripStr != null && dataStr.endsWith(stripStr)) {
            return dataStr.substring(0, dataStr.length() - stripStr.length());
        }
        return dataStr;
    }

    public static String stripTrailingNewline(String dataStr) {
        return UtilFns.stripTrailingString(dataStr, newline);
    }

    public static Number parseNumber(String str) {
        if (str == null || str.length() < 1) {
            return null;
        }
        try {
            if (str.indexOf(46) >= 0) {
                return new Double(str);
            }
            if (str.charAt(0) < 'A') {
                return new Integer(str);
            }
            if (str.equalsIgnoreCase("true")) {
                return new BooleanCp(true);
            }
            if (str.equalsIgnoreCase("false")) {
                return new BooleanCp(false);
            }
        }
        catch (NumberFormatException ex) {}
        return null;
    }

    public static String getUserConsoleString() {
        try {
            return new BufferedReader(new InputStreamReader(System.in)).readLine();
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static int getColorDisplayNameIndex(int value) {
        int i = 0;
        while (i < COLOR_HASH_VALUES.length) {
            if (COLOR_HASH_VALUES[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getColorDisplayNameValue(int index) {
        return COLOR_HASH_VALUES[index];
    }

    public static String getColorDisplayName(int value) {
        int index = UtilFns.getColorDisplayNameIndex(value);
        String displayName = index >= 0 ? COLOR_DISPLAY_STRINGS[index] : UtilFns.colorRGBToString(value, true);
        return displayName;
    }

    public static String[] getColorDisplayNames() {
        return COLOR_DISPLAY_STRINGS;
    }

    public static Integer stringToColorRGB(String str) {
        return UtilFns.stringToColorRGB(str, false);
    }

    public static Integer stringToColorRGB(String str, boolean tryRGBFlag) {
        Object obj;
        if (strToClrHashtable == null) {
            strToClrHashtable = new Hashtable();
            int i = 0;
            while (i < COLOR_HASH_STRINGS.length) {
                strToClrHashtable.put(COLOR_HASH_STRINGS[i], COLOR_HASH_VALUES[i]);
                ++i;
            }
        }
        if ((obj = strToClrHashtable.get(str.toLowerCase())) instanceof Integer) {
            return (Integer)obj;
        }
        if (tryRGBFlag) {
            Color colorObj;
            int p = str.indexOf(44);
            if (p >= 0) {
                int[] intArr = new int[3];
                int len = str.length();
                int c = 0;
                int stPos = 0;
                while (true) {
                    try {
                        intArr[c] = Integer.parseInt(str.substring(stPos, p));
                    }
                    catch (Exception ex) {
                        return null;
                    }
                    if (++c >= 3) break;
                    stPos = p + 1;
                    if (stPos >= len) {
                        return null;
                    }
                    p = str.indexOf(44, stPos);
                    if (p >= 0) continue;
                    p = len;
                }
                if (p < len) {
                    return null;
                }
                try {
                    colorObj = new Color(intArr[0], intArr[1], intArr[2]);
                }
                catch (Exception ex) {
                    return null;
                }
            }
            try {
                int value;
                boolean hasalpha = false;
                try {
                    value = Integer.parseInt(str);
                }
                catch (NumberFormatException ex) {
                    value = Long.decode(str).intValue();
                    hasalpha = true;
                }
                colorObj = new Color(value, hasalpha);
            }
            catch (Exception ex) {
                return null;
            }
            try {
                return new Integer(colorObj.getRGB());
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static String colorRGBToString(int colorRGBVal) {
        Object obj;
        if (clrToStrHashtable == null) {
            clrToStrHashtable = new Hashtable();
            int i = 0;
            while (i < COLOR_HASH_VALUES.length) {
                clrToStrHashtable.put(COLOR_HASH_VALUES[i], COLOR_HASH_STRINGS[i]);
                ++i;
            }
        }
        if ((obj = clrToStrHashtable.get(new Integer(colorRGBVal))) == null || !(obj instanceof String)) {
            return null;
        }
        return (String)obj;
    }

    public static String toHexString(int i, int numDigits) {
        String hexString = Integer.toHexString(i);
        int len = hexString.length();
        while (len < numDigits) {
            hexString = "0" + hexString;
            ++len;
        }
        return hexString;
    }

    public static String colorToPropertyString(Color colorObj) {
        return UtilFns.toHexString(colorObj.getRGB(), 8).toUpperCase();
    }

    public static String floatNumberToPropertyString(Object value) {
        return floatNumberFormatObj.format(value);
    }

    public static String floatNumberToString(double value) {
        int digits = 1;
        if (value > 0.0 && value < 0.1) {
            double x = value;
            while ((x *= 10.0) < 1.0) {
                ++digits;
            }
        }
        return UtilFns.floatNumberToString(value, digits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String floatNumberToString(double value, int digits) {
        String retVal;
        NumberFormat numberFormat = variableNumberFormatObj;
        synchronized (numberFormat) {
            variableNumberFormatObj.setMaximumFractionDigits(digits);
            retVal = variableNumberFormatObj.format(value);
        }
        return retVal;
    }

    public static Color parseColor(String colorString) throws NumberFormatException {
        int value = (int)Long.parseLong(colorString, 16);
        if (colorString.length() < 7 && !colorString.equals("0")) {
            return new Color(value);
        }
        return new Color(value, true);
    }

    public static String colorRGBToString(int colorRGBVal, boolean useHexFlag) {
        String colorStr = UtilFns.colorRGBToString(colorRGBVal);
        if (colorStr == null && useHexFlag) {
            colorStr = UtilFns.toHexString(colorRGBVal, 8).toUpperCase();
            if (colorStr.startsWith("FF")) {
                colorStr = colorStr.substring(2);
            }
            colorStr = "0x" + colorStr;
        }
        return colorStr;
    }

    public static Color createOpaqueColor(Color colorObj) {
        return new Color(colorObj.getRed(), colorObj.getGreen(), colorObj.getBlue());
    }

    public static String insertQuoteChars(String dataStr, String specialChars) {
        boolean changedFlag = false;
        if (dataStr == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer(dataStr);
        if (specialChars != null && specialChars.length() > 0) {
            int p = 0;
            while (p < buff.length()) {
                if (specialChars.indexOf(buff.charAt(p)) >= 0) {
                    buff.insert(p, '\\');
                    switch (buff.charAt(++p)) {
                        case '\r': {
                            buff.setCharAt(p, 'r');
                            break;
                        }
                        case '\n': {
                            buff.setCharAt(p, 'n');
                            break;
                        }
                        case '\t': {
                            buff.setCharAt(p, 't');
                        }
                    }
                    changedFlag = true;
                }
                ++p;
            }
        }
        return changedFlag ? buff.toString() : dataStr;
    }

    public static String removeQuoteChars(String dataStr, boolean removeDblFlag) {
        if (dataStr == null) {
            return null;
        }
        int p = dataStr.indexOf(92);
        if (p >= 0) {
            StringBuffer buff = new StringBuffer(dataStr);
            while (p < buff.length() - 1) {
                buff.deleteCharAt(p);
                switch (buff.charAt(p)) {
                    case 'r': {
                        buff.setCharAt(p, '\r');
                        break;
                    }
                    case 'n': {
                        buff.setCharAt(p, '\n');
                        break;
                    }
                    case 't': {
                        buff.setCharAt(p, '\t');
                    }
                }
                ++p;
                p = buff.toString().indexOf(92, p);
                if (p > 0) continue;
            }
            if (removeDblFlag && (p = buff.length()) > 1 && buff.charAt(0) == '\"' && buff.charAt(p - 1) == '\"') {
                return buff.substring(1, p - 1);
            }
            return buff.toString();
        }
        if (removeDblFlag && (p = dataStr.length()) > 1 && dataStr.charAt(0) == '\"' && dataStr.charAt(p - 1) == '\"') {
            return dataStr.substring(1, p - 1);
        }
        return dataStr;
    }

    public static String removeQuoteChars(String dataStr) {
        return UtilFns.removeQuoteChars(dataStr, false);
    }

    public static int findCharPos(String str, char ch, int startPos) {
        if (startPos >= str.length()) {
            return -1;
        }
        int foundPos;
        while ((foundPos = str.indexOf(ch, startPos)) >= 0) {
            if (foundPos == 0) {
                return foundPos;
            }
            if (str.charAt(foundPos - 1) != '\\') {
                --startPos;
                do {
                    if ((startPos = str.indexOf(34, startPos + 1)) >= 0) continue;
                    return foundPos;
                } while (startPos > 0 && str.charAt(startPos - 1) == '\\');
                if (startPos > foundPos) {
                    return foundPos;
                }
                do {
                    if ((startPos = str.indexOf(34, startPos + 1)) >= 0) continue;
                    return -1;
                } while (str.charAt(startPos - 1) == '\\');
                ++startPos;
                continue;
            }
            startPos = foundPos + 1;
        }
        return -1;
    }

    public static int findCharPos(String str, char ch) {
        return UtilFns.findCharPos(str, ch, 0);
    }

    public static int findCharPos(String str, String searchCharsStr, int startPos) {
        int strLen;
        if (searchCharsStr == null) {
            return -1;
        }
        int minPos = strLen = str.length();
        int searchCharsStrLen = searchCharsStr.length();
        int i = 0;
        while (i < searchCharsStrLen) {
            int p = UtilFns.findCharPos(str, searchCharsStr.charAt(i), startPos);
            if (p >= 0 && p < minPos) {
                minPos = p;
            }
            ++i;
        }
        return minPos < strLen ? minPos : -1;
    }

    public static int findCharPos(String str, String searchCharsStr) {
        return UtilFns.findCharPos(str, searchCharsStr, 0);
    }

    public static String enumToListString(Enumeration e) {
        StringBuffer buff = new StringBuffer();
        if (e.hasMoreElements()) {
            while (true) {
                Object obj;
                if ((obj = e.nextElement()) != null) {
                    buff.append(obj.toString());
                } else {
                    buff.append("(null)");
                }
                if (!e.hasMoreElements()) break;
                buff.append(", ");
            }
        }
        return buff.toString();
    }

    public static String enumToString(Enumeration e) {
        StringBuffer buff = new StringBuffer();
        buff.append("{");
        if (e.hasMoreElements()) {
            while (true) {
                Object obj;
                if ((obj = e.nextElement()) != null) {
                    buff.append(obj.toString());
                } else {
                    buff.append("(null)");
                }
                if (!e.hasMoreElements()) break;
                buff.append(", ");
            }
        }
        buff.append("}");
        return buff.toString();
    }

    public static String enumToQuotedStrings(Enumeration enumeration, String sepStr, boolean quoteCharsFlag) {
        StringBuffer retBuff = new StringBuffer();
        if (enumeration != null && enumeration.hasMoreElements()) {
            if (quoteCharsFlag) {
                while (true) {
                    Object obj;
                    if ((obj = enumeration.nextElement()) != null) {
                        retBuff.append("\"" + UtilFns.insertQuoteChars(obj.toString(), DEF_SPECIAL_CHARS_STR) + "\"");
                    }
                    if (enumeration.hasMoreElements()) {
                        retBuff.append(sepStr);
                        continue;
                    }
                    break;
                }
            } else {
                while (true) {
                    Object obj;
                    if ((obj = enumeration.nextElement()) != null) {
                        retBuff.append("\"" + obj.toString() + "\"");
                    }
                    if (!enumeration.hasMoreElements()) break;
                    retBuff.append(sepStr);
                }
            }
        }
        return retBuff.toString();
    }

    public static String enumToQuotedStrings(Enumeration enumeration, char sepChar, boolean quoteCharsFlag) {
        return UtilFns.enumToQuotedStrings(enumeration, new String(new char[]{sepChar}), quoteCharsFlag);
    }

    public static String enumToQuotedStrings(Enumeration enumeration) {
        return UtilFns.enumToQuotedStrings(enumeration, ',', true);
    }

    public static Vector quotedStringsToVector(String str, char sepChar, boolean strictFlag) {
        int ePos;
        if (str == null) {
            return null;
        }
        Vector<String> retVec = new Vector<String>();
        int strLen = str.length();
        if (strLen <= 0) {
            return retVec;
        }
        int sPos = 0;
        do {
            if ((ePos = UtilFns.findCharPos(str, sepChar, sPos)) < sPos) {
                ePos = strLen;
            }
            String subStr = str.substring(sPos, ePos);
            if (strictFlag) {
                int p = subStr.length();
                if (p <= 0) break;
                if (p < 2 || subStr.charAt(0) != '\"' || subStr.charAt(p - 1) != '\"') {
                    return null;
                }
            } else if ((subStr = subStr.trim()).length() <= 0) break;
            subStr = UtilFns.removeQuoteChars(subStr, true);
            retVec.add(subStr);
        } while ((sPos = ePos + 1) < strLen);
        return retVec;
    }

    public static Vector quotedStringsToVector(String str, char sepChar) {
        return UtilFns.quotedStringsToVector(str, sepChar, true);
    }

    public static Vector quotedStringsToVector(String str) {
        return UtilFns.quotedStringsToVector(str, ',', true);
    }

    /*
     * Unable to fully structure code
     */
    public static Vector quotedStringsToVector(String str, String sepCharsStr, boolean strictFlag) {
        if (str == null) {
            return null;
        }
        if (sepCharsStr == null || sepCharsStr.length() <= 0) {
            sepCharsStr = " ,;";
        }
        sepStrLen = sepCharsStr.length();
        retVec = new Vector<String>();
        strLen = str.length();
        if (strLen <= 0) {
            return retVec;
        }
        sPos = 0;
        do {
            block11: {
                if (!strictFlag) {
                    while (Character.isWhitespace(str.charAt(sPos)) && ++sPos < strLen - 1) {
                    }
                }
                if ((ePos = UtilFns.findCharPos(str, sepCharsStr, sPos)) < sPos) {
                    ePos = strLen;
                }
                subStr = str.substring(sPos, ePos);
                if (!strictFlag) ** GOTO lbl24
                p = subStr.length();
                if (p <= 0) break;
                if (p >= 2 && subStr.charAt(0) == '\"' && subStr.charAt(p - 1) == '\"') break block11;
                return null;
lbl-1000:
                // 1 sources

                {
                    ++ePos;
lbl24:
                    // 2 sources

                    ** while (ePos < strLen - 1 && Character.isWhitespace((char)str.charAt((int)(ePos + 1))))
                }
lbl25:
                // 1 sources

                if ((subStr = subStr.trim()).length() <= 0) break;
            }
            subStr = UtilFns.removeQuoteChars(subStr, true);
            retVec.add(subStr);
        } while ((sPos = ePos + 1) < strLen);
        return retVec;
    }

    public static Vector listStringToVector(String str, char sepChar, boolean trimFlag) {
        int ePos;
        Vector<String> retVec = new Vector<String>();
        if (str == null) {
            return retVec;
        }
        int strLen = str.length();
        if (strLen <= 0) {
            return retVec;
        }
        int sPos = 0;
        do {
            if ((ePos = UtilFns.findCharPos(str, sepChar, sPos)) < sPos) {
                ePos = strLen;
            }
            String subStr = str.substring(sPos, ePos);
            if (trimFlag) {
                subStr = subStr.trim();
            }
            if (subStr.length() <= 0) break;
            if (subStr.charAt(0) == '\"') {
                subStr = UtilFns.removeQuoteChars(subStr, true);
            }
            retVec.add(subStr);
        } while ((sPos = ePos + 1) < strLen);
        return retVec;
    }

    public static String getTableContentsString(Map tableObj, String sepStr) {
        StringBuffer buff = new StringBuffer();
        try {
            Iterator iterObj = tableObj.keySet().iterator();
            if (iterObj.hasNext()) {
                while (true) {
                    buff.append("\"");
                    Object obj = iterObj.next();
                    buff.append(obj);
                    buff.append("\" = \"");
                    buff.append(tableObj.get(obj));
                    buff.append("\"");
                    if (iterObj.hasNext()) {
                        buff.append(sepStr);
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            return "getTableContentsString() error:  " + ex;
        }
        return buff.toString();
    }

    public static String getTableContentsString(Map tableObj) {
        return UtilFns.getTableContentsString(tableObj, ", ");
    }

    public static Vector removeEmptyStrings(Vector vec) {
        if (vec == null) {
            return null;
        }
        Enumeration e = vec.elements();
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if ((!(obj instanceof String) || ((String)obj).length() > 0) && obj != null) continue;
            vec.remove(obj);
        }
        return vec;
    }

    public static String fixStringLen(String inString, int outLen, boolean rightJustFlag, boolean truncateFlag) {
        int len;
        int bLen;
        if (outLen <= 0) {
            return "";
        }
        if (inString == null) {
            inString = "";
        }
        if ((bLen = outLen - (len = inString.length())) <= 0) {
            return truncateFlag ? inString.substring(0, outLen) : inString;
        }
        return rightJustFlag ? UtilFns.getSpacerString(bLen) + inString : inString + UtilFns.getSpacerString(bLen);
    }

    public static String fixStringLen(String inString, int outLen, boolean rightJustFlag) {
        return UtilFns.fixStringLen(inString, outLen, rightJustFlag, true);
    }

    public static String fixStringLen(String inString, int outLen) {
        return UtilFns.fixStringLen(inString, outLen, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSpacerString(int numSpaces) {
        Object object = blanksStringSyncObj;
        synchronized (object) {
            if (numSpaces > blanksStringLen) {
                blanksStringLen = numSpaces;
                char[] charArr = new char[blanksStringLen];
                Arrays.fill(charArr, ' ');
                blanksString = new String(charArr);
            }
            return blanksString.substring(0, numSpaces);
        }
    }

    public static String capFirstLetter(String str) {
        char ch;
        if (str == null || str.length() <= 0 || !Character.isLetter(ch = str.charAt(0)) || !Character.isLowerCase(ch)) {
            return str;
        }
        return Character.toUpperCase(ch) + str.substring(1);
    }

    public static String getPrettyString(String str, boolean allUpperFlag) {
        char ch;
        if (str == null) {
            return null;
        }
        str = str.replace('.', ' ');
        str = str.replace('_', ' ');
        if ((str = str.trim()).length() <= 0) {
            return str;
        }
        char[] chars = str.toCharArray();
        String pretty = new String();
        int i = 0;
        boolean addSpaceFlag = false;
        if (Character.isLowerCase(ch = chars[i++])) {
            ch = Character.toUpperCase(ch);
        }
        pretty = pretty + ch;
        if (str.length() <= 1) {
            return pretty;
        }
        char saveCh = ch;
        char nextCh = chars[i++];
        while (i <= chars.length) {
            char prevCh = saveCh;
            ch = saveCh = nextCh;
            char c = nextCh = i >= chars.length ? (char)'\u0000' : chars[i];
            if (Character.isWhitespace(ch)) {
                addSpaceFlag = true;
            } else if (!Character.isISOControl(ch)) {
                if (addSpaceFlag) {
                    addSpaceFlag = false;
                    pretty = pretty + ' ';
                    if (allUpperFlag) {
                        if (Character.isLowerCase(ch)) {
                            ch = Character.toUpperCase(ch);
                        }
                    } else if (Character.isUpperCase(ch) && Character.isLowerCase(nextCh)) {
                        ch = Character.toLowerCase(ch);
                    }
                } else if (Character.isUpperCase(ch) && (Character.isLowerCase(prevCh) || Character.isLowerCase(nextCh))) {
                    pretty = pretty + ' ';
                    if (!allUpperFlag && Character.isLowerCase(nextCh)) {
                        ch = Character.toLowerCase(ch);
                    }
                }
                pretty = pretty + ch;
            }
            ++i;
        }
        return pretty;
    }

    public static String getPrettyString(String str) {
        return UtilFns.getPrettyString(str, true);
    }

    public static String getLocalHostIP() {
        String localHostStr = "";
        try {
            InetAddress localHostAddr = InetAddress.getLocalHost();
            localHostStr = localHostAddr.getHostAddress();
            InetAddress[] addrArr = InetAddress.getAllByName(localHostAddr.getHostName());
            int pos = 0;
            while (pos < addrArr.length) {
                String str;
                if (addrArr[pos] != null && (str = addrArr[pos].getHostAddress()) != null) {
                    int i = 0;
                    while (i < IGNORE_IP_ADDRS.length) {
                        if (str.startsWith(IGNORE_IP_ADDRS[i])) {
                            str = null;
                            break;
                        }
                        ++i;
                    }
                    if (str != null) {
                        localHostStr = str;
                        break;
                    }
                }
                ++pos;
            }
        }
        catch (Exception ex) {}
        return localHostStr;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isURLAddress(String str) {
        if (str == null || str.length() <= 0) {
            return false;
        }
        p = str.indexOf("://", 1);
        if (p > 0 && p <= 10) ** GOTO lbl8
        return false;
lbl-1000:
        // 1 sources

        {
            if (Character.isLetterOrDigit(str.charAt(p))) continue;
            return false;
lbl8:
            // 2 sources

            ** while (--p >= 0)
        }
lbl9:
        // 1 sources

        return true;
    }

    public static boolean isIPAddress(String str) {
        int ePos;
        int len;
        if (str == null || (len = str.length()) <= 0) {
            return false;
        }
        int sPos = 0;
        int count = 0;
        do {
            int val;
            if ((ePos = str.indexOf(46, sPos)) < 0) {
                ePos = len;
            }
            try {
                val = Integer.parseInt(str.substring(sPos, ePos));
            }
            catch (NumberFormatException ex) {
                return false;
            }
            if (val < 0 || val > 255) {
                return false;
            }
            ++count;
        } while ((sPos = ePos + 1) < len);
        return count == 4;
    }

    public static String replaceSubstring(String dataStr, String oldStr, String newStr) {
        int sPos = dataStr.indexOf(oldStr);
        if (sPos < 0) {
            return dataStr;
        }
        return dataStr.substring(0, sPos) + newStr + dataStr.substring(sPos + oldStr.length());
    }

    public static String[] parseSeparatedSubstrings(String dataStr, String sepStr) {
        Vector<String> vec = new Vector<String>();
        if (dataStr != null && dataStr.length() > 0) {
            int ePos;
            if (sepStr == null || sepStr.length() <= 0) {
                sepStr = ".";
            }
            int sPos = 0;
            int dataStrLen = dataStr.length();
            int sepStrLen = sepStr.length();
            do {
                if ((ePos = dataStr.indexOf(sepStr, sPos)) < 0) {
                    ePos = dataStrLen;
                }
                vec.add(dataStr.substring(sPos, ePos));
            } while ((sPos = ePos + sepStrLen) < dataStrLen);
        }
        return vec.toArray(new String[vec.size()]);
    }

    public static int parseLeadingInt(String numStr) throws NumberFormatException {
        int len;
        if (numStr == null || (len = (numStr = numStr.trim()).length()) <= 0) {
            throw new NumberFormatException("String contains no data");
        }
        int p = 0;
        while (Character.isDigit(numStr.charAt(p)) && ++p < len) {
        }
        if (p == 0) {
            throw new NumberFormatException("String contains no numeric data");
        }
        return Integer.parseInt(numStr.substring(0, p));
    }

    public static Integer[] parseVersionNumbers(String verStr) {
        String[] strArr = UtilFns.parseSeparatedSubstrings(verStr, ".");
        Integer[] integerArr = new Integer[strArr.length];
        int i = 0;
        while (i < strArr.length) {
            try {
                integerArr[i] = new Integer(UtilFns.parseLeadingInt(strArr[i]));
            }
            catch (NumberFormatException ex) {
                integerArr[i] = null;
            }
            ++i;
        }
        return integerArr;
    }

    public static int compareVersionStrings(String ver1Str, String ver2Str) {
        Integer[] integer2Arr;
        Integer[] integer1Arr = UtilFns.parseVersionNumbers(ver1Str);
        int len = integer1Arr.length;
        if (len > (integer2Arr = UtilFns.parseVersionNumbers(ver2Str)).length) {
            len = integer2Arr.length;
        }
        int i = 0;
        while (i < len) {
            if (integer1Arr[i] != null) {
                if (integer2Arr[i] == null) {
                    return 1;
                }
                if (!integer1Arr[i].equals(integer2Arr[i])) {
                    return integer1Arr[i] > integer2Arr[i] ? 1 : -1;
                }
            } else if (integer2Arr[i] != null) {
                return -1;
            }
            ++i;
        }
        if (integer1Arr.length != integer2Arr.length) {
            return integer1Arr.length > integer2Arr.length ? 1 : -1;
        }
        return 0;
    }

    public static String getStackTraceString(Throwable throwObj) {
        String retStr = "";
        StringWriter strWtrObj = new StringWriter();
        try {
            PrintWriter prtWtrObj = new PrintWriter(strWtrObj);
            throwObj.printStackTrace(new PrintWriter(prtWtrObj));
            prtWtrObj.flush();
            retStr = UtilFns.stripTrailingNewline(strWtrObj.toString());
        }
        catch (Exception ex) {}
        return retStr;
    }

    public static String getMemoryInfoStr() {
        try {
            long totalVal = systemRuntimeObj.totalMemory();
            long freeVal = systemRuntimeObj.freeMemory();
            return "total=" + totalVal + ", free=" + freeVal + ", diff=" + (totalVal - freeVal);
        }
        catch (Exception ex) {
            return "Error in 'getMemoryInfoStr()':  " + ex;
        }
    }

    public static void beep() {
        try {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception ex) {}
    }

    static {
        floatNumberFormatObj.setMaximumFractionDigits(8);
        ByteArrayOutputStream btOutStream = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(btOutStream);
        out.println();
        out.flush();
        newline = btOutStream.toString();
        out.close();
        blanksString = "                                                                                ";
        blanksStringLen = blanksString.length();
        blanksStringSyncObj = new Object();
        COLOR_HASH_VALUES = new Integer[]{new Integer(Color.white.getRGB()), new Integer(Color.lightGray.getRGB()), new Integer(Color.gray.getRGB()), new Integer(Color.darkGray.getRGB()), new Integer(Color.black.getRGB()), new Integer(Color.red.getRGB()), new Integer(Color.pink.getRGB()), new Integer(Color.orange.getRGB()), new Integer(Color.yellow.getRGB()), new Integer(Color.green.getRGB()), new Integer(Color.magenta.getRGB()), new Integer(Color.cyan.getRGB()), new Integer(Color.blue.getRGB())};
        COLOR_HASH_STRINGS = new String[]{"white".toLowerCase(), "lightGray".toLowerCase(), "gray".toLowerCase(), "darkGray".toLowerCase(), "black".toLowerCase(), "red".toLowerCase(), "pink".toLowerCase(), "orange".toLowerCase(), "yellow".toLowerCase(), "green".toLowerCase(), "magenta".toLowerCase(), "cyan".toLowerCase(), "blue".toLowerCase()};
        COLOR_DISPLAY_STRINGS = new String[]{UtilFns.getPrettyString("white"), UtilFns.getPrettyString("lightGray"), UtilFns.getPrettyString("gray"), UtilFns.getPrettyString("darkGray"), UtilFns.getPrettyString("black"), UtilFns.getPrettyString("red"), UtilFns.getPrettyString("pink"), UtilFns.getPrettyString("orange"), UtilFns.getPrettyString("yellow"), UtilFns.getPrettyString("green"), UtilFns.getPrettyString("magenta"), UtilFns.getPrettyString("cyan"), UtilFns.getPrettyString("blue")};
        strToClrHashtable = null;
        clrToStrHashtable = null;
        IGNORE_IP_ADDRS = new String[]{"192.168.", "172.16.", "10.", "255.", "127.0.0.0", "127.0.0.1", "0.0.0.0"};
        timeZoneIDs = TimeZone.getAvailableIDs();
        Arrays.sort(timeZoneIDs);
        timeZoneValidator = new CfgPropValidator(timeZoneIDs);
    }
}

