/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.LogFile;
import com.isti.util.UtilFns;

public class ThreadLogger {
    protected final LogFile logObj;
    protected int intervalMSecs = 1000;
    protected StringBuffer stringBufferObj = new StringBuffer();
    protected boolean outputOnChangeFlag = true;
    protected ThreadGroup rootThreadGroupObj = null;
    protected int totalThreadCount = 0;
    protected String errorMessageString = null;
    protected LoggerRunningThread loggerRunningThreadObj = null;
    protected boolean terminateLoggerFlag = false;
    protected static final String newlineStr = UtilFns.newline;
    protected int logLevelVal = 998;
    protected boolean closeOnTerminateFlag = false;

    public ThreadLogger(LogFile logObj, int intervalMSecs) {
        if (logObj == null) {
            throw new NullPointerException();
        }
        this.logObj = logObj;
        this.startLoggerThread(intervalMSecs);
    }

    public ThreadLogger(String logFileName, int intervalMSecs) {
        if (logFileName == null) {
            throw new NullPointerException();
        }
        this.closeOnTerminateFlag = true;
        this.logObj = new LogFile(logFileName, -999, 999);
        this.startLoggerThread(intervalMSecs);
    }

    public ThreadLogger(String logFileName, int intervalMSecs, boolean useDateInFnameFlag) {
        if (logFileName == null) {
            throw new NullPointerException();
        }
        this.closeOnTerminateFlag = true;
        this.logObj = new LogFile(logFileName, -999, 999, false, useDateInFnameFlag);
        this.startLoggerThread(intervalMSecs);
    }

    public ThreadLogger(String logFileName, int intervalMSecs, int maxLogFileAgeDays) {
        if (logFileName == null) {
            throw new NullPointerException();
        }
        this.closeOnTerminateFlag = true;
        this.logObj = new LogFile(logFileName, -999, 999, false, true);
        this.logObj.setMaxLogFileAge(maxLogFileAgeDays);
        this.startLoggerThread(intervalMSecs);
    }

    public ThreadLogger(String logFileName, int intervalMSecs, int maxLogFileAgeDays, int logFileSwitchIntervalDays) {
        if (logFileName == null) {
            throw new NullPointerException();
        }
        this.closeOnTerminateFlag = true;
        this.logObj = new LogFile(logFileName, -999, 999, false, true);
        this.logObj.setMaxLogFileAge(maxLogFileAgeDays);
        this.logObj.setLogFileSwitchIntervalDays(logFileSwitchIntervalDays);
        this.startLoggerThread(intervalMSecs);
    }

    public ThreadLogger() {
        this.logObj = new LogFile(null, 999, 999);
        if (!this.setupRootThreadGroupObj()) {
            System.err.println(this.errorMessageString);
        }
    }

    protected synchronized void startLoggerThread(int intervalMSecs) {
        int n = this.intervalMSecs = intervalMSecs > 0 ? intervalMSecs : 1;
        if (!this.setupRootThreadGroupObj()) {
            this.logObj.error(this.errorMessageString);
            return;
        }
        this.loggerRunningThreadObj = new LoggerRunningThread("ThreadLogger");
        this.loggerRunningThreadObj.start();
    }

    protected synchronized boolean setupRootThreadGroupObj() {
        try {
            this.rootThreadGroupObj = ThreadLogger.getRootThreadGroup();
            if (this.rootThreadGroupObj == null) {
                this.errorMessageString = "Unable to fetch root thread group";
                return false;
            }
        }
        catch (Exception ex) {
            this.errorMessageString = "Error fetching root thread group:  " + ex;
            return false;
        }
        return true;
    }

    public synchronized void setConsoleOutputFlag(boolean flgVal) {
        this.logObj.setConsoleLevel(flgVal ? -999 : 999);
    }

    public synchronized void setOutputOnChangeFlag(boolean flgVal) {
        this.outputOnChangeFlag = flgVal;
    }

    public synchronized void setLogLevelVal(int levelVal) {
        this.logLevelVal = levelVal;
    }

    public synchronized void setCloseLogOnTerminateFlag(boolean flgVal) {
        this.closeOnTerminateFlag = flgVal;
    }

    public synchronized void terminate() {
        this.terminateLoggerFlag = true;
        if (this.loggerRunningThreadObj != null) {
            this.loggerRunningThreadObj.interrupt();
            try {
                this.loggerRunningThreadObj.join(100L);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            this.loggerRunningThreadObj = null;
        }
    }

    public synchronized String getThreadsInfoStr(boolean outChangeFlag) {
        String lastDataStr = outChangeFlag ? this.stringBufferObj.toString() : "";
        int len = this.stringBufferObj.length();
        if (len > 0) {
            this.stringBufferObj.delete(0, len);
        }
        this.totalThreadCount = 0;
        if (!this.fetchThreadsInfo(this.rootThreadGroupObj, "")) {
            return null;
        }
        this.stringBufferObj.append("Total number of threads = " + this.totalThreadCount + newlineStr);
        String newDataStr = this.stringBufferObj.toString();
        if (!outChangeFlag || !newDataStr.equals(lastDataStr)) {
            return this.stringBufferObj.toString();
        }
        return null;
    }

    public String getThreadsInfoStr() {
        return this.getThreadsInfoStr(false);
    }

    public synchronized boolean logThreadsInfo() {
        String infoStr = this.getThreadsInfoStr(this.outputOnChangeFlag);
        if (infoStr != null) {
            this.logObj.println(this.logLevelVal, infoStr);
            return true;
        }
        return this.errorMessageString == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fetchThreadsInfo(ThreadGroup threadGroupObj, String indentStr) {
        try {
            ThreadGroup[] groupArr;
            int numGroups;
            int i;
            ThreadGroup threadGroup = threadGroupObj;
            synchronized (threadGroup) {
                this.stringBufferObj.append(indentStr + ThreadLogger.getThreadGroupInfoStr(threadGroupObj) + newlineStr);
                indentStr = indentStr + "  ";
                int numThreads = threadGroupObj.activeCount();
                if (this.totalThreadCount <= 0) {
                    this.totalThreadCount = numThreads;
                }
                Thread[] threadArr = new Thread[numThreads];
                numThreads = threadGroupObj.enumerate(threadArr, false);
                i = 0;
                while (i < numThreads) {
                    this.stringBufferObj.append(indentStr + ThreadLogger.getThreadInfoStr(threadArr[i]) + newlineStr);
                    ++i;
                }
                numGroups = threadGroupObj.activeGroupCount();
                groupArr = new ThreadGroup[numGroups];
                numGroups = threadGroupObj.enumerate(groupArr, false);
            }
            i = 0;
            while (i < numGroups) {
                if (!this.fetchThreadsInfo(groupArr[i], indentStr)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (Exception ex) {
            this.errorMessageString = "Error logging thread information:  " + ex;
            this.logObj.error(this.errorMessageString);
            return false;
        }
    }

    public synchronized String getErrorMessageString() {
        return this.errorMessageString;
    }

    public synchronized void clearErrorMessageString() {
        this.errorMessageString = null;
    }

    /*
     * WARNING - void declaration
     */
    public static ThreadGroup getRootThreadGroup() {
        ThreadGroup gObj;
        ThreadGroup threadGroupObj = Thread.currentThread().getThreadGroup();
        while ((gObj = threadGroupObj.getParent()) != null) {
            void var1_1;
            threadGroupObj = var1_1;
        }
        return threadGroupObj;
    }

    public static String getThreadInfoStr(Thread threadObj) {
        return "Thread[\"" + threadObj.getName() + "\", priority=" + threadObj.getPriority() + ", daemon=" + threadObj.isDaemon() + ", interrupted=" + threadObj.isInterrupted() + "]";
    }

    public static String getThreadGroupInfoStr(ThreadGroup threadGroupObj) {
        return "ThreadGroup[\"" + threadGroupObj.getName() + "\", numthreads=" + threadGroupObj.activeCount() + ", maxpriority=" + threadGroupObj.getMaxPriority() + ", daemon=" + threadGroupObj.isDaemon() + "]";
    }

    protected class LoggerRunningThread
    extends Thread {
        public LoggerRunningThread(String threadName) {
            super(threadName);
            this.setDaemon(true);
        }

        public LoggerRunningThread() {
            this.setDaemon(true);
        }

        public void run() {
            while (!ThreadLogger.this.terminateLoggerFlag) {
                try {
                    Thread.sleep(ThreadLogger.this.intervalMSecs);
                }
                catch (InterruptedException ex) {
                    if (ThreadLogger.this.terminateLoggerFlag) break;
                }
                if (ThreadLogger.this.logThreadsInfo()) continue;
                ThreadLogger.this.logObj.error("Aborting ThreadLogger");
                ThreadLogger.this.logObj.close();
                return;
            }
            ThreadLogger.this.logObj.println(ThreadLogger.this.logLevelVal, "ThreadLogger terminated OK");
            if (ThreadLogger.this.closeOnTerminateFlag) {
                ThreadLogger.this.logObj.close();
            }
        }
    }
}

