/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FileUtils;
import com.isti.util.LogOutputStream;
import com.isti.util.UtilFns;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class LogFile {
    public static final int ERROR = 3;
    public static final int WARNING = 2;
    public static final int INFO = 1;
    public static final int DEBUG = 0;
    public static final int DEBUG2 = -1;
    public static final int DEBUG3 = -2;
    public static final int DEBUG4 = -3;
    public static final int DEBUG5 = -4;
    public static final int ALL_MSGS = -999;
    public static final int NO_MSGS = 999;
    public static final int NO_LEVEL = 998;
    private static final int MIN_LEVEL_VAL = -999;
    private static final int MAX_LEVEL_VAL = 999;
    public static final String ERROR_STR = "Error";
    public static final String WARNING_STR = "Warning";
    public static final String INFO_STR = "Info";
    public static final String DEBUG_STR = "Debug";
    public static final String DEBUG2_STR = "Debug2";
    public static final String DEBUG3_STR = "Debug3";
    public static final String DEBUG4_STR = "Debug4";
    public static final String DEBUG5_STR = "Debug5";
    public static final String ALL_MSGS_STR = "ALL_MSGS";
    public static final String NO_MSGS_STR = "NO_MSGS";
    public static final boolean DEFAULT_GMT_FLAG = false;
    public static final boolean DEFAULT_USE_DATE_IN_FNAME_FLAG = false;
    public static final String FNAME_DATE_SEPSTR = "_";
    private String logFileName = null;
    private PrintWriter logWriter = null;
    private final String baseFileName;
    private int logFileLevel = 999;
    private int consoleLevel = 999;
    private final DateFormat fileDateFormatter = DateFormat.getDateTimeInstance();
    private final DateFormat longDateFormatter = DateFormat.getDateTimeInstance();
    private final DateFormat shortDateFormatter = DateFormat.getDateTimeInstance();
    private static LogFile globalLog = null;
    private final boolean useDateInFnameFlag;
    private final File directoryObj;
    private String logFileFilterStr = "*.log";
    private int maxLogFileAge = 0;
    private long logFileStartTime = 0L;
    private long logFileSwitchIntervalMS = 86400000L;
    private static Vector levelNamesVector = null;
    private static String[] levelNamesArray = null;

    public LogFile(String fName, int logFileLevel, int consoleLevel, boolean gmtFlag, boolean useDateInFnameFlag) {
        this.baseFileName = fName;
        this.consoleLevel = consoleLevel;
        this.useDateInFnameFlag = useDateInFnameFlag;
        if (logFileLevel >= 999 || this.baseFileName == null || this.baseFileName.length() < 1) {
            this.directoryObj = null;
            return;
        }
        this.directoryObj = new File(this.baseFileName).getParentFile();
        LogFile.setDateFormatPattern(this.fileDateFormatter, "yyyyMMdd");
        LogFile.setDateFormatPattern(this.shortDateFormatter, "MMM dd yyyy HH:mm:ss");
        LogFile.setDateFormatPattern(this.longDateFormatter, "MMMM dd, yyyy HH:mm:ss z");
        if (gmtFlag) {
            TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
            this.fileDateFormatter.setTimeZone(gmtTimeZone);
            this.shortDateFormatter.setTimeZone(gmtTimeZone);
            this.longDateFormatter.setTimeZone(gmtTimeZone);
        }
        this.logFileFilterStr = FileUtils.addStrToFileName(this.baseFileName, "_*");
        this.determineLogFileName(new Date());
        this.logFileLevel = logFileLevel;
    }

    public LogFile(String fName, int logFileLevel, int consoleLevel, boolean gmtFlag) {
        this(fName, logFileLevel, consoleLevel, gmtFlag, false);
    }

    public LogFile(String fName, int logFileLevel, int consoleLevel) {
        this(fName, logFileLevel, consoleLevel, false);
    }

    public int getMaxLogFileAge() {
        return this.maxLogFileAge;
    }

    public synchronized void setMaxLogFileAge(int maxAge) {
        this.maxLogFileAge = maxAge;
        if (this.useDateInFnameFlag) {
            this.deleteOldLogFiles();
        }
    }

    public synchronized void setLogFileSwitchIntervalDays(int numDays) {
        this.logFileSwitchIntervalMS = (long)numDays * 86400000L;
    }

    private void determineLogFileName(Date dateObj) {
        long currentTimeVal = System.currentTimeMillis();
        if (this.logFileStartTime <= 0L || this.useDateInFnameFlag && this.logFileSwitchIntervalMS > 0L && currentTimeVal - this.logFileStartTime >= this.logFileSwitchIntervalMS) {
            String newLogFileName;
            if (this.useDateInFnameFlag) {
                Calendar calObj = Calendar.getInstance(this.shortDateFormatter.getTimeZone());
                calObj.set(11, 0);
                calObj.set(12, 0);
                calObj.set(13, 0);
                calObj.set(14, 0);
                this.logFileStartTime = calObj.getTime().getTime();
            } else {
                this.logFileStartTime = currentTimeVal;
            }
            if (this.useDateInFnameFlag) {
                String dateText = FNAME_DATE_SEPSTR + this.fileDateFormatter.format(dateObj);
                newLogFileName = FileUtils.addStrToFileName(this.baseFileName, dateText);
            } else {
                newLogFileName = this.baseFileName;
            }
            if (!newLogFileName.equals(this.logFileName)) {
                boolean writeContinuedFrom = false;
                if (this.logWriter != null) {
                    writeContinuedFrom = true;
                    this.logWriter.println("Log file continues in \"" + newLogFileName + "\"");
                }
                this.closeLogFile();
                String oldLogFileName = this.logFileName;
                this.logFileName = newLogFileName;
                this.createLogFile(dateObj);
                if (writeContinuedFrom && this.logWriter != null) {
                    this.logWriter.println("  continued from \"" + oldLogFileName + "\"");
                }
                this.deleteOldLogFiles();
            }
        }
    }

    private void deleteOldLogFiles() {
        if (this.directoryObj != null && this.maxLogFileAge > 0) {
            FileUtils.deleteOldFiles(this.directoryObj, this.maxLogFileAge, this.logFileFilterStr);
        }
    }

    private void closeLogFile() {
        if (this.logWriter != null) {
            this.logWriter.close();
            this.logWriter = null;
        }
    }

    private void createLogFile(Date dateObj) {
        try {
            FileUtils.createParentDirs(this.logFileName);
            this.logWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.logFileName, true)), true);
            try {
                this.logWriter.println();
                this.logWriter.println("Log file opened " + this.longDateFormatter.format(dateObj));
                if (this.logWriter.checkError()) {
                    System.err.println("Error writing to log file \"" + this.logFileName + "\"");
                    this.logFileName = null;
                }
            }
            catch (Exception ex) {
                System.err.println("Exception writing to log file \"" + this.logFileName + "\":  " + ex);
                this.logFileName = null;
            }
        }
        catch (IOException ex) {
            System.err.println("Exception opening log file \"" + ex.getMessage() + "\":  " + ex);
            this.logFileName = null;
        }
        if (this.logFileName == null) {
            this.closeLogFile();
        }
    }

    private static void setDateFormatPattern(DateFormat formatObj, String patternStr) {
        try {
            if (formatObj instanceof SimpleDateFormat && patternStr != null) {
                ((SimpleDateFormat)formatObj).applyPattern(patternStr);
            }
        }
        catch (Exception ex) {}
    }

    public synchronized boolean println(int level, String str) {
        String levelStr;
        String string = levelStr = level < 998 ? "[" + LogFile.getLevelString(level) + "] " : "";
        if (level >= this.consoleLevel) {
            System.out.println(levelStr + str);
        }
        if (level < this.logFileLevel) {
            return true;
        }
        if (this.logWriter == null) {
            return false;
        }
        try {
            Date dateObj = new Date();
            this.println(dateObj, this.getDateFormat().format(dateObj) + ":  " + levelStr + str);
            if (this.logWriter.checkError()) {
                this.logWriter.close();
                this.logWriter = null;
                System.err.println("Error writing to log file \"" + this.logFileName + "\"");
            }
        }
        catch (Exception ex) {
            this.logWriter.close();
            this.logWriter = null;
        }
        return this.logWriter != null;
    }

    public boolean println(String str) {
        return this.println(998, str);
    }

    private void println(Date dateObj, String str) {
        this.determineLogFileName(dateObj);
        this.logWriter.println(str);
    }

    public boolean error(String str) {
        return this.println(3, str);
    }

    public boolean warning(String str) {
        return this.println(2, str);
    }

    public boolean info(String str) {
        return this.println(1, str);
    }

    public boolean debug(String str) {
        return this.println(0, str);
    }

    public boolean debug2(String str) {
        return this.println(-1, str);
    }

    public boolean debug3(String str) {
        return this.println(-2, str);
    }

    public boolean debug4(String str) {
        return this.println(-3, str);
    }

    public boolean debug5(String str) {
        return this.println(-4, str);
    }

    public synchronized void close() {
        if (this.logWriter != null) {
            Date dateObj = new Date();
            this.println(dateObj, "Log file closed " + this.longDateFormatter.format(dateObj));
            this.logWriter.close();
            this.logWriter = null;
        }
    }

    public LogOutputStream getLogOutputStream() {
        return new LogOutputStream(this);
    }

    public String getFileName() {
        return this.logFileName;
    }

    public boolean isOpen() {
        return this.logWriter != null;
    }

    public int getConsoleLevel() {
        return this.consoleLevel;
    }

    public synchronized void setConsoleLevel(int level) {
        this.consoleLevel = level;
    }

    public int getLogFileLevel() {
        return this.logFileLevel;
    }

    public synchronized void setLogFileLevel(int level) {
        this.logFileLevel = level;
    }

    public static String getLevelString(int level) {
        String retStr = LogFile.getLevelStringNull(level);
        return retStr != null ? retStr : "level" + level;
    }

    public static String getLevelStringNull(int level) {
        switch (level) {
            case 3: {
                return ERROR_STR;
            }
            case 2: {
                return WARNING_STR;
            }
            case 1: {
                return INFO_STR;
            }
            case 0: {
                return DEBUG_STR;
            }
            case -1: {
                return DEBUG2_STR;
            }
            case -2: {
                return DEBUG3_STR;
            }
            case -3: {
                return DEBUG4_STR;
            }
            case -4: {
                return DEBUG5_STR;
            }
            case -999: {
                return ALL_MSGS_STR;
            }
            case 999: {
                return NO_MSGS_STR;
            }
        }
        return null;
    }

    public static Integer levelStringToValue(String str) {
        int val;
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).equalsIgnoreCase(ERROR_STR)) {
            val = 3;
        } else if (str.equalsIgnoreCase(WARNING_STR)) {
            val = 2;
        } else if (str.equalsIgnoreCase(INFO_STR)) {
            val = 1;
        } else if (str.equalsIgnoreCase(DEBUG_STR)) {
            val = 0;
        } else if (str.equalsIgnoreCase(DEBUG2_STR)) {
            val = -1;
        } else if (str.equalsIgnoreCase(DEBUG3_STR)) {
            val = -2;
        } else if (str.equalsIgnoreCase(DEBUG4_STR)) {
            val = -3;
        } else if (str.equalsIgnoreCase(DEBUG5_STR)) {
            val = -4;
        } else if (str.equalsIgnoreCase(ALL_MSGS_STR)) {
            val = -999;
        } else if (str.equalsIgnoreCase(NO_MSGS_STR)) {
            val = 999;
        } else {
            return null;
        }
        return new Integer(val);
    }

    public static Vector getLevelNamesVector() {
        if (levelNamesVector == null) {
            levelNamesVector = new Vector();
            int l = 999;
            while (l >= -999) {
                String str;
                if (l != 998 && (str = LogFile.getLevelStringNull(l)) != null) {
                    levelNamesVector.add(str);
                }
                --l;
            }
        }
        return levelNamesVector;
    }

    public static String[] getLevelNamesArray() {
        if (levelNamesArray == null) {
            Vector vec = LogFile.getLevelNamesVector();
            levelNamesArray = vec.toArray(new String[vec.size()]);
        }
        return levelNamesArray;
    }

    public static String getLevelNamesDisplayStr() {
        return UtilFns.enumToQuotedStrings(LogFile.getLevelNamesVector().elements());
    }

    public static LogFile initGlobalLogObj(String fName, int logFileLevel, int consoleLevel, boolean gmtFlag, boolean useDateInFnameFlag) {
        globalLog = new LogFile(fName, logFileLevel, consoleLevel, gmtFlag, useDateInFnameFlag);
        return globalLog;
    }

    public static LogFile initGlobalLogObj(String fName, int logFileLevel, int consoleLevel, boolean gmtFlag) {
        return LogFile.initGlobalLogObj(fName, logFileLevel, consoleLevel, gmtFlag, false);
    }

    public static LogFile initGlobalLogObj(String fName, int logFileLevel, int consoleLevel) {
        return LogFile.initGlobalLogObj(fName, logFileLevel, consoleLevel, false);
    }

    public static LogFile getGlobalLogObj() {
        if (globalLog != null) {
            return globalLog;
        }
        return LogFile.initGlobalLogObj("default.log", 1, 1);
    }

    public DateFormat getDateFormat() {
        return this.shortDateFormatter;
    }
}

