/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.applet.Applet;
import java.applet.AppletContext;
import java.net.MalformedURLException;
import java.net.URL;

public class LaunchBrowser {
    public static final int NON_WINDOWS = 0;
    public static final int WINDOWS_98 = 1;
    public static final int WINDOWS_XP = 2;
    public static final int MACINTOSH = 3;
    protected static final String[] osSelStringsArr = new String[]{"Non-Windows", "Windows95/98", "Windows2000/XP", "Macintosh"};
    protected final AppletContext appletContextObj;
    protected int osSelectVal = 0;
    protected static String osNamePropString = null;
    protected String errorMessage = null;
    protected final String[] osPrefixArr = new String[]{"netscape ", "start \"", "cmd /C \"start ", "/usr/bin/open "};
    protected final String[] osSuffixArr = new String[]{"", "\"", "\"", ""};
    protected String[] cmdPrefixArr = null;
    protected String[] cmdSuffixArr = null;
    protected int firstCmdArrIdx = 1;

    public LaunchBrowser() {
        this(LaunchBrowser.determineOSType());
    }

    public LaunchBrowser(String cmdPrefixStr) {
        this(LaunchBrowser.determineOSType());
        this.setLaunchCommand(cmdPrefixStr);
    }

    public LaunchBrowser(String cmdPrefixStr, String cmdSuffixStr) {
        this(LaunchBrowser.determineOSType());
        this.setLaunchCommand(cmdPrefixStr, cmdSuffixStr);
    }

    public LaunchBrowser(int selVal) {
        this.appletContextObj = null;
        if (!this.setOSType(selVal)) {
            this.setOSType(0);
        }
    }

    public LaunchBrowser(int selVal, String cmdPrefixStr) {
        this(selVal);
        this.setLaunchCommand(cmdPrefixStr);
    }

    public LaunchBrowser(int selVal, String cmdPrefixStr, String cmdSuffixStr) {
        this(selVal);
        this.setLaunchCommand(cmdPrefixStr, cmdSuffixStr);
    }

    public LaunchBrowser(AppletContext appletContextObj) {
        this.appletContextObj = appletContextObj;
    }

    public LaunchBrowser(Applet appletObj) {
        this.appletContextObj = appletObj != null ? appletObj.getAppletContext() : null;
    }

    public boolean setOSType(int selVal) {
        int[] idxValArr = new int[this.osPrefixArr.length];
        switch (selVal) {
            case 0: {
                idxValArr[0] = 0;
                idxValArr[1] = 1;
                idxValArr[2] = 2;
                idxValArr[3] = 3;
                break;
            }
            case 1: {
                idxValArr[0] = 1;
                idxValArr[1] = 2;
                idxValArr[2] = 0;
                idxValArr[3] = 3;
                break;
            }
            case 2: {
                idxValArr[0] = 2;
                idxValArr[1] = 1;
                idxValArr[2] = 0;
                idxValArr[3] = 3;
                break;
            }
            case 3: {
                idxValArr[0] = 3;
                idxValArr[1] = 0;
                idxValArr[2] = 1;
                idxValArr[3] = 2;
                break;
            }
            default: {
                return false;
            }
        }
        this.osSelectVal = selVal;
        if (this.cmdPrefixArr == null) {
            this.cmdPrefixArr = new String[this.osPrefixArr.length + 1];
            this.cmdPrefixArr[0] = this.osPrefixArr[idxValArr[0]];
        }
        if (this.cmdSuffixArr == null) {
            this.cmdSuffixArr = new String[this.osPrefixArr.length + 1];
            this.cmdSuffixArr[0] = this.osSuffixArr[idxValArr[0]];
        }
        int i = 0;
        while (i < this.osPrefixArr.length) {
            this.cmdPrefixArr[i + 1] = this.osPrefixArr[idxValArr[i]];
            this.cmdSuffixArr[i + 1] = this.osSuffixArr[idxValArr[i]];
            ++i;
        }
        return true;
    }

    public void setLaunchCommand(String cmdPrefixStr, String cmdSuffixStr, boolean addSpaceFlag) {
        int len;
        if (cmdPrefixStr == null && cmdSuffixStr == null) {
            this.firstCmdArrIdx = 1;
            return;
        }
        if (cmdPrefixStr == null) {
            cmdPrefixStr = "";
        }
        if (cmdSuffixStr == null) {
            cmdSuffixStr = "";
        }
        if (!(this.cmdPrefixArr != null && cmdSuffixStr != null || this.setOSType(0))) {
            return;
        }
        if (addSpaceFlag && (len = cmdPrefixStr.length()) > 0 && Character.isUnicodeIdentifierPart(cmdPrefixStr.charAt(len - 1))) {
            cmdPrefixStr = cmdPrefixStr + " ";
        }
        this.cmdPrefixArr[0] = cmdPrefixStr;
        this.cmdSuffixArr[0] = cmdSuffixStr;
        this.firstCmdArrIdx = 0;
    }

    public void setLaunchCommand(String cmdPrefixStr, String cmdSuffixStr) {
        this.setLaunchCommand(cmdPrefixStr, cmdSuffixStr, true);
    }

    public void setLaunchCommand(String cmdPrefixStr, boolean addSpaceFlag) {
        this.setLaunchCommand(cmdPrefixStr, null, addSpaceFlag);
    }

    public void setLaunchCommand(String cmdPrefixStr) {
        this.setLaunchCommand(cmdPrefixStr, null, true);
    }

    public boolean showApplicationURL(String urlStr) {
        if (this.cmdPrefixArr != null && this.cmdSuffixArr != null) {
            String errStr = null;
            int i = this.firstCmdArrIdx;
            while (i < this.osPrefixArr.length) {
                String cmdStr = this.cmdPrefixArr[i] + urlStr + this.cmdSuffixArr[i];
                try {
                    Runtime.getRuntime().exec(cmdStr);
                    return true;
                }
                catch (Exception ex) {
                    if (errStr == null) {
                        errStr = "Runtime.exec('" + cmdStr + "') exception:  " + ex;
                    }
                    ++i;
                }
            }
            this.setErrorMessage(errStr);
        } else {
            this.setErrorMessage("Invalid application configuration");
        }
        return false;
    }

    public String getPrefApplicationLaunchCmd(String urlStr) {
        return this.cmdPrefixArr[this.firstCmdArrIdx] + urlStr + this.cmdSuffixArr[this.firstCmdArrIdx];
    }

    public boolean showAppletURL(String urlStr, String titleStr) {
        if (this.appletContextObj != null) {
            try {
                int len;
                URL urlObj = new URL(urlStr);
                if (titleStr != null && (len = titleStr.length()) > 0) {
                    StringBuffer buff = new StringBuffer(titleStr);
                    boolean changedFlag = false;
                    int p = 0;
                    while (p < len) {
                        if (!Character.isLetterOrDigit(buff.charAt(p))) {
                            buff.setCharAt(p, '_');
                            changedFlag = true;
                        }
                        ++p;
                    }
                    if (changedFlag) {
                        titleStr = buff.toString();
                    }
                } else {
                    titleStr = "_blank";
                }
                this.appletContextObj.showDocument(urlObj, titleStr);
                return true;
            }
            catch (MalformedURLException ex) {
                this.setErrorMessage("Unable to interpret URL:  " + urlStr);
            }
            catch (Exception ex) {
                this.setErrorMessage("Unable to display URL:  " + urlStr);
            }
        } else {
            this.setErrorMessage("Invalid applet context (null)");
        }
        return false;
    }

    public boolean showAppletURL(String urlStr) {
        return this.showAppletURL(urlStr, null);
    }

    public boolean showURL(String urlStr, String titleStr) {
        return this.appletContextObj != null ? this.showAppletURL(urlStr, titleStr) : this.showApplicationURL(urlStr);
    }

    public boolean showURL(String urlStr) {
        return this.appletContextObj != null ? this.showAppletURL(urlStr, null) : this.showApplicationURL(urlStr);
    }

    protected void setErrorMessage(String str) {
        if (this.errorMessage == null) {
            this.errorMessage = str;
        }
    }

    public boolean getErrorFlag() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage != null ? this.errorMessage : "No error";
    }

    public void clearErrorMessage() {
        this.errorMessage = null;
    }

    public int getOSSelectVal() {
        return this.osSelectVal;
    }

    public String getOSSelectString() {
        return this.osSelectVal >= 0 && this.osSelectVal < osSelStringsArr.length ? osSelStringsArr[this.osSelectVal] : "Unknown";
    }

    public String getOsNamePropString() {
        if (osNamePropString == null) {
            LaunchBrowser.determineOSType();
        }
        return osNamePropString;
    }

    public static int determineOSType() {
        osNamePropString = "";
        try {
            osNamePropString = System.getProperty("os.name", "");
            String osNameLwrCase = osNamePropString.toLowerCase();
            if (osNameLwrCase.indexOf("windows") >= 0) {
                return osNamePropString.indexOf("windows 9") >= 0 ? 1 : 2;
            }
            if (osNameLwrCase.startsWith("mac")) {
                return 3;
            }
        }
        catch (Exception ex) {}
        return 0;
    }
}

