/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FileUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.apache.xerces.impl.dv.dtd.DTDDVFactoryImpl;
import org.apache.xerces.impl.dv.dtd.XML11DTDDVFactoryImpl;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.XML11Configuration;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class IstiXmlUtils {
    private static final SAXParser dummySAXParser = null;
    private static final XML11Configuration dummyXml11Obj = null;
    private static final DTDDVFactoryImpl dummyDTDDVFactObj = null;
    private static final XML11DTDDVFactoryImpl dummyxDTDDVFactObj = null;
    private String errorMessage = null;
    protected Element rootElement = null;
    public static final String XML_FILE_EXTENSION = ".xml";
    public static final SAXBuilder xmlBuilderObj = new SAXBuilder(false);
    public static final XMLOutputter xmlStrOutputterObj = new XMLOutputter();
    public static final XMLOutputter xmlFileOutputterObj = new XMLOutputter();

    public static String addXmlFileExtension(String fileName) {
        if (!fileName.toLowerCase().endsWith(XML_FILE_EXTENSION)) {
            fileName = fileName + XML_FILE_EXTENSION;
        }
        return fileName;
    }

    protected Object getComponentForClass(String className) {
        block6: {
            try {
                Class<?> classForName = Class.forName(className);
                if (classForName == null) break block6;
                try {
                    return classForName.newInstance();
                }
                catch (InstantiationException e) {
                    this.setErrorMessage("Cannot instantiate class  " + className + ": " + e);
                }
                catch (IllegalAccessException e) {
                    this.setErrorMessage("Cannot instantiate class " + className + ": " + e);
                }
            }
            catch (ClassNotFoundException e) {
                this.setErrorMessage("Cannot get class for " + className + ": " + e);
            }
            catch (Exception e) {
                this.setErrorMessage("Error getting class for " + className + ": " + e);
            }
        }
        return null;
    }

    protected Element findElement(String attribute, String value) {
        return this.findElement(attribute, value, this.rootElement);
    }

    protected Element findElement(String attribute, String value, Element element) {
        if (attribute == null || value == null || element == null) {
            return null;
        }
        String attributeValue = element.getAttributeValue(attribute);
        if (attributeValue != null && attributeValue.equals(value)) {
            return element;
        }
        List childrenList = element.getChildren();
        if (childrenList == null || childrenList.size() <= 0) {
            return null;
        }
        Iterator iterObj = childrenList.iterator();
        while (iterObj.hasNext()) {
            Object obj = iterObj.next();
            if (!(obj instanceof Element)) {
                return null;
            }
            Element childElement = this.findElement(attribute, value, (Element)obj);
            if (childElement == null) continue;
            return childElement;
        }
        return null;
    }

    public Element getRootElement() {
        return this.rootElement;
    }

    public boolean loadFile(String fileName, String rootElementName) {
        BufferedReader rdrObj = FileUtils.fileMultiOpen(fileName);
        if (rdrObj == null) {
            this.setErrorMessage("Unable to open XML data file \"" + fileName + "\"");
            return false;
        }
        return this.loadStream(rdrObj, rootElementName, fileName);
    }

    public boolean loadStream(Reader rdrObj, String rootElementName, String fileName) {
        Element element;
        try {
            Document documentObj = xmlBuilderObj.build(rdrObj);
            element = documentObj.getRootElement();
        }
        catch (Exception ex) {
            Throwable tObj;
            Exception throwObj;
            Throwable throwable = throwObj = ex instanceof JDOMException && (tObj = ((JDOMException)ex).getCause()) != null ? tObj : ex;
            if (fileName != null) {
                this.setErrorMessage("Error loading XML data from file \"" + fileName + "\":  " + throwObj);
            } else {
                this.setErrorMessage("Error loading XML data:  " + throwObj);
            }
            return false;
        }
        if (element == null || !element.getName().equalsIgnoreCase(rootElementName)) {
            if (fileName != null) {
                this.setErrorMessage("Root element \"" + rootElementName + "\" not found in file \"" + fileName + "\"");
            } else {
                this.setErrorMessage("Root element \"" + rootElementName + "\" not found in XML data");
            }
            return false;
        }
        this.rootElement = element;
        return true;
    }

    public boolean loadStream(Reader rdrObj, String rootElementName) {
        return this.loadStream(rdrObj, rootElementName, null);
    }

    public boolean loadStream(InputStream stmObj, String rootElementName, String fileName) {
        return this.loadStream(new InputStreamReader(stmObj), rootElementName, fileName);
    }

    public boolean loadStream(InputStream stmObj, String rootElementName) {
        return this.loadStream(new InputStreamReader(stmObj), rootElementName, null);
    }

    public boolean saveToFile(String fileName, Element elemObj) {
        FileUtils.createParentDirs(fileName);
        try {
            BufferedWriter wtrObj = new BufferedWriter(new FileWriter(fileName));
            IstiXmlUtils.saveToStream(wtrObj, elemObj);
            wtrObj.close();
            return true;
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.toString());
            return false;
        }
    }

    protected void setErrorMessage(String str) {
        if (this.errorMessage == null) {
            this.errorMessage = str;
        }
    }

    public boolean getErrorFlag() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage != null ? this.errorMessage : "No error";
    }

    public void clearErrorMessage() {
        this.errorMessage = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String elementToString(Element xmlMsgObj) throws IOException {
        StringWriter wtrObj = new StringWriter();
        XMLOutputter xMLOutputter = xmlStrOutputterObj;
        synchronized (xMLOutputter) {
            xmlStrOutputterObj.output(xmlMsgObj, (Writer)wtrObj);
        }
        return wtrObj.toString();
    }

    public static Element stringToElement(String xmlStr) throws JDOMException {
        SAXBuilder sAXBuilder = xmlBuilderObj;
        synchronized (sAXBuilder) {
            try {
                return xmlBuilderObj.build((Reader)new StringReader(xmlStr)).getRootElement();
            }
            catch (Exception ex) {
                throw new JDOMException("I/O error while reading XML string data", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToStream(Writer wtrObj, Element elemObj) throws IOException {
        XMLOutputter xMLOutputter = xmlFileOutputterObj;
        synchronized (xMLOutputter) {
            xmlFileOutputterObj.output(elemObj, wtrObj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToStream(OutputStream stmObj, Element elemObj) throws IOException {
        XMLOutputter xMLOutputter = xmlFileOutputterObj;
        synchronized (xMLOutputter) {
            xmlFileOutputterObj.output(elemObj, stmObj);
        }
    }

    static {
        xmlFileOutputterObj.setNewlines(true);
    }
}

