/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.UtilFns;

public class IstiVersion
implements Comparable {
    private static final int MAJOR = 0;
    private static final int MINOR = 1;
    private static final int PATCH = 2;
    private static final int BUILD = 3;
    private static final int MIN_INDEX = 4;
    public static final String BETA_STRING = "beta";
    public static final String DIVIDER = ".";
    private final boolean beta;
    private final int[] versions;
    private final String versionString;

    public IstiVersion(String string) {
        this(IstiVersion.getArgs(string), IstiVersion.isBeta(string));
    }

    public IstiVersion(int n, int n2) {
        this(n, n2, 0);
    }

    public IstiVersion(String string, String string2) {
        this(string, string2, null);
    }

    public IstiVersion(int n, int n2, int n3) {
        this(n, n2, n3, 0);
    }

    public IstiVersion(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public IstiVersion(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, false);
    }

    public IstiVersion(int n, int n2, int n3, int n4, boolean bl) {
        this.beta = bl;
        this.versions = new int[4];
        this.versions[0] = n;
        this.versions[1] = n2;
        this.versions[2] = n3;
        this.versions[3] = n4;
        this.versionString = this.createVersionString();
    }

    public IstiVersion(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, false);
    }

    public IstiVersion(String string, String string2, String string3, String string4, boolean bl) {
        this(IstiVersion.parseInt(string), IstiVersion.parseInt(string2), IstiVersion.parseInt(string3), IstiVersion.parseInt(string4), bl);
    }

    public IstiVersion(int[] nArray) {
        this(nArray, false);
    }

    public IstiVersion(int[] nArray, boolean bl) {
        this.beta = bl;
        if (nArray.length >= 4) {
            this.versions = nArray;
        } else {
            this.versions = new int[4];
            int n = 0;
            while (n < nArray.length) {
                this.versions[n] = nArray[n];
                ++n;
            }
            while (n < 4) {
                this.versions[n] = 0;
                ++n;
            }
        }
        this.versionString = this.createVersionString();
    }

    public IstiVersion(String[] stringArray) {
        this(stringArray, false);
    }

    public IstiVersion(String[] stringArray, boolean bl) {
        this(IstiVersion.getArgs(stringArray), bl);
    }

    protected String createVersionString() {
        String string = this.getMajor() + DIVIDER + this.getMinor() + DIVIDER + this.getPatch() + DIVIDER + this.getBuild();
        if (this.isBeta()) {
            string = string + BETA_STRING;
        }
        return string;
    }

    protected static int[] getArgs(String string) {
        String[] stringArray = UtilFns.parseSeparatedSubstrings(string, " ");
        int n = stringArray.length - 1;
        while (n >= 0) {
            if (Character.isDigit(stringArray[n].charAt(0))) break;
            --n;
        }
        if (n < 0) {
            return new int[0];
        }
        String string2 = stringArray[n];
        String[] stringArray2 = UtilFns.parseSeparatedSubstrings(string2, DIVIDER);
        int[] nArray = new int[stringArray2.length];
        n = 0;
        while (n < stringArray2.length) {
            nArray[n] = IstiVersion.parseInt(stringArray2[n]);
            ++n;
        }
        return nArray;
    }

    protected static int[] getArgs(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        int n = stringArray.length - 1;
        while (n >= 0) {
            nArray[n] = IstiVersion.parseInt(stringArray[n]);
            --n;
        }
        return nArray;
    }

    protected static boolean isBeta(String string) {
        return string.toLowerCase().indexOf(BETA_STRING) >= 0;
    }

    protected static int parseInt(String string) {
        if (string != null) {
            try {
                return UtilFns.parseLeadingInt(string);
            }
            catch (Exception exception) {
            }
        }
        return 0;
    }

    public int compareTo(Object object) {
        return this.compareTo((IstiVersion)object);
    }

    public int compareTo(IstiVersion istiVersion) {
        int n;
        int n2;
        int n3 = this.versions.length;
        int n4 = istiVersion.versions.length;
        int n5 = Math.min(n3, n4);
        int n6 = 0;
        while (n6 < n5) {
            n2 = this.versions[n6];
            n = istiVersion.versions[n6];
            if (n2 != n) {
                if (n2 < n) {
                    return -1;
                }
                return 1;
            }
            ++n6;
        }
        if (n3 != n4) {
            if (n3 < n4) {
                n2 = n5;
                while (n2 < n4) {
                    if (istiVersion.versions[n2] > 0) {
                        return -1;
                    }
                    ++n2;
                }
            } else {
                n = n5;
                while (n < n3) {
                    if (this.versions[n] > 0) {
                        return 1;
                    }
                    ++n;
                }
            }
        }
        if (istiVersion.isBeta()) {
            if (!this.isBeta()) {
                return 1;
            }
        } else if (this.isBeta()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        return object instanceof IstiVersion && this.equals((IstiVersion)object);
    }

    public boolean equals(IstiVersion istiVersion) {
        return istiVersion != null && this.compareTo(istiVersion) == 0;
    }

    public int getBuild() {
        return this.versions[3];
    }

    int getMajor() {
        return this.versions[0];
    }

    public int getMinor() {
        return this.versions[1];
    }

    public int getPatch() {
        return this.versions[2];
    }

    public boolean isBeta() {
        return this.beta;
    }

    public String toString() {
        return this.versionString;
    }
}

