/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FifoHashtable;
import com.isti.util.LogFile;
import java.util.Vector;

public class IstiTimeObjectCache {
    protected final LogFile logObj;
    protected final boolean useDataStrKeyFlag;
    protected long tolerance = 0L;
    protected final long defaultRemoveAge;
    protected final FifoHashtable objectCache = new FifoHashtable();

    public IstiTimeObjectCache(LogFile logObj, long tolerance, long removeAge, boolean useDataStrKeyFlag) {
        this.logObj = logObj;
        this.tolerance = tolerance;
        this.defaultRemoveAge = removeAge;
        this.useDataStrKeyFlag = useDataStrKeyFlag;
    }

    public IstiTimeObjectCache(LogFile logObj, long tolerance, long removeAge) {
        this.logObj = logObj;
        this.tolerance = tolerance;
        this.defaultRemoveAge = removeAge;
        this.useDataStrKeyFlag = true;
    }

    public IstiTimeObjectCache(LogFile logObj, long tolerance, boolean useDataStrKeyFlag) {
        this(logObj, tolerance, 0L, useDataStrKeyFlag);
    }

    public IstiTimeObjectCache(LogFile logObj, long tolerance) {
        this(logObj, tolerance, 0L, true);
    }

    public void add(long timeGenerated, Object dataObj, String dataStr) {
        this.add(new BasicTimeObjectEntry(timeGenerated, dataObj, dataStr));
    }

    public Vector getAllObjects() {
        return this.objectCache.getValuesVector();
    }

    public LogFile getLogFile() {
        return this.logObj;
    }

    public Vector getNewerObjects(long time) {
        return this.getObjects(time, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getObjects(long beginTime, long endTime) {
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            if (beginTime > 0L) {
                beginTime -= this.tolerance;
            }
            if (endTime > 0L) {
                endTime += this.tolerance;
            }
            return this.subListVector(beginTime, endTime);
        }
    }

    public Vector getOlderObjects(long time) {
        return this.getObjects(0L, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOldObjects(long removeAge) {
        int cacheSize;
        if (removeAge <= 0L) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long removeTime = currentTime - removeAge;
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            Vector listObj = this.subListVector(0L, removeTime);
            if (listObj.size() == 0) {
                return;
            }
            this.objectCache.removeAllValues(listObj);
            cacheSize = this.objectCache.size();
        }
        if (this.logObj != null) {
            this.logObj.debug3(this.getLogPrefixString() + " remove: size is " + cacheSize);
        }
    }

    public void removeOldObjects() {
        this.removeOldObjects(this.defaultRemoveAge);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void add(TimeObjectEntry entryObj) {
        int cacheSize;
        FifoHashtable fifoHashtable = this.objectCache;
        synchronized (fifoHashtable) {
            this.objectCache.put(this.useDataStrKeyFlag ? entryObj.getDataStr() : new Object(), entryObj);
            cacheSize = this.objectCache.size();
        }
        if (this.logObj != null) {
            this.logObj.debug3(this.getLogPrefixString() + " add: size is " + cacheSize);
        }
    }

    public boolean containsKey(Object keyObj) {
        return this.objectCache.containsKey(keyObj);
    }

    protected String getLogPrefixString() {
        return "IstiTimeObjectCache";
    }

    protected TimeObjectEntry getObject(int index) {
        return (TimeObjectEntry)this.objectCache.elementAt(index);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Vector subListVector(long beginTime, long endTime) {
        int firstIndex = -1;
        int lastIndex = -1;
        int cacheSize = this.objectCache.size();
        if (cacheSize <= 0) return new Vector();
        try {
            if (beginTime <= 0L) {
                if (endTime <= 0L) return this.getAllObjects();
                firstIndex = 0;
                int i = 0;
                while (i < cacheSize) {
                    long objectTime = this.getObject(i).getTimeGenerated();
                    if (objectTime <= endTime) {
                        lastIndex = i++;
                        continue;
                    }
                    break;
                }
            } else if (endTime <= 0L) {
                int i = lastIndex = cacheSize - 1;
                while (i >= 0) {
                    long objectTime = this.getObject(i).getTimeGenerated();
                    if (objectTime >= beginTime) {
                        firstIndex = i--;
                        continue;
                    }
                    break;
                }
            } else {
                int i = 0;
                while (i < cacheSize) {
                    long objectTime = this.getObject(i).getTimeGenerated();
                    if (objectTime >= beginTime) {
                        if (objectTime > endTime) break;
                        if (firstIndex < 0) {
                            firstIndex = i;
                        }
                        lastIndex = i;
                    }
                    ++i;
                }
            }
            if (firstIndex < 0 || lastIndex < 0) return new Vector();
            return this.objectCache.getValuesVector(firstIndex, lastIndex + 1);
        }
        catch (Exception ex) {
            if (this.logObj == null) return new Vector();
            this.logObj.warning(this.getLogPrefixString() + " error accessing cache:  " + ex);
        }
        return new Vector();
    }

    public void close() {
        this.objectCache.clear();
    }

    public static class BasicTimeObjectEntry
    implements TimeObjectEntry {
        protected final long timeGenerated;
        protected final Object dataObj;
        protected final String dataStr;

        public BasicTimeObjectEntry(long timeGenerated, Object dataObj, String dataStr) {
            this.timeGenerated = timeGenerated;
            this.dataObj = dataObj;
            this.dataStr = dataStr;
        }

        public long getTimeGenerated() {
            return this.timeGenerated;
        }

        public Object getDataObj() {
            return this.dataObj;
        }

        public String getDataStr() {
            return this.dataStr;
        }
    }

    public static interface TimeObjectEntry {
        public long getTimeGenerated();

        public Object getDataObj();

        public String getDataStr();
    }
}

