/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class IstiSound
implements LineListener,
ActionListener {
    protected final Clip clip;
    protected Calendar cal;
    static /* synthetic */ Class class$javax$sound$sampled$Clip;

    public IstiSound(File file) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(AudioSystem.getAudioInputStream(file));
    }

    public IstiSound(URL url) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this(AudioSystem.getAudioInputStream(url));
    }

    protected IstiSound(AudioInputStream audiosource) throws IOException, LineUnavailableException {
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$Clip == null ? (class$javax$sound$sampled$Clip = IstiSound.class$("javax.sound.sampled.Clip")) : class$javax$sound$sampled$Clip, audiosource.getFormat());
        this.clip = (Clip)AudioSystem.getLine(info);
        this.clip.open(audiosource);
        this.clip.addLineListener(this);
        this.cal = null;
    }

    public static boolean isSoundFile(File file) {
        try {
            AudioSystem.getAudioFileFormat(file);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public static boolean isSoundFile(URL url) {
        try {
            AudioSystem.getAudioFileFormat(url);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public boolean isActive() {
        return this.clip.isActive();
    }

    public synchronized void loop() {
        this.clip.loop(-1);
    }

    public synchronized void loop(int count) {
        this.clip.loop(count);
    }

    public synchronized void play() {
        this.reset();
        this.start();
    }

    public synchronized void play(int seconds) {
        boolean firstTime = this.cal == null;
        this.cal = null;
        this.cal = Calendar.getInstance();
        this.cal.add(13, seconds);
        if (firstTime) {
            this.play();
        }
    }

    public synchronized void update(LineEvent lineEvent) {
        LineEvent.Type type = lineEvent.getType();
        if (type.equals(LineEvent.Type.STOP)) {
            if (Calendar.getInstance().before(this.cal)) {
                this.play();
            } else {
                this.cal = null;
            }
        } else if (type.equals(LineEvent.Type.CLOSE) || type.equals(LineEvent.Type.OPEN) || type.equals(LineEvent.Type.START)) {
            // empty if block
        }
    }

    public synchronized void actionPerformed(ActionEvent e) {
        this.play();
    }

    public synchronized void reset() {
        this.clip.setFramePosition(0);
    }

    public synchronized void start() {
        this.clip.start();
    }

    public synchronized void stop() {
        this.cal = null;
        this.clip.stop();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

