/*
 * Decompiled with CFR 0.152.
 */
package com.isti.util;

import com.isti.util.FileUtils;
import com.isti.util.IstiTimeObjectCache;
import com.isti.util.LogFile;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class IstiMessageObjectCache
extends IstiTimeObjectCache {
    protected long lastMsgNum;
    protected final String msgNumFileName;
    protected RandomAccessFile msgNumRAFileObj;
    protected FileDescriptor msgNumFDescObj;
    protected final Object msgNumFileSyncObj;

    public IstiMessageObjectCache(LogFile logObj, long tolerance) {
        this(logObj, tolerance, 0L);
    }

    public IstiMessageObjectCache(LogFile logObj, long tolerance, long removeAge) {
        this(logObj, tolerance, removeAge, null);
    }

    public IstiMessageObjectCache(LogFile logObj, long tolerance, long removeAge, String msgNumFileName) {
        block4: {
            super(logObj, tolerance, removeAge);
            this.lastMsgNum = 0L;
            this.msgNumRAFileObj = null;
            this.msgNumFDescObj = null;
            this.msgNumFileSyncObj = new Object();
            this.msgNumFileName = msgNumFileName;
            if (msgNumFileName == null) break block4;
            if (new File(msgNumFileName).exists()) {
                this.readMsgNumFile();
            } else {
                this.getLogFile().info(this.getLogPrefixString() + " creating last-message number file " + msgNumFileName);
            }
            try {
                this.msgNumRAFileObj = new RandomAccessFile(msgNumFileName, "rw");
                this.msgNumFDescObj = this.msgNumRAFileObj.getFD();
            }
            catch (Exception ex) {
                this.msgNumRAFileObj = null;
                this.getLogFile().warning(this.getLogPrefixString() + " error opening message-number file \"" + msgNumFileName + "\":  " + ex);
            }
        }
    }

    public void addMessage(long timeGenerated, Object msgObj, String msgStr, long msgNum) {
        this.lastMsgNum = msgNum;
        this.writeMsgNumFile();
        this.add(new MessageObjectEntry(timeGenerated, msgObj, msgStr, msgNum));
    }

    public Vector getNewerMessages(long time, long msgNum) {
        return this.getMessages(time, msgNum, 0L, 0L);
    }

    public Vector getMessages(long beginTime, long beginMsgNum, long endTime, long endMsgNum) {
        return this.subListVector(beginTime, beginMsgNum, endTime, endMsgNum);
    }

    public Vector getOlderMessages(long time, long msgNum) {
        return this.getMessages(0L, 0L, time, msgNum);
    }

    public long getLastMsgNum() {
        return this.lastMsgNum;
    }

    protected String getLogPrefixString() {
        return "IstiMessageObjectCache";
    }

    protected MessageObjectEntry getMessage(int index) {
        return (MessageObjectEntry)this.objectCache.elementAt(index);
    }

    protected long getMsgTime(long msgNum) {
        int i = this.objectCache.size() - 1;
        while (i >= 0) {
            MessageObjectEntry objectEntry = this.getMessage(i);
            long objectMsgNum = objectEntry.getMsgNum();
            if (objectMsgNum == msgNum) {
                return objectEntry.getTimeGenerated();
            }
            if (objectMsgNum < msgNum) break;
            --i;
        }
        return 0L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Vector subListVector(long beginTime, long beginMsgNum, long endTime, long endMsgNum) {
        boolean useMsgNum = false;
        if (beginMsgNum > 0L && beginTime > 0L || endMsgNum > 0L && endTime > 0L) {
            useMsgNum = true;
            if (beginTime > 0L && (beginMsgNum <= 0L || this.getMsgTime(beginMsgNum) != beginTime)) {
                useMsgNum = false;
            }
            if (endTime > 0L && (endMsgNum <= 0L || this.getMsgTime(endMsgNum) != endTime)) {
                useMsgNum = false;
            }
        }
        if (!useMsgNum) {
            return this.getObjects(beginTime, endTime);
        }
        int firstIndex = -1;
        int lastIndex = -1;
        int cacheSize = this.objectCache.size();
        if (cacheSize <= 0) return new Vector();
        try {
            if (beginMsgNum <= 0L) {
                if (endMsgNum <= 0L) return this.getAllObjects();
                firstIndex = 0;
                int i = 0;
                while (i < cacheSize) {
                    long objectMsgNum = this.getMessage(i).getMsgNum();
                    if (objectMsgNum < endMsgNum) {
                        lastIndex = i++;
                        continue;
                    }
                    break;
                }
            } else if (endMsgNum <= 0L) {
                int i = lastIndex = cacheSize - 1;
                while (i >= 0) {
                    long objectMsgNum = this.getMessage(i).getMsgNum();
                    if (objectMsgNum > beginMsgNum) {
                        firstIndex = i--;
                        continue;
                    }
                    break;
                }
            } else {
                int i = 0;
                while (i < cacheSize) {
                    long objectMsgNum = this.getMessage(i).getMsgNum();
                    if (objectMsgNum > beginMsgNum) {
                        if (objectMsgNum >= endMsgNum) break;
                        if (firstIndex < 0) {
                            firstIndex = i;
                        }
                        lastIndex = i;
                    }
                    ++i;
                }
            }
            if (firstIndex < 0 || lastIndex < 0) return new Vector();
            return this.objectCache.getValuesVector(firstIndex, lastIndex + 1);
        }
        catch (Exception ex) {
            if (this.logObj == null) return new Vector();
            this.logObj.warning(this.getLogPrefixString() + " error accessing cache:  " + ex);
        }
        return new Vector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readMsgNumFile() {
        if (this.msgNumFileName == null) {
            return;
        }
        Object object = this.msgNumFileSyncObj;
        synchronized (object) {
            try {
                String msgNumStr = FileUtils.readFileToString(this.msgNumFileName).trim();
                this.lastMsgNum = msgNumStr.length() > 0 ? Long.parseLong(msgNumStr) : 0L;
                this.getLogFile().info(this.getLogPrefixString() + " last message number was " + this.lastMsgNum);
            }
            catch (Exception ex) {
                this.getLogFile().warning(this.getLogPrefixString() + " error reading last message number:  " + ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMsgNumFile() {
        Object object = this.msgNumFileSyncObj;
        synchronized (object) {
            if (this.msgNumRAFileObj != null) {
                this.getLogFile().debug3(this.getLogPrefixString() + " last message number is " + this.lastMsgNum);
                try {
                    this.msgNumRAFileObj.setLength(0L);
                    this.msgNumRAFileObj.writeBytes(Long.toString(this.lastMsgNum));
                    this.msgNumFDescObj.sync();
                }
                catch (Exception ex) {
                    this.getLogFile().warning(this.getLogPrefixString() + " error writing last message number:  " + ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        Object object = this.msgNumFileSyncObj;
        synchronized (object) {
            if (this.msgNumRAFileObj != null) {
                try {
                    this.msgNumRAFileObj.close();
                }
                catch (IOException ex) {
                    // empty catch block
                }
                this.msgNumRAFileObj = null;
            }
        }
    }

    public static class MessageObjectEntry
    extends IstiTimeObjectCache.BasicTimeObjectEntry {
        protected final long msgNum;

        public MessageObjectEntry(long timeGenerated, Object msgObj, String msgStr, long msgNum) {
            super(timeGenerated, msgObj, msgStr);
            this.msgNum = msgNum;
        }

        public long getMsgNum() {
            return this.msgNum;
        }
    }
}

